/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;

class CompoundBreakCycles
extends GraphVisitor {
    private NodeList graphNodes;
    private final NodeList sL = new NodeList();

    CompoundBreakCycles() {
    }

    private static boolean allFlagged(NodeList nodes) {
        return nodes.stream().allMatch(n -> n.flag);
    }

    private static int buildNestingTreeIndices(NodeList nodes, int base) {
        for (Node node : nodes) {
            if (node instanceof Subgraph) {
                Subgraph s = (Subgraph)node;
                s.nestingTreeMin = base;
                base = CompoundBreakCycles.buildNestingTreeIndices(s.members, base);
            }
            node.nestingIndex = base++;
        }
        return base++;
    }

    private static boolean canBeRemoved(Node n) {
        return !n.flag && CompoundBreakCycles.getChildCount(n) == 0;
    }

    private static boolean changeInDegree(Node n, int delta) {
        n.workingInts[1] = n.workingInts[1] + delta;
        return n.workingInts[1] == 0;
    }

    private static boolean changeOutDegree(Node n, int delta) {
        n.workingInts[2] = n.workingInts[2] + delta;
        return n.workingInts[2] == 0;
    }

    private void cycleRemove(NodeList children) {
        NodeList sR = new NodeList();
        do {
            CompoundBreakCycles.findSinks(children, sR);
            this.findSources(children);
            Node max = CompoundBreakCycles.findNodeWithMaxDegree(children);
            if (max == null) continue;
            for (Node child : children) {
                if (child.flag) continue;
                if (child == max) {
                    CompoundBreakCycles.restoreSinks(max, sR);
                    continue;
                }
                this.restoreSources(child);
            }
            this.remove(max);
        } while (!CompoundBreakCycles.allFlagged(children));
        while (!sR.isEmpty()) {
            this.sL.add((Node)sR.remove(sR.size() - 1));
        }
    }

    private static void findInitialSinks(NodeList children, NodeList sinks) {
        for (Node node : children) {
            if (node.flag) continue;
            if (CompoundBreakCycles.isSink(node) && CompoundBreakCycles.canBeRemoved(node)) {
                sinks.add(node);
                node.flag = true;
            }
            if (!(node instanceof Subgraph)) continue;
            Subgraph s = (Subgraph)node;
            CompoundBreakCycles.findInitialSinks(s.members, sinks);
        }
    }

    private static void findInitialSources(NodeList children, NodeList sources) {
        for (Node node : children) {
            if (CompoundBreakCycles.isSource(node) && CompoundBreakCycles.canBeRemoved(node)) {
                sources.add(node);
                node.flag = true;
            }
            if (!(node instanceof Subgraph)) continue;
            Subgraph s = (Subgraph)node;
            CompoundBreakCycles.findInitialSources(s.members, sources);
        }
    }

    private static Node findNodeWithMaxDegree(NodeList nodes) {
        int max = Integer.MIN_VALUE;
        Node maxNode = null;
        for (Node node : nodes) {
            int degree;
            if (node.flag || (degree = CompoundBreakCycles.getNestedOutDegree(node) - CompoundBreakCycles.getNestedInDegree(node)) < max || node.flag) continue;
            max = degree;
            maxNode = node;
        }
        return maxNode;
    }

    private static void findSinks(NodeList children, NodeList rightList) {
        NodeList sinks = new NodeList();
        CompoundBreakCycles.findInitialSinks(children, sinks);
        while (!sinks.isEmpty()) {
            Node sink = (Node)sinks.get(sinks.size() - 1);
            rightList.add(sink);
            sinks.remove(sink);
            CompoundBreakCycles.removeSink(sink, sinks);
            if (sink.getParent() == null) continue;
            Subgraph parent = sink.getParent();
            CompoundBreakCycles.setChildCount(parent, CompoundBreakCycles.getChildCount(parent) - 1);
            if (!CompoundBreakCycles.isSink(parent) || !CompoundBreakCycles.canBeRemoved(parent)) continue;
            sinks.add(parent);
            parent.flag = true;
        }
    }

    private void findSources(NodeList children) {
        NodeList sources = new NodeList();
        CompoundBreakCycles.findInitialSources(children, sources);
        while (!sources.isEmpty()) {
            Node source = (Node)sources.get(sources.size() - 1);
            this.sL.add(source);
            sources.remove(source);
            CompoundBreakCycles.removeSource(source, sources);
            if (source.getParent() == null) continue;
            Subgraph parent = source.getParent();
            CompoundBreakCycles.setChildCount(parent, CompoundBreakCycles.getChildCount(parent) - 1);
            if (!CompoundBreakCycles.isSource(parent) || !CompoundBreakCycles.canBeRemoved(parent)) continue;
            sources.add(parent);
            parent.flag = true;
        }
    }

    private static int getChildCount(Node n) {
        return n.workingInts[3];
    }

    private static int getInDegree(Node n) {
        return n.workingInts[1];
    }

    private static int getNestedInDegree(Node n) {
        int result = CompoundBreakCycles.getInDegree(n);
        if (n instanceof Subgraph) {
            Subgraph s = (Subgraph)n;
            for (Node node : s.members) {
                if (node.flag) continue;
                result += CompoundBreakCycles.getInDegree(node);
            }
        }
        return result;
    }

    private static int getNestedOutDegree(Node n) {
        int result = CompoundBreakCycles.getOutDegree(n);
        if (n instanceof Subgraph) {
            Subgraph s = (Subgraph)n;
            for (Node node : s.members) {
                if (node.flag) continue;
                result += CompoundBreakCycles.getOutDegree(node);
            }
        }
        return result;
    }

    private static int getOrderIndex(Node n) {
        return n.workingInts[0];
    }

    private static int getOutDegree(Node n) {
        return n.workingInts[2];
    }

    private static void initializeDegrees(DirectedGraph g) {
        g.nodes.resetFlags();
        g.edges.resetFlags(false);
        for (Node n : g.nodes) {
            CompoundBreakCycles.setInDegree(n, n.incoming.size());
            CompoundBreakCycles.setOutDegree(n, n.outgoing.size());
            if (n instanceof Subgraph) {
                Subgraph s = (Subgraph)n;
                CompoundBreakCycles.setChildCount(n, s.members.size());
                continue;
            }
            CompoundBreakCycles.setChildCount(n, 0);
        }
    }

    private void invertEdges(DirectedGraph g) {
        int orderIndex = 0;
        for (Node element : this.sL) {
            CompoundBreakCycles.setOrderIndex(element, orderIndex);
            ++orderIndex;
        }
        for (Edge e : g.edges) {
            if (CompoundBreakCycles.getOrderIndex(e.source) <= CompoundBreakCycles.getOrderIndex(e.target) || e.source.isNested(e.target) || e.target.isNested(e.source)) continue;
            e.invert();
            e.isFeedback = true;
        }
    }

    private static void isolateSubgraph(Subgraph subgraph, Node member) {
        for (Edge edge : member.incoming) {
            if (subgraph.isNested(edge.source) || edge.flag) continue;
            CompoundBreakCycles.removeEdge(edge);
        }
        for (Edge edge : member.outgoing) {
            if (subgraph.isNested(edge.target) || edge.flag) continue;
            CompoundBreakCycles.removeEdge(edge);
        }
        if (member instanceof Subgraph) {
            Subgraph s = (Subgraph)member;
            s.members.forEach(n -> CompoundBreakCycles.isolateSubgraph(subgraph, n));
        }
    }

    private static boolean isSink(Node n) {
        return CompoundBreakCycles.getOutDegree(n) == 0 && (n.getParent() == null || CompoundBreakCycles.isSink(n.getParent()));
    }

    private static boolean isSource(Node n) {
        return CompoundBreakCycles.getInDegree(n) == 0 && (n.getParent() == null || CompoundBreakCycles.isSource(n.getParent()));
    }

    private void remove(Node n) {
        n.flag = true;
        if (n.getParent() != null) {
            CompoundBreakCycles.setChildCount(n.getParent(), CompoundBreakCycles.getChildCount(n.getParent()) - 1);
        }
        CompoundBreakCycles.removeSink(n, null);
        CompoundBreakCycles.removeSource(n, null);
        this.sL.add(n);
        if (n instanceof Subgraph) {
            Subgraph s = (Subgraph)n;
            CompoundBreakCycles.isolateSubgraph(s, s);
            this.cycleRemove(s.members);
        }
    }

    private static boolean removeEdge(Edge e) {
        if (e.flag) {
            return false;
        }
        e.flag = true;
        CompoundBreakCycles.changeOutDegree(e.source, -1);
        CompoundBreakCycles.changeInDegree(e.target, -1);
        return true;
    }

    private static void removeParentChildEdges(DirectedGraph g) {
        g.edges.stream().filter(e -> e.source.isNested(e.target) || e.target.isNested(e.source)).forEach(CompoundBreakCycles::removeEdge);
    }

    private static void removeSink(Node sink, NodeList allSinks) {
        for (Edge e : sink.incoming) {
            if (e.flag) continue;
            CompoundBreakCycles.removeEdge(e);
            Node source = e.source;
            if (allSinks == null || !CompoundBreakCycles.isSink(source) || !CompoundBreakCycles.canBeRemoved(source)) continue;
            allSinks.add(source);
            source.flag = true;
        }
    }

    private static void removeSource(Node n, NodeList allSources) {
        for (Edge e : n.outgoing) {
            if (e.flag) continue;
            e.flag = true;
            CompoundBreakCycles.changeInDegree(e.target, -1);
            CompoundBreakCycles.changeOutDegree(e.source, -1);
            Node target = e.target;
            if (allSources == null || !CompoundBreakCycles.isSource(target) || !CompoundBreakCycles.canBeRemoved(target)) continue;
            allSources.add(target);
            target.flag = true;
        }
    }

    private static boolean restoreEdge(Edge e) {
        if (!e.flag || e.source.flag || e.target.flag) {
            return false;
        }
        e.flag = false;
        CompoundBreakCycles.changeOutDegree(e.source, 1);
        CompoundBreakCycles.changeInDegree(e.target, 1);
        return true;
    }

    private static void restoreSinks(Node node, NodeList sR) {
        if (node.flag && sR.contains(node)) {
            node.flag = false;
            if (node.getParent() != null) {
                CompoundBreakCycles.setChildCount(node.getParent(), CompoundBreakCycles.getChildCount(node.getParent()) + 1);
            }
            sR.remove(node);
            node.incoming.forEach(CompoundBreakCycles::restoreEdge);
            node.outgoing.forEach(CompoundBreakCycles::restoreEdge);
        }
        if (node instanceof Subgraph) {
            Subgraph s = (Subgraph)node;
            s.members.forEach(n -> CompoundBreakCycles.restoreSinks(n, sR));
        }
    }

    private void restoreSources(Node node) {
        if (node.flag && this.sL.contains(node)) {
            node.flag = false;
            if (node.getParent() != null) {
                CompoundBreakCycles.setChildCount(node.getParent(), CompoundBreakCycles.getChildCount(node.getParent()) + 1);
            }
            this.sL.remove(node);
            node.incoming.forEach(CompoundBreakCycles::restoreEdge);
            node.outgoing.forEach(CompoundBreakCycles::restoreEdge);
        }
        if (node instanceof Subgraph) {
            Subgraph s = (Subgraph)node;
            s.members.forEach(this::restoreSources);
        }
    }

    @Override
    public void revisit(DirectedGraph g) {
        g.edges.stream().filter(Edge::isFeedback).forEach(Edge::invert);
    }

    private static void setChildCount(Node n, int count) {
        n.workingInts[3] = count;
    }

    private static void setInDegree(Node n, int deg) {
        n.workingInts[1] = deg;
    }

    private static void setOrderIndex(Node n, int index) {
        n.workingInts[0] = index;
    }

    private static void setOutDegree(Node n, int deg) {
        n.workingInts[2] = deg;
    }

    @Override
    public void visit(DirectedGraph g) {
        CompoundBreakCycles.initializeDegrees(g);
        this.graphNodes = g.nodes;
        NodeList roots = new NodeList();
        this.graphNodes.stream().filter(n -> n.getParent() == null).forEach(n -> {
            boolean bl = roots.add(n);
        });
        CompoundBreakCycles.buildNestingTreeIndices(roots, 0);
        CompoundBreakCycles.removeParentChildEdges(g);
        this.cycleRemove(roots);
        this.invertEdges(g);
    }
}

