"""condition data to text

Revision ID: 391de8e3c453
Revises: 4423dd3f90be
Create Date: 2024-12-05 18:36:41.627258+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '391de8e3c453'
down_revision = '4423dd3f90be'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('condition', 'data',
               existing_type=sa.VARCHAR(length=50),
               type_=sa.Text(),
               existing_nullable=True)
    # ### end Alembic commands ###


def downgrade():
    # Truncate values that exceed 50 characters
    op.execute("""
            UPDATE condition
            SET data = LEFT(data, 50)
            WHERE LENGTH(data) > 50
        """)
    op.alter_column('condition', 'data',
               existing_type=sa.Text(),
               type_=sa.VARCHAR(length=50),
               existing_nullable=True)
    # ### end Alembic commands ###
