#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Darkest Dungeon expansions:
# - Musketeer
# - The Crimson Court
# - The Shieldbreaker
# - The Color of Madness
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250531.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='darkest-dungeon'
GAME_NAME='Darkest Dungeon'

EXPANSION_ID_MUSKETEER='musketeer'
EXPANSION_NAME_MUSKETEER='Musketeer'

EXPANSION_ID_CRIMSONCOURT='crimson-court'
EXPANSION_NAME_CRIMSONCOURT='The Crimson Court'

EXPANSION_ID_SHIELDBREAKER='shieldbreaker'
EXPANSION_NAME_SHIELDBREAKER='The Shieldbreaker'

EXPANSION_ID_COLOROFMADNESS='color-of-madness'
EXPANSION_NAME_COLOROFMADNESS='The Color of Madness'

# Archives

## Musketeer

## This build is the one provided by GOG since 2025-05-29,
## but it is an old build from 2018.
ARCHIVE_BASE_MUSKETEER_6_NAME='darkest_dungeon_musketeer_24788_82473.sh'
ARCHIVE_BASE_MUSKETEER_6_MD5='3af92d89c085c91d7e654da2171c70a8'
ARCHIVE_BASE_MUSKETEER_6_SIZE='20500'
ARCHIVE_BASE_MUSKETEER_6_VERSION='24788-gog82473'
ARCHIVE_BASE_MUSKETEER_6_URL='https://www.gog.com/game/darkest_dungeon_musketeer'

ARCHIVE_BASE_MUSKETEER_5_NAME='darkest_dungeon_musketeer_26186_81633.sh'
ARCHIVE_BASE_MUSKETEER_5_MD5='c7f10e04a57302b89f6793768f9fc1de'
ARCHIVE_BASE_MUSKETEER_5_SIZE='20500'
ARCHIVE_BASE_MUSKETEER_5_VERSION='26186-gog81633'

ARCHIVE_BASE_MUSKETEER_4_NAME='darkest_dungeon_musketeer_24839_28859.sh'
ARCHIVE_BASE_MUSKETEER_4_MD5='ee9980710f2d4e229b5b2afb22918dac'
ARCHIVE_BASE_MUSKETEER_4_SIZE='22000'
ARCHIVE_BASE_MUSKETEER_4_VERSION='24839-gog28859'

ARCHIVE_BASE_MUSKETEER_3_NAME='darkest_dungeon_musketeer_24788_26004.sh'
ARCHIVE_BASE_MUSKETEER_3_MD5='2e24f30855bd6404f940d66d0b1b44d9'
ARCHIVE_BASE_MUSKETEER_3_SIZE='22000'
ARCHIVE_BASE_MUSKETEER_3_VERSION='24788-gog26004'

ARCHIVE_BASE_MUSKETEER_2_NAME='darkest_dungeon_musketeer_dlc_en_24358_23005.sh'
ARCHIVE_BASE_MUSKETEER_2_MD5='c8ebb84ab177b4ffcee79faadd8f5981'
ARCHIVE_BASE_MUSKETEER_2_SIZE='22000'
ARCHIVE_BASE_MUSKETEER_2_VERSION='24358-gog23005'

ARCHIVE_BASE_MUSKETEER_1_NAME='darkest_dungeon_musketeer_dlc_en_24154_22522.sh'
ARCHIVE_BASE_MUSKETEER_1_MD5='d68e50da94cc01920759ff7009a7a3c2'
ARCHIVE_BASE_MUSKETEER_1_SIZE='22000'
ARCHIVE_BASE_MUSKETEER_1_VERSION='24154-gog22522'

ARCHIVE_BASE_MUSKETEER_0_NAME='darkest_dungeon_musketeer_dlc_en_23885_21662.sh'
ARCHIVE_BASE_MUSKETEER_0_MD5='f9362568f7e4e1fd205835c3dba2083e'
ARCHIVE_BASE_MUSKETEER_0_SIZE='22000'
ARCHIVE_BASE_MUSKETEER_0_VERSION='23885-gog21662'

## The Crimson Court

## This build is the one provided by GOG since 2025-05-29,
## but it is an old build from 2018.
ARCHIVE_BASE_CRIMSONCOURT_9_NAME='darkest_dungeon_the_crimson_court_24788_82473.sh'
ARCHIVE_BASE_CRIMSONCOURT_9_MD5='1d9d53d8100eb001402a48a7a37d50a9'
ARCHIVE_BASE_CRIMSONCOURT_9_SIZE='342998'
ARCHIVE_BASE_CRIMSONCOURT_9_VERSION='24788-gog82473'
ARCHIVE_BASE_CRIMSONCOURT_9_URL='https://www.gog.com/game/darkest_dungeon_the_crimson_court'

## This build of the expansion is broken, many files are missing.
ARCHIVE_BASE_CRIMSONCOURT_8_NAME='darkest_dungeon_the_crimson_court_26186_81633.sh'
ARCHIVE_BASE_CRIMSONCOURT_8_MD5='724ec690ba5e9e92ad496bb7302e2d39'
ARCHIVE_BASE_CRIMSONCOURT_8_SIZE='95178'
ARCHIVE_BASE_CRIMSONCOURT_8_VERSION='26186-gog81633'

ARCHIVE_BASE_CRIMSONCOURT_7_NAME='darkest_dungeon_the_crimson_court_24839_28859.sh'
ARCHIVE_BASE_CRIMSONCOURT_7_MD5='bf81a16639bf98a4daa2e7eb74d2652b'
ARCHIVE_BASE_CRIMSONCOURT_7_SIZE='350000'
ARCHIVE_BASE_CRIMSONCOURT_7_VERSION='24839-gog28859'

ARCHIVE_BASE_CRIMSONCOURT_6_NAME='darkest_dungeon_the_crimson_court_24788_26004.sh'
ARCHIVE_BASE_CRIMSONCOURT_6_MD5='02618eb0e4abfc632035e429c134cc42'
ARCHIVE_BASE_CRIMSONCOURT_6_SIZE='350000'
ARCHIVE_BASE_CRIMSONCOURT_6_VERSION='24788-gog26004'

ARCHIVE_BASE_CRIMSONCOURT_5_NAME='darkest_dungeon_the_crimson_court_dlc_en_24358_23005.sh'
ARCHIVE_BASE_CRIMSONCOURT_5_MD5='344350ff10770ab3abeecabe048c9816'
ARCHIVE_BASE_CRIMSONCOURT_5_SIZE='350000'
ARCHIVE_BASE_CRIMSONCOURT_5_VERSION='24358-gog23005'

ARCHIVE_BASE_CRIMSONCOURT_4_NAME='darkest_dungeon_the_crimson_court_dlc_en_24154_22522.sh'
ARCHIVE_BASE_CRIMSONCOURT_4_MD5='985324dbc5b0ab3e00f04c24a2f2c7cf'
ARCHIVE_BASE_CRIMSONCOURT_4_SIZE='350000'
ARCHIVE_BASE_CRIMSONCOURT_4_VERSION='24154-gog22522'

ARCHIVE_BASE_CRIMSONCOURT_3_NAME='darkest_dungeon_the_crimson_court_dlc_en_23885_21662.sh'
ARCHIVE_BASE_CRIMSONCOURT_3_MD5='70018fc475ee4d24fdc19e107fa41a2a'
ARCHIVE_BASE_CRIMSONCOURT_3_SIZE='350000'
ARCHIVE_BASE_CRIMSONCOURT_3_VERSION='23885-gog21662'

ARCHIVE_BASE_CRIMSONCOURT_2_NAME='darkest_dungeon_the_crimson_court_dlc_en_21096_16065.sh'
ARCHIVE_BASE_CRIMSONCOURT_2_MD5='d4beaeb7effff0cbd2e292abf0ef5332'
ARCHIVE_BASE_CRIMSONCOURT_2_SIZE='350000'
ARCHIVE_BASE_CRIMSONCOURT_2_VERSION='21096-gog16066'

ARCHIVE_BASE_CRIMSONCOURT_1_NAME='darkest_dungeon_the_crimson_court_dlc_en_21071_15970.sh'
ARCHIVE_BASE_CRIMSONCOURT_1_MD5='67fcfc5e91763cbf20a4ef51ff7b8eff'
ARCHIVE_BASE_CRIMSONCOURT_1_SIZE='350000'
ARCHIVE_BASE_CRIMSONCOURT_1_VERSION='21071-gog15970'

ARCHIVE_BASE_CRIMSONCOURT_0_NAME='darkest_dungeon_the_crimson_court_dlc_en_20645_15279.sh'
ARCHIVE_BASE_CRIMSONCOURT_0_MD5='523c66d4575095c66a03d3859e4f83b8'
ARCHIVE_BASE_CRIMSONCOURT_0_SIZE='360000'
ARCHIVE_BASE_CRIMSONCOURT_0_VERSION='20645-gog15279'

## The Shieldbreaker

## This build is the one provided by GOG since 2025-05-29,
## but it is an old build from 2018.
ARCHIVE_BASE_SHIELDBREAKER_6_NAME='darkest_dungeon_the_shieldbreaker_24788_82473.sh'
ARCHIVE_BASE_SHIELDBREAKER_6_MD5='ec9c10ddbd4833496cfdd26d37bfe485'
ARCHIVE_BASE_SHIELDBREAKER_6_SIZE='40158'
ARCHIVE_BASE_SHIELDBREAKER_6_VERSION='24788-gog82473'
ARCHIVE_BASE_SHIELDBREAKER_6_URL='https://www.gog.com/game/darkest_dungeon_the_shieldbreaker'

ARCHIVE_BASE_SHIELDBREAKER_5_NAME='darkest_dungeon_the_shieldbreaker_26186_81633.sh'
ARCHIVE_BASE_SHIELDBREAKER_5_MD5='896d66ca296bc1b52988be55651d203a'
ARCHIVE_BASE_SHIELDBREAKER_5_SIZE='40182'
ARCHIVE_BASE_SHIELDBREAKER_5_VERSION='26186-gog81633'

ARCHIVE_BASE_SHIELDBREAKER_4_NAME='darkest_dungeon_the_shieldbreaker_24839_28859.sh'
ARCHIVE_BASE_SHIELDBREAKER_4_MD5='6d28e99b0b66d9a0b7e528b961371131'
ARCHIVE_BASE_SHIELDBREAKER_4_SIZE='42000'
ARCHIVE_BASE_SHIELDBREAKER_4_VERSION='24839-gog28859'

ARCHIVE_BASE_SHIELDBREAKER_3_NAME='darkest_dungeon_the_shieldbreaker_24788_26004.sh'
ARCHIVE_BASE_SHIELDBREAKER_3_MD5='df614551f769df6b3ee3f9f2bcfcf94e'
ARCHIVE_BASE_SHIELDBREAKER_3_SIZE='42000'
ARCHIVE_BASE_SHIELDBREAKER_3_VERSION='24788-gog26004'

ARCHIVE_BASE_SHIELDBREAKER_2_NAME='darkest_dungeon_the_shieldbreaker_dlc_en_24358_23005.sh'
ARCHIVE_BASE_SHIELDBREAKER_2_MD5='e47653b8750583df1fea96ad2c52bad2'
ARCHIVE_BASE_SHIELDBREAKER_2_SIZE='42000'
ARCHIVE_BASE_SHIELDBREAKER_2_VERSION='24358-gog23005'

ARCHIVE_BASE_SHIELDBREAKER_1_NAME='darkest_dungeon_the_shieldbreaker_dlc_en_23885_21662.sh'
ARCHIVE_BASE_SHIELDBREAKER_1_MD5='795cdfaecd19177264731d9acb0daca2'
ARCHIVE_BASE_SHIELDBREAKER_1_SIZE='41000'
ARCHIVE_BASE_SHIELDBREAKER_1_VERSION='23855-gog21662'

ARCHIVE_BASE_SHIELDBREAKER_0_NAME='darkest_dungeon_the_shieldbreaker_dlc_en_21142_16140.sh'
ARCHIVE_BASE_SHIELDBREAKER_0_MD5='8606531e5fc728786f497b4803c19994'
ARCHIVE_BASE_SHIELDBREAKER_0_SIZE='42000'
ARCHIVE_BASE_SHIELDBREAKER_0_VERSION='21142-gog16140'

## The Color of Madness

## This build is the one provided by GOG since 2025-05-29,
## but it is an old build from 2018.
ARCHIVE_BASE_COLOROFMADNESS_6_NAME='darkest_dungeon_the_color_of_madness_24788_82473.sh'
ARCHIVE_BASE_COLOROFMADNESS_6_MD5='181fb603158b512b2b2c07730f9f9c0b'
ARCHIVE_BASE_COLOROFMADNESS_6_SIZE='629673'
ARCHIVE_BASE_COLOROFMADNESS_6_VERSION='24788-gog82473'
ARCHIVE_BASE_COLOROFMADNESS_6_URL='https://www.gog.com/game/darkest_dungeon_the_color_of_madness'

ARCHIVE_BASE_COLOROFMADNESS_5_NAME='darkest_dungeon_the_color_of_madness_26186_81633.sh'
ARCHIVE_BASE_COLOROFMADNESS_5_MD5='a15a93c4a74c61b186210b97dcbc9383'
ARCHIVE_BASE_COLOROFMADNESS_5_SIZE='629799'
ARCHIVE_BASE_COLOROFMADNESS_5_VERSION='26186-gog81633'

ARCHIVE_BASE_COLOROFMADNESS_4_NAME='darkest_dungeon_the_color_of_madness_24839_28859.sh'
ARCHIVE_BASE_COLOROFMADNESS_4_MD5='9830e2b3cefc653db593a022e1c87359'
ARCHIVE_BASE_COLOROFMADNESS_4_SIZE='640000'
ARCHIVE_BASE_COLOROFMADNESS_4_VERSION='24839-gog28859'

ARCHIVE_BASE_COLOROFMADNESS_3_NAME='darkest_dungeon_the_color_of_madness_24788_26004.sh'
ARCHIVE_BASE_COLOROFMADNESS_3_MD5='a92a69e13e7ddb5da63d283ea40d93f7'
ARCHIVE_BASE_COLOROFMADNESS_3_SIZE='640000'
ARCHIVE_BASE_COLOROFMADNESS_3_VERSION='24788-gog26004'

ARCHIVE_BASE_COLOROFMADNESS_2_NAME='darkest_dungeon_the_color_of_madness_dlc_en_24358_23005.sh'
ARCHIVE_BASE_COLOROFMADNESS_2_MD5='0447fad1313ab47f6521debc3e75d308'
ARCHIVE_BASE_COLOROFMADNESS_2_SIZE='640000'
ARCHIVE_BASE_COLOROFMADNESS_2_VERSION='24358-gog23005'

ARCHIVE_BASE_COLOROFMADNESS_1_NAME='darkest_dungeon_the_color_of_madness_dlc_en_24154_22522.sh'
ARCHIVE_BASE_COLOROFMADNESS_1_MD5='40088860d8e3e3a651074e84eb2746ac'
ARCHIVE_BASE_COLOROFMADNESS_1_SIZE='630000'
ARCHIVE_BASE_COLOROFMADNESS_1_VERSION='24154-gog22522'

ARCHIVE_BASE_COLOROFMADNESS_0_NAME='darkest_dungeon_the_color_of_madness_dlc_en_23885_21662.sh'
ARCHIVE_BASE_COLOROFMADNESS_0_MD5='fe07f35c57c3ddd421db5da33b42ee6e'
ARCHIVE_BASE_COLOROFMADNESS_0_SIZE='630000'
ARCHIVE_BASE_COLOROFMADNESS_0_VERSION='23885-gog21662'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
