/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Expr;

public class Dependency {
    final Expr mDependant;
    final Expr mOther;
    final Expr mCondition;
    final boolean mExpectedOutput;
    boolean mElevated;
    boolean mMandatory = false;

    public Dependency(Expr dependant, Expr other) {
        this.mDependant = dependant;
        this.mOther = other;
        this.mCondition = null;
        this.mOther.addDependant(this);
        this.mExpectedOutput = false;
    }

    public Dependency(Expr dependant, Expr other, Expr condition, boolean expectedOutput) {
        this.mDependant = dependant;
        this.mOther = other;
        this.mCondition = condition;
        this.mOther.addDependant(this);
        this.mExpectedOutput = expectedOutput;
    }

    public void setMandatory(boolean mandatory) {
        this.mMandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mMandatory;
    }

    public boolean isConditional() {
        return this.mCondition != null && !this.mElevated;
    }

    public Expr getOther() {
        return this.mOther;
    }

    public Expr getDependant() {
        return this.mDependant;
    }

    public boolean getExpectedOutput() {
        return this.mExpectedOutput;
    }

    public Expr getCondition() {
        return this.mCondition;
    }

    public void elevate() {
        this.mElevated = true;
    }

    public boolean isElevated() {
        return this.mElevated;
    }
}

