# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Show(AAZCommand):
    """Get for Get an App Service plan.
    """

    _aaz_info = {
        "version": "2025-03-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.web/serverfarms/{}", "2025-03-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the App Service plan.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.AppServicePlansGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class AppServicePlansGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-03-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.extended_location = AAZObjectType(
                serialized_name="extendedLocation",
            )
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.identity = AAZIdentityObjectType()
            _schema_on_200.kind = AAZStrType()
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.sku = AAZObjectType()
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            extended_location = cls._schema_on_200.extended_location
            extended_location.name = AAZStrType()
            extended_location.type = AAZStrType(
                flags={"read_only": True},
            )

            identity = cls._schema_on_200.identity
            identity.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )
            identity.tenant_id = AAZStrType(
                serialized_name="tenantId",
                flags={"read_only": True},
            )
            identity.type = AAZStrType()
            identity.user_assigned_identities = AAZDictType(
                serialized_name="userAssignedIdentities",
            )

            user_assigned_identities = cls._schema_on_200.identity.user_assigned_identities
            user_assigned_identities.Element = AAZObjectType()

            _element = cls._schema_on_200.identity.user_assigned_identities.Element
            _element.client_id = AAZStrType(
                serialized_name="clientId",
                flags={"read_only": True},
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.async_scaling_enabled = AAZBoolType(
                serialized_name="asyncScalingEnabled",
            )
            properties.elastic_scale_enabled = AAZBoolType(
                serialized_name="elasticScaleEnabled",
            )
            properties.free_offer_expiration_time = AAZStrType(
                serialized_name="freeOfferExpirationTime",
            )
            properties.geo_region = AAZStrType(
                serialized_name="geoRegion",
                flags={"read_only": True},
            )
            properties.hosting_environment_profile = AAZObjectType(
                serialized_name="hostingEnvironmentProfile",
            )
            properties.hyper_v = AAZBoolType(
                serialized_name="hyperV",
            )
            properties.install_scripts = AAZListType(
                serialized_name="installScripts",
            )
            properties.is_custom_mode = AAZBoolType(
                serialized_name="isCustomMode",
            )
            properties.is_spot = AAZBoolType(
                serialized_name="isSpot",
            )
            properties.is_xenon = AAZBoolType(
                serialized_name="isXenon",
            )
            properties.kube_environment_profile = AAZObjectType(
                serialized_name="kubeEnvironmentProfile",
            )
            properties.maximum_elastic_worker_count = AAZIntType(
                serialized_name="maximumElasticWorkerCount",
            )
            properties.maximum_number_of_workers = AAZIntType(
                serialized_name="maximumNumberOfWorkers",
                flags={"read_only": True},
            )
            properties.network = AAZObjectType()
            properties.number_of_sites = AAZIntType(
                serialized_name="numberOfSites",
                flags={"read_only": True},
            )
            properties.number_of_workers = AAZIntType(
                serialized_name="numberOfWorkers",
                flags={"read_only": True},
            )
            properties.per_site_scaling = AAZBoolType(
                serialized_name="perSiteScaling",
            )
            properties.plan_default_identity = AAZObjectType(
                serialized_name="planDefaultIdentity",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.rdp_enabled = AAZBoolType(
                serialized_name="rdpEnabled",
            )
            properties.registry_adapters = AAZListType(
                serialized_name="registryAdapters",
            )
            properties.reserved = AAZBoolType()
            properties.resource_group = AAZStrType(
                serialized_name="resourceGroup",
                flags={"read_only": True},
            )
            properties.spot_expiration_time = AAZStrType(
                serialized_name="spotExpirationTime",
            )
            properties.status = AAZStrType(
                flags={"read_only": True},
            )
            properties.storage_mounts = AAZListType(
                serialized_name="storageMounts",
            )
            properties.subscription = AAZStrType(
                flags={"read_only": True},
            )
            properties.target_worker_count = AAZIntType(
                serialized_name="targetWorkerCount",
            )
            properties.target_worker_size_id = AAZIntType(
                serialized_name="targetWorkerSizeId",
            )
            properties.worker_tier_name = AAZStrType(
                serialized_name="workerTierName",
            )
            properties.zone_redundant = AAZBoolType(
                serialized_name="zoneRedundant",
            )

            hosting_environment_profile = cls._schema_on_200.properties.hosting_environment_profile
            hosting_environment_profile.id = AAZStrType()
            hosting_environment_profile.name = AAZStrType(
                flags={"read_only": True},
            )
            hosting_environment_profile.type = AAZStrType(
                flags={"read_only": True},
            )

            install_scripts = cls._schema_on_200.properties.install_scripts
            install_scripts.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.install_scripts.Element
            _element.name = AAZStrType()
            _element.source = AAZObjectType()

            source = cls._schema_on_200.properties.install_scripts.Element.source
            source.source_uri = AAZStrType(
                serialized_name="sourceUri",
            )
            source.type = AAZStrType()

            kube_environment_profile = cls._schema_on_200.properties.kube_environment_profile
            kube_environment_profile.id = AAZStrType()
            kube_environment_profile.name = AAZStrType(
                flags={"read_only": True},
            )
            kube_environment_profile.type = AAZStrType(
                flags={"read_only": True},
            )

            network = cls._schema_on_200.properties.network
            network.virtual_network_subnet_id = AAZStrType(
                serialized_name="virtualNetworkSubnetId",
            )

            plan_default_identity = cls._schema_on_200.properties.plan_default_identity
            plan_default_identity.identity_type = AAZStrType(
                serialized_name="identityType",
            )
            plan_default_identity.user_assigned_identity_resource_id = AAZStrType(
                serialized_name="userAssignedIdentityResourceId",
            )

            registry_adapters = cls._schema_on_200.properties.registry_adapters
            registry_adapters.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.registry_adapters.Element
            _element.key_vault_secret_reference = AAZObjectType(
                serialized_name="keyVaultSecretReference",
            )
            _ShowHelper._build_schema_key_vault_reference_with_status_read(_element.key_vault_secret_reference)
            _element.registry_key = AAZStrType(
                serialized_name="registryKey",
            )
            _element.type = AAZStrType()

            storage_mounts = cls._schema_on_200.properties.storage_mounts
            storage_mounts.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.storage_mounts.Element
            _element.credentials_key_vault_reference = AAZObjectType(
                serialized_name="credentialsKeyVaultReference",
            )
            _ShowHelper._build_schema_key_vault_reference_with_status_read(_element.credentials_key_vault_reference)
            _element.destination_path = AAZStrType(
                serialized_name="destinationPath",
            )
            _element.name = AAZStrType()
            _element.source = AAZStrType()
            _element.type = AAZStrType()

            sku = cls._schema_on_200.sku
            sku.capabilities = AAZListType()
            sku.capacity = AAZIntType()
            sku.family = AAZStrType()
            sku.locations = AAZListType()
            sku.name = AAZStrType()
            sku.size = AAZStrType()
            sku.sku_capacity = AAZObjectType(
                serialized_name="skuCapacity",
            )
            sku.tier = AAZStrType()

            capabilities = cls._schema_on_200.sku.capabilities
            capabilities.Element = AAZObjectType()

            _element = cls._schema_on_200.sku.capabilities.Element
            _element.name = AAZStrType()
            _element.reason = AAZStrType()
            _element.value = AAZStrType()

            locations = cls._schema_on_200.sku.locations
            locations.Element = AAZStrType()

            sku_capacity = cls._schema_on_200.sku.sku_capacity
            sku_capacity.default = AAZIntType()
            sku_capacity.elastic_maximum = AAZIntType(
                serialized_name="elasticMaximum",
            )
            sku_capacity.maximum = AAZIntType()
            sku_capacity.minimum = AAZIntType()
            sku_capacity.scale_type = AAZStrType(
                serialized_name="scaleType",
            )

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""

    _schema_key_vault_reference_with_status_read = None

    @classmethod
    def _build_schema_key_vault_reference_with_status_read(cls, _schema):
        if cls._schema_key_vault_reference_with_status_read is not None:
            _schema.reference_status = cls._schema_key_vault_reference_with_status_read.reference_status
            _schema.secret_uri = cls._schema_key_vault_reference_with_status_read.secret_uri
            return

        cls._schema_key_vault_reference_with_status_read = _schema_key_vault_reference_with_status_read = AAZObjectType()

        key_vault_reference_with_status_read = _schema_key_vault_reference_with_status_read
        key_vault_reference_with_status_read.reference_status = AAZStrType(
            serialized_name="referenceStatus",
        )
        key_vault_reference_with_status_read.secret_uri = AAZStrType(
            serialized_name="secretUri",
        )

        _schema.reference_status = cls._schema_key_vault_reference_with_status_read.reference_status
        _schema.secret_uri = cls._schema_key_vault_reference_with_status_read.secret_uri


__all__ = ["Show"]
