/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.dbvis;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.ui.config.migration.dbvis.DbvisAbstractConfigurationCreator;
import org.jkiss.dbeaver.ui.config.migration.dbvis.DbvisSshServerConfiguration;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportDriverInfo;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbvisConfigurationCreatorv233
extends DbvisAbstractConfigurationCreator {
    private static final Log log = Log.getLog(DbvisConfigurationCreatorv233.class);
    public static final String VERSION = "version.24.3.x";
    public static final String CONFIG_FOLDER = "config233";
    public static final String CONFIG_FILE = "dbvis.xml";
    public static final String SSH_CONFIG_FILE = "sshservers.xml";
    public static final Map<String, String> dbvis2dbeaverDriverNames = new HashMap<String, String>();

    static {
        dbvis2dbeaverDriverNames.put("H2 2.x Embedded", "H2 Embedded V.2");
        dbvis2dbeaverDriverNames.put("Oracle 9i", "Oracle");
        dbvis2dbeaverDriverNames.put("Db2 LUW", "Db2 for LUW");
    }

    @Override
    public ImportData create(@NotNull ImportData importData, @NotNull File configFile) throws DBException {
        try {
            Document configDocument;
            Element databasesElement;
            Document sshConfigDocument;
            Element sshServersElement;
            LinkedHashMap<String, DbvisSshServerConfiguration> sshServerConfigurations = new LinkedHashMap<String, DbvisSshServerConfiguration>();
            DbvisSshServerConfiguration sshConfiguration = null;
            File sshServersFile = new File(configFile.getParent(), SSH_CONFIG_FILE);
            if (sshServersFile.exists() && (sshServersElement = XMLUtils.getChildElement((Element)(sshConfigDocument = XMLUtils.parseDocument((File)sshServersFile)).getDocumentElement(), (String)"SshServers")) != null) {
                for (Element sshServerElement : XMLUtils.getChildElementList((Element)sshServersElement, (String)"SshServer")) {
                    DbvisSshServerConfiguration sshConfig = new DbvisSshServerConfiguration();
                    sshConfig.setId(sshServerElement.getAttribute("id"));
                    sshConfig.setName(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"Name"));
                    sshConfig.setDescription(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"Description"));
                    sshConfig.setIsEnabled(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"Enabled"));
                    sshConfig.setSshHost(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"SshHost"));
                    sshConfig.setSshPort(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"SshPort"));
                    sshConfig.setSshUserid(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"SshUserid"));
                    sshConfig.setAuthenticationType(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"AuthenticationType"));
                    sshConfig.setSshPrivateKeyFile(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"SshPrivateKeyFile"));
                    sshConfig.setSshImplementationType(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"SshImplementationType"));
                    sshConfig.setSshConfigFile(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"SshConfigFile"));
                    sshConfig.setSshKnownHostsFile(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"SshKnownHostsFile"));
                    sshConfig.setSshConnectTimeout(XMLUtils.getChildElementBody((Element)sshServerElement, (String)"SshConnectTimeout"));
                    sshServerConfigurations.put(sshConfig.getId(), sshConfig);
                }
            }
            if ((databasesElement = XMLUtils.getChildElement((Element)(configDocument = XMLUtils.parseDocument((File)configFile)).getDocumentElement(), (String)"Databases")) != null) {
                for (Element dbElement : XMLUtils.getChildElementList((Element)databasesElement, (String)"Database")) {
                    Element driverElement;
                    String alias = XMLUtils.getChildElementBody((Element)dbElement, (String)"Alias");
                    String url = XMLUtils.getChildElementBody((Element)dbElement, (String)"Url");
                    String driverName = XMLUtils.getChildElementBody((Element)dbElement, (String)"Driver");
                    String user = XMLUtils.getChildElementBody((Element)dbElement, (String)"Userid");
                    String password = null;
                    String hostName = null;
                    String port = null;
                    String database = null;
                    String type = XMLUtils.getChildElementBody((Element)dbElement, (String)"Type");
                    Element urlVarsElement = XMLUtils.getChildElement((Element)dbElement, (String)"UrlVariables");
                    ImportDriverInfo driver = null;
                    if (urlVarsElement != null && (driverElement = XMLUtils.getChildElement((Element)urlVarsElement, (String)"Driver")) != null) {
                        Element sshServers;
                        String driverId = driverElement.getAttribute("DriverId");
                        String[] driverIdSegments = driverId.split("-");
                        for (Element urlVarElement : XMLUtils.getChildElementList((Element)driverElement, (String)"UrlVariable")) {
                            String varName = urlVarElement.getAttribute("UrlVariableName");
                            String varValue = XMLUtils.getElementBody((Element)urlVarElement);
                            if ("Server".equals(varName)) {
                                hostName = varValue;
                                continue;
                            }
                            if ("Port".equals(varName)) {
                                port = varValue;
                                continue;
                            }
                            if (!"Database".equals(varName)) continue;
                            database = varValue;
                        }
                        StringBuilder builder = new StringBuilder("databaseinfo/user/driverTypes/");
                        builder.append(type).append("_").append(driverId).append("/").append("driverType").append("_").append(type).append("_").append(driverIdSegments[0]).append(".xml");
                        File driverFile = new File(configFile.getParent(), builder.toString());
                        if (driverFile.exists()) {
                            Document driverTypeDocument = XMLUtils.parseDocument((File)driverFile);
                            Element driverTypeDocumentElement = driverTypeDocument.getDocumentElement();
                            String name = XMLUtils.getChildElementBody((Element)driverTypeDocumentElement, (String)"Label");
                            String sampleURL = XMLUtils.getChildElementBody((Element)driverTypeDocumentElement, (String)"URLFormat");
                            String identifier = XMLUtils.getChildElementBody((Element)driverTypeDocumentElement, (String)"Identifier");
                            if (!CommonUtils.isEmpty((String)name) && !CommonUtils.isEmpty((String)sampleURL)) {
                                DriverDescriptor driverDescriptor = this.getDriverByName(name);
                                if (driverDescriptor != null) {
                                    driver = new ImportDriverInfo(identifier, driverDescriptor.getName(), sampleURL, driverDescriptor.getDriverClassName());
                                    this.adaptSampleUrl(driver);
                                } else {
                                    log.error((Object)("Driver descriptor not found for: " + driverName));
                                }
                            }
                        } else if (!CommonUtils.isEmpty((String)driverName)) {
                            DriverDescriptor driverDescriptor = this.getDriverByName(driverName);
                            if (driverDescriptor != null) {
                                driver = new ImportDriverInfo(driverDescriptor.getId(), driverDescriptor.getName(), driverDescriptor.getSampleURL(), driverDescriptor.getDriverClassName());
                                this.adaptSampleUrl(driver);
                            } else {
                                log.error((Object)("Driver descriptor not found for: " + driverName));
                            }
                        } else {
                            log.error((Object)("Driver descriptor not found by path: " + driverFile.getAbsolutePath()));
                        }
                        if ((sshServers = XMLUtils.getChildElement((Element)dbElement, (String)"SshServers")) != null) {
                            for (Element sshServer : XMLUtils.getChildElementList((Element)sshServers, (String)"SshServer")) {
                                String enabled = XMLUtils.getChildElementBody((Element)sshServer, (String)"Enabled");
                                if (!enabled.equals("true")) continue;
                                sshConfiguration = (DbvisSshServerConfiguration)sshServerConfigurations.get(sshServer.getAttribute("id"));
                                break;
                            }
                        }
                    }
                    if (CommonUtils.isEmpty((String)url) && CommonUtils.isEmpty(hostName)) {
                        hostName = "localhost";
                    }
                    if (!(CommonUtils.isEmpty((String)alias) || CommonUtils.isEmpty((String)driverName) || CommonUtils.isEmpty((String)url) && CommonUtils.isEmpty((String)hostName))) {
                        ImportConnectionInfo connectionInfo = new ImportConnectionInfo(driver, dbElement.getAttribute("id"), alias, url, hostName, port, database, user, password);
                        if (sshConfiguration != null) {
                            NetworkHandlerDescriptor sslHD = NetworkHandlerRegistry.getInstance().getDescriptor("ssh_tunnel");
                            DBWHandlerConfiguration sshHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)sslHD, null);
                            sshHandler.setUserName(sshConfiguration.getSshUserid());
                            sshHandler.setSavePassword(true);
                            sshHandler.setProperty("host", (Object)sshConfiguration.getSshHost());
                            sshHandler.setProperty("port", (Object)sshConfiguration.getSshPort());
                            if (sshConfiguration.getAuthenticationType() == SSHConstants.AuthType.PUBLIC_KEY) {
                                sshHandler.setProperty("authType", (Object)SSHConstants.AuthType.PUBLIC_KEY);
                                sshHandler.setProperty("keyPath", (Object)sshConfiguration.getSshPrivateKeyFile());
                            } else {
                                sshHandler.setProperty("authType", (Object)SSHConstants.AuthType.PASSWORD);
                            }
                            sshHandler.setProperty("implementation", (Object)sshConfiguration.getSshImplementationType());
                            sshHandler.setEnabled(true);
                            connectionInfo.addNetworkHandler(sshHandler);
                        }
                        importData.addConnection(connectionInfo);
                        continue;
                    }
                    log.error((Object)("Can not extract data for: " + driverName));
                }
            }
        }
        catch (XMLException e) {
            throw new DBException("Configuration parse error: " + e.getMessage());
        }
        return importData;
    }

    @Override
    public String getConfigurationFile() {
        return CONFIG_FILE;
    }

    @Override
    public String getConfigurationFolder() {
        return CONFIG_FOLDER;
    }

    @Override
    protected String substituteDriverName(String driverName) {
        String driversubstitutedName = dbvis2dbeaverDriverNames.get(driverName);
        if (driversubstitutedName == null) {
            driversubstitutedName = driverName;
        }
        return driversubstitutedName;
    }
}

