/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.array.ByteBufferAccess;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

abstract class UnsafeByteBufferAccess
extends ByteBufferAccess {
    private static final Unsafe UNSAFE;
    private static final long BUFFER_ADDRESS_FIELD_OFFSET;

    UnsafeByteBufferAccess() {
    }

    private static int checkIndex(ByteBuffer buffer, int i, int nb) {
        if (nb < 1 || i < 0 || i > buffer.limit() - nb) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    private static long getBufferAddress(ByteBuffer buffer) {
        return UNSAFE.getLong(buffer, BUFFER_ADDRESS_FIELD_OFFSET);
    }

    private static long getAddress(ByteBuffer buffer, int index) {
        return UnsafeByteBufferAccess.getBufferAddress(buffer) + (long)index;
    }

    @Override
    public int getInt16(ByteBuffer buffer, int index) {
        return UNSAFE.getShort(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 2)));
    }

    @Override
    public int getInt32(ByteBuffer buffer, int index) {
        return UNSAFE.getInt(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 4)));
    }

    @Override
    public long getInt64(ByteBuffer buffer, int index) {
        return UNSAFE.getLong(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 8)));
    }

    @Override
    public float getFloat(ByteBuffer buffer, int index) {
        return UNSAFE.getFloat(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 4)));
    }

    @Override
    public double getDouble(ByteBuffer buffer, int index) {
        return UNSAFE.getDouble(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 8)));
    }

    @Override
    public void putInt16(ByteBuffer buffer, int index, int value) {
        UNSAFE.putShort(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 2)), (short)value);
    }

    @Override
    public void putInt32(ByteBuffer buffer, int index, int value) {
        UNSAFE.putInt(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 4)), value);
    }

    @Override
    public void putInt64(ByteBuffer buffer, int index, long value) {
        UNSAFE.putLong(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 8)), value);
    }

    @Override
    public void putFloat(ByteBuffer buffer, int index, float value) {
        UNSAFE.putFloat(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 4)), value);
    }

    @Override
    public void putDouble(ByteBuffer buffer, int index, double value) {
        UNSAFE.putDouble(UnsafeByteBufferAccess.getAddress(buffer, UnsafeByteBufferAccess.checkIndex(buffer, index, 8)), value);
    }

    static {
        try {
            Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeInstance.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafeInstance.get(Unsafe.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
        }
        try {
            Field bufferAddressField = Buffer.class.getDeclaredField("address");
            BUFFER_ADDRESS_FIELD_OFFSET = UNSAFE.objectFieldOffset(bufferAddressField);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

