/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import java.lang.reflect.Proxy;

public final class JavaAccess {
    private static final String PERMISSION_JAVA_REFLECTION = "truffle.js.JavaReflection";

    private JavaAccess() {
    }

    public static boolean isReflectionClass(Class<?> type) {
        if (type == Class.class || ClassLoader.class.isAssignableFrom(type)) {
            return true;
        }
        String name = type.getName();
        return name.startsWith("java.lang.reflect.") || name.startsWith("java.lang.invoke.") || name.startsWith("java.beans.");
    }

    public static void checkReflectionAccess(Class<?> clazz, boolean isStatic, boolean allowReflection) {
        if (!allowReflection && JavaAccess.isReflectiveCheckNeeded(clazz, isStatic)) {
            throw new SecurityException("Java reflection not allowed");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && JavaAccess.isReflectiveCheckNeeded(clazz, isStatic)) {
            JavaAccess.checkReflectionPermission(sm);
        }
    }

    public static boolean isReflectiveCheckNeeded(Class<?> type, boolean isStatic) {
        if (Proxy.class.isAssignableFrom(type)) {
            if (Proxy.isProxyClass(type)) {
                return isStatic;
            }
            return true;
        }
        return JavaAccess.isReflectionClass(type);
    }

    private static void checkReflectionPermission(SecurityManager sm) {
        sm.checkPermission(new RuntimePermission(PERMISSION_JAVA_REFLECTION));
    }

    public static boolean isReflectionAllowed(TruffleLanguage.Env env) {
        if (env != null && env.isHostLookupAllowed()) {
            try {
                Object found = env.lookupHostSymbol(Class.class.getName());
                if (found != null) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static void checkAccess(Class<?>[] types, TruffleLanguage.Env env) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            boolean allowReflection = JavaAccess.isReflectionAllowed(env);
            for (Class<?> type : types) {
                JavaAccess.checkReflectionAccess(type, true, allowReflection);
            }
        }
    }
}

