/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.actions;

import com.paterva.maltego.customicons.actions.Bundle;
import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class DeleteIconsAction
extends NodeAction {
    public DeleteIconsAction() {
        this.putValue("ShortDescription", this.getName());
    }

    public String getName() {
        return Bundle.CTL_DeleteIconsAction();
    }

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        String msg = "Are you sure you want to delete the selected item(s)?";
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, Bundle.CTL_DeleteIconsAction());
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            for (Node node : nodes) {
                try {
                    node.destroy();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (node.canDestroy()) continue;
            return false;
        }
        return true;
    }

    protected String iconResource() {
        return "com/paterva/maltego/customicons/resources/Delete.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

