/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.AbstractTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.SortHelper;
import com.pinkmatter.types.DateRange;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

class DateConverter
extends AbstractTypeConverter<Date> {
    public DateConverter() {
        super("date", Date.class);
    }

    @Override
    protected void writeImpl(Date value, String field, Document to) {
        String fieldName = this.getIndexField(field);
        LongField dateField = new LongField(fieldName, value.getTime(), Field.Store.YES);
        to.add((IndexableField)dateField);
        to.add(SortHelper.createLongDocValueField(fieldName, value.getTime()));
    }

    @Override
    protected Date readImpl(IndexableField field) throws PandoraException {
        return new Date(field.numericValue().longValue());
    }

    @Override
    public SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        return new SortField[]{SortHelper.createLongSortField(this.getIndexField(property), reverse, emptyFirst)};
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) {
        PandoraFilter.Contains params;
        PandoraFilter.Contains filter = null;
        if (Date.class.isAssignableFrom(parameters.getType())) {
            if (parameters instanceof PandoraFilter.Contains) {
                params = (PandoraFilter.Contains)parameters;
                filter = new PandoraFilter.Contains(params.getProperty(), new Object[]{this.get((Date)params.getValue())});
            } else if (parameters instanceof PandoraFilter.Between) {
                params = (PandoraFilter.Between)parameters;
                filter = new PandoraFilter.Between(params.getProperty(), (Object)this.get((Date)params.getFrom()), (Object)this.get((Date)params.getTo()), params.isIncluding());
            } else if (parameters instanceof PandoraFilter.GreaterThan) {
                params = (PandoraFilter.GreaterThan)parameters;
                filter = new PandoraFilter.GreaterThan(params.getProperty(), (Object)this.get((Date)params.getValue()), params.isIncluding());
            } else if (parameters instanceof PandoraFilter.LessThan) {
                params = (PandoraFilter.LessThan)parameters;
                filter = new PandoraFilter.LessThan(params.getProperty(), (Object)this.get((Date)params.getValue()), params.isIncluding());
            }
        } else if (DateRange.class.isAssignableFrom(parameters.getType()) && (parameters instanceof PandoraFilter.Within || parameters instanceof PandoraFilter.Intersects)) {
            params = parameters;
            filter = new PandoraFilter.Between(params.getProperty(), (Object)this.get(((DateRange)params.getValue()).getFrom()), (Object)this.get(((DateRange)params.getValue()).getTo()), true);
        }
        if (filter != null) {
            String field = this.getIndexField(parameters.getProperty());
            return FilterHelper.createSimpleQuery(field, filter);
        }
        return null;
    }

    private long get(Date d) {
        return d.getTime();
    }

    private Long[] get(Date[] d) {
        Long[] longs = new Long[d.length];
        for (int i = 0; i < d.length; ++i) {
            longs[i] = this.get(d[i]);
        }
        return longs;
    }

    @Override
    protected boolean isFilterTermsSupported() {
        return true;
    }

    @Override
    protected BytesRef createFilterTerm(Date value) {
        BytesRefBuilder builder = new BytesRefBuilder();
        NumericUtils.longToPrefixCodedBytes((long)value.getTime(), (int)0, (BytesRefBuilder)builder);
        return builder.get();
    }
}

