/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageFromBase64Callback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;

class ImageFromBase64Thread
extends Thread {
    private final String _source;
    private final ImageFromBase64Callback _cb;

    public ImageFromBase64Thread(String base64, ImageFromBase64Callback cb) {
        this._source = base64;
        this._cb = cb;
    }

    @Override
    public void run() {
        try {
            BufferedImage img = ImageUtils.loadThumb((String)this._source, (int)240);
            this._cb.imageFromBase64Ready(this, img);
        }
        catch (Exception ex) {
            this._cb.imageFromBase64Failed(this, ex);
        }
    }

    public static BufferedImage getImage(String base64) throws IOException {
        BufferedImage img = null;
        try {
            img = ImageUtils.loadThumb((String)base64, (int)240);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }
}

