/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.util.Args;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

public class MachineDescriptor {
    private String _name;
    private String _displayName;
    private String _description;
    private String _author;
    private Object _data;
    private String _mimeType;
    private boolean _enabled;
    private Date _lastModified;
    private boolean _readOnly = false;
    private boolean _favorite = false;
    private Set<String> _hubItems = new LinkedHashSet<String>();

    public MachineDescriptor() {
        this(null);
    }

    public MachineDescriptor(String name) {
        this(name, null);
    }

    public MachineDescriptor(String name, String description) {
        this(name, null, description);
    }

    public MachineDescriptor(String name, String displayName, String description) {
        this._name = name;
        this._displayName = displayName;
        this.setDescription(description);
    }

    public boolean isCopy(MachineDescriptor other) {
        if (other == null) {
            return false;
        }
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        if (this._displayName == null ? other._displayName != null : !this._displayName.equals(other._displayName)) {
            return false;
        }
        if (this._description == null ? other._description != null : !this._description.equals(other._description)) {
            return false;
        }
        if (this._author == null ? other._author != null : !this._author.equals(other._author)) {
            return false;
        }
        if (!(this._data == other._data || this._data != null && this._data.equals(other._data))) {
            return false;
        }
        if (this._hubItems.size() != other._hubItems.size()) {
            return false;
        }
        return this._hubItems.containsAll(other._hubItems);
    }

    public void update(MachineDescriptor descriptor) {
        this._name = descriptor._name;
        this._displayName = descriptor._displayName;
        this._author = descriptor._author;
        this._data = descriptor._data;
        this._mimeType = descriptor._mimeType;
        this._enabled = descriptor._enabled;
        this._readOnly = descriptor._readOnly;
        this._favorite = descriptor._favorite;
        this._hubItems = new LinkedHashSet(descriptor._hubItems == null ? Collections.emptySet() : descriptor._hubItems);
        this.setDescription(descriptor._description);
        this.markDirty();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        if (this._description == null) {
            return "";
        }
        return this._description;
    }

    public void setDescription(String description) {
        this._description = this.checkLineSplitting(description);
    }

    private String checkLineSplitting(String text) {
        if (text != null) {
            text = text.replaceAll("(.*)(?<!\\\\)\\s*(\\r|\\n)", "$1\\\\$2");
        }
        return text;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this._name != null ? this._name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object other) {
        if (other instanceof MachineDescriptor) {
            return this.equals((MachineDescriptor)other);
        }
        return false;
    }

    public boolean equals(MachineDescriptor other) {
        if (other == null) {
            return false;
        }
        return !(this._name == null ? other._name != null : !this._name.equals(other._name));
    }

    public Object getData() {
        return this._data;
    }

    public void setData(Object data) {
        if (!this.areEqual(this._data, data)) {
            this._data = data;
            this.markDirty();
        }
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public void setMimeType(String mimeType) {
        if (!this.areEqual(this._mimeType, mimeType)) {
            this._mimeType = mimeType;
            this.markDirty();
        }
    }

    public String getDisplayName() {
        if (this._displayName == null) {
            return this.getName();
        }
        return this._displayName;
    }

    public void setEnabled(boolean value) {
        if (this._enabled != value) {
            this._enabled = value;
            this.markDirty();
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setDisplayName(String displayName) {
        if (!this.areEqual(this._displayName, displayName)) {
            this._displayName = displayName;
            this.markDirty();
        }
    }

    public String getAuthor() {
        return this._author;
    }

    public void setAuthor(String author) {
        if (!this.areEqual(this._author, author)) {
            this._author = author;
            this.markDirty();
        }
    }

    private void markDirty() {
        this._lastModified = new Date();
    }

    private boolean areEqual(Object s1, Object s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return s2.equals(s1);
        }
        return s1.equals(s2);
    }

    public Date getLastModified() {
        return this._lastModified;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
    }

    public void setFavorite(boolean favorite) {
        if (this._favorite != favorite) {
            this._favorite = favorite;
            this.markDirty();
        }
    }

    public boolean isFavorite() {
        return this._favorite;
    }

    public Set<String> getHubItems() {
        return Collections.unmodifiableSet(this._hubItems);
    }

    public void setHubItems(Set<String> hubItems) {
        Args.notNull(hubItems, (String)"hubItems");
        this._hubItems = new LinkedHashSet<String>(hubItems);
        this.markDirty();
    }

    public void addHubItem(String hubItem) {
        Args.notNullOrBlank((String)hubItem, (String)"hubItem");
        boolean added = this._hubItems.add(hubItem);
        if (added) {
            this.markDirty();
        }
    }

    public boolean removeHubItem(String hubItem) {
        boolean removed = this._hubItems.remove(hubItem);
        if (removed) {
            this.markDirty();
        }
        return removed;
    }

    public String getHelpUrl() {
        if (this._hubItems != null && this._hubItems.size() > 0) {
            String machineUrl;
            String hubItem = this._hubItems.iterator().next();
            HubSeedDescriptor seed = HubSeedRegistry.getDefault().getSeeds(false).getSeedForName(hubItem);
            if (seed != null && seed.getHelp() != null && (machineUrl = seed.getHelp().getMachineUrl()) != null) {
                return machineUrl.replace("${machineId}", this.getName());
            }
        }
        return null;
    }
}

