/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class CheckList
extends JList {
    private Object[] _items;

    public CheckList() {
        this(new Object[0]);
    }

    public CheckList(Object[] items) {
        this.setItems(items);
        this.setSelectionMode(0);
        this.setCellRenderer(new CheckListRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                CheckItem item;
                int index = CheckList.this.locationToIndex(me.getPoint());
                if (index < 0) {
                    return;
                }
                item.setChecked(!(item = (CheckItem)CheckList.this.getModel().getElementAt(index)).isChecked());
                CheckList.this.repaint();
                CheckList.this.fireCheckedChanged(index);
            }
        });
    }

    public Object[] getItems() {
        return this._items;
    }

    public void setItems(Object[] items) {
        this.setItems(items, new Object[0]);
    }

    protected void setItems(Object[] items, Object[] selectedItems) {
        this._items = items;
        DefaultListModel<CheckItem> model = new DefaultListModel<CheckItem>();
        for (Object o : items) {
            CheckItem item = new CheckItem(o);
            item.setChecked(CheckList.contains(selectedItems, item.getData()));
            model.addElement(item);
        }
        this.setModel(model);
    }

    protected void fireCheckedChanged(int index) {
        super.fireSelectionValueChanged(index, index, false);
    }

    @Override
    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
    }

    public Object[] getSelectedItems() {
        ArrayList<Object> result = new ArrayList<Object>();
        ListModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CheckItem item = (CheckItem)model.getElementAt(i);
            if (!item.isChecked()) continue;
            result.add(item.getData());
        }
        return result.toArray();
    }

    public void setSelectedItems(Object[] selectedItems) {
        this.setItems(this.getItems(), selectedItems);
    }

    public void selectAll() {
        this.setItems(this.getItems(), this.getItems());
    }

    public void selectNone() {
        this.setItems(this.getItems(), new Object[0]);
    }

    private static boolean contains(Object[] items, Object item) {
        if (items == null) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    private static class CheckItem {
        private Object _data;
        private boolean _checked;

        public CheckItem(Object data) {
            this._data = data;
        }

        public Object getData() {
            return this._data;
        }

        public void setData(Object data) {
            this._data = data;
        }

        public boolean isChecked() {
            return this._checked;
        }

        public void setChecked(boolean checked) {
            this._checked = checked;
        }

        public String toString() {
            return this._data.toString();
        }
    }

    private static class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private CheckListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CheckItem item = (CheckItem)value;
            this.setSelected(item.isChecked());
            if (item.getData() == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
            }
            this.setBackground(list.getBackground());
            return this;
        }
    }
}

