/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public abstract class ValidatingController<TComponent extends Component>
implements WizardDescriptor.Panel {
    public static final String CLIENT_PROP_NAME = "clientPropertyName";
    public static final String CLIENT_PROP_DESCRIPTION = "WizardPanel_contentDescription";
    public static final String CLIENT_PROP_IMAGE = "WizardPanel_icon";
    public static final String CLIENT_PROP_BG_COLOR = "WizardPanel_bgColor";
    private TComponent _component;
    private boolean _valid = true;
    private WizardDescriptor _descriptor;
    private final ChangeSupport _changeSupport = new ChangeSupport((Object)this);
    private ChangeListener _listener;
    private Map<String, Object> _clientProperties;

    public final void addChangeListener(ChangeListener l) {
        this._changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this._changeSupport.removeChangeListener(l);
    }

    protected WizardDescriptor getDescriptor() {
        return this._descriptor;
    }

    protected ChangeListener changeListener() {
        if (this._listener == null) {
            this._listener = event -> this.doValidate();
        }
        return this._listener;
    }

    public Component getComponent() {
        return this.component();
    }

    protected TComponent component() {
        if (this._component == null) {
            this._component = this.createComponent();
            if (this._component instanceof JComponent) {
                JComponent jc = (JComponent)this._component;
                for (String property : this.getClientProperties()) {
                    if (CLIENT_PROP_NAME.equals(property)) {
                        jc.setName((String)this.getClientProperty(property));
                        continue;
                    }
                    jc.putClientProperty(property, this.getClientProperty(property));
                }
            }
        }
        return this._component;
    }

    protected abstract TComponent createComponent();

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this._valid;
    }

    protected void setValid(boolean value) {
        if (value != this._valid) {
            this._valid = value;
            this.fireValidChanged();
        }
    }

    private void fireValidChanged() {
        this._changeSupport.fireChange();
    }

    protected void doValidate() {
        String error = this.getFirstError(this.component());
        this.info("");
        this.info(error);
        this.setValid(error == null);
    }

    protected String getFirstError(TComponent component) {
        return null;
    }

    protected void error(String msg) {
        this._descriptor.putProperty("WizardPanel_errorMessage", (Object)msg);
        this.fireValidChanged();
    }

    protected void info(String msg) {
        this._descriptor.putProperty("WizardPanel_infoMessage", (Object)msg);
        this.fireValidChanged();
    }

    protected void warn(String msg) {
        this._descriptor.putProperty("WizardPanel_warningMessage", (Object)msg);
        this.fireValidChanged();
    }

    public void readSettings(Object settings) {
        WizardDescriptor descriptor;
        this._descriptor = descriptor = (WizardDescriptor)settings;
        this.readSettings(descriptor);
        SwingUtilities.invokeLater(() -> this.doValidate());
    }

    public void storeSettings(Object settings) {
        WizardDescriptor descriptor = (WizardDescriptor)settings;
        this.storeSettings(descriptor);
    }

    public void putClientProperty(String name, Object value) {
        if (this._clientProperties == null) {
            this._clientProperties = new HashMap<String, Object>();
        }
        this._clientProperties.put(name, value);
    }

    public Object getClientProperty(String name) {
        if (this._clientProperties == null) {
            return null;
        }
        return this._clientProperties.get(name);
    }

    protected Set<String> getClientProperties() {
        if (this._clientProperties == null) {
            return Collections.emptySet();
        }
        return this._clientProperties.keySet();
    }

    public void setName(String name) {
        this.putClientProperty(CLIENT_PROP_NAME, name);
    }

    public String getName() {
        return (String)this.getClientProperty(CLIENT_PROP_NAME);
    }

    public void setDescription(String description) {
        this.putClientProperty(CLIENT_PROP_DESCRIPTION, description);
        this.updateComponent(CLIENT_PROP_DESCRIPTION);
    }

    private void updateComponent(String property) {
        Component comp;
        if (this._component != null && (comp = this.getComponent()) instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            jc.putClientProperty(property, this.getClientProperty(property));
        }
    }

    public void setImage(Image image) {
        this.putClientProperty(CLIENT_PROP_IMAGE, image);
        this.updateComponent(CLIENT_PROP_IMAGE);
    }

    public void setBackgroundColor(Color color) {
        this.putClientProperty(CLIENT_PROP_BG_COLOR, color);
        this.updateComponent(CLIENT_PROP_BG_COLOR);
    }

    protected abstract void readSettings(WizardDescriptor var1);

    protected abstract void storeSettings(WizardDescriptor var1);

    protected void fireNavigationChanged() {
        ChangeSupport cs = (ChangeSupport)this._clientProperties.get("maltego.navigation.changesupport");
        if (cs != null) {
            cs.fireChange();
        }
    }
}

