/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class DarculaModToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaModToolBarSeparatorUI();
    }

    @Override
    protected void installDefaults(JSeparator s) {
        LookAndFeel.installColors(s, "Separator.background", "Separator.foreground");
        LookAndFeel.installProperty(s, "opaque", Boolean.TRUE);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension s = this.getPreferredSize(c);
        Container parent = c.getParent();
        if (parent != null && parent instanceof JToolBar) {
            JToolBar toolbar = (JToolBar)parent;
            Color bg = toolbar.getBackground();
            g.setColor(bg);
            if (((JSeparator)c).getOrientation() == 1) {
                g.fillRect(0, 0, s.width, s.height);
                g.setColor(c.getForeground());
                g.drawLine(1, 1, 1, s.height - 2);
                g.setColor(c.getBackground());
                g.drawLine(2, 1, 2, s.height - 2);
            } else {
                g.fillRect(0, 0, s.width, s.height);
                g.setColor(c.getForeground());
                g.drawLine(1, 1, s.width - 2, 1);
                g.setColor(c.getBackground());
                g.drawLine(1, 2, s.width - 2, 2);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        return size;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Container parent;
        Dimension size = ((JToolBar.Separator)c).getSeparatorSize();
        if (size == null && (parent = c.getParent()) != null && parent instanceof JToolBar) {
            JToolBar toolbar = (JToolBar)parent;
            if (toolbar.getSize().height != 0 && toolbar.getSize().width != 0) {
                size = ((JSeparator)c).getOrientation() == 1 ? new Dimension(4, toolbar.getSize().height - 2) : new Dimension(toolbar.getSize().width - 2, 4);
                ((JToolBar.Separator)c).setSeparatorSize(size);
            }
        }
        super.update(g, c);
    }
}

