/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api.impl;

import com.paterva.maltego.transform.runner.api.GlobalInputProvider;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptorSet;
import com.paterva.maltego.typing.PropertyProvider;
import java.util.Collection;
import org.openide.util.lookup.Lookups;

public class DefaultGlobalInputProvider
extends GlobalInputProvider {
    private PropertyProvider _inputs;

    @Override
    public synchronized PropertyProvider getInputs() {
        if (this._inputs == null) {
            this._inputs = this.createInputs();
        }
        return this._inputs;
    }

    private PropertyProvider createInputs() {
        Collection providers = Lookups.forPath((String)"Maltego/GlobalTransformInputs").lookupAll(PropertyProvider.class);
        return new CompoundPropertyProvider(providers.toArray(new PropertyProvider[providers.size()]));
    }

    private static class CompoundPropertyProvider
    implements PropertyProvider {
        private PropertyProvider[] _providers;
        private PropertyDescriptorSet _set;

        public CompoundPropertyProvider(PropertyProvider ... providers) {
            this._providers = providers;
            this._set = new PropertyDescriptorSet();
            for (PropertyProvider provider : providers) {
                this._set.addAll(provider.getProperties());
            }
        }

        public PropertyDescriptorCollection getProperties() {
            return this._set;
        }

        public Object getValue(PropertyDescriptor descriptor) {
            for (PropertyProvider provider : this._providers) {
                if (!provider.getProperties().contains(descriptor)) continue;
                return provider.getValue(descriptor);
            }
            return null;
        }

        public void setValue(PropertyDescriptor descriptor, Object value) {
            for (PropertyProvider provider : this._providers) {
                if (!provider.getProperties().contains(descriptor)) continue;
                provider.setValue(descriptor, value);
            }
        }

        public void clear() {
            for (PropertyProvider provider : this._providers) {
                provider.clear();
            }
            this._set.clear();
        }
    }
}

