/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractBodyParser;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyType;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.IHttpHeader;
import org.xlightweb.ProtocolException;
import org.xsocket.DataConverter;

final class MultipartByteRangeMessageBodyParser
extends AbstractBodyParser {
    private static final Logger LOG = Logger.getLogger(MultipartByteRangeMessageBodyParser.class.getName());
    private final IHttpHeader header;
    private String endSeparator;
    private int separatorIdx = 0;
    private final StringBuilder stringBuilder = new StringBuilder();

    public MultipartByteRangeMessageBodyParser(AbstractHttpConnection httpConnection, IHttpHeader header) throws IOException {
        super(BodyType.IN_MEMORY, httpConnection, header);
        this.header = header;
        String contentType = header.getContentType();
        for (String token : contentType.split(";")) {
            if (!(token = token.trim()).toLowerCase().startsWith("boundary=")) continue;
            this.endSeparator = "--" + token.substring("boundary=".length(), token.length()).trim() + "--";
        }
    }

    void onException(IOException ioe, ComposedByteBuffer rawData) {
        if (!this.isComplete()) {
            this.register(new ProtocolException("error occured by parsing multipart byterange message body " + ioe.toString()));
        }
    }

    void onDisconnect() {
        if (!this.isComplete()) {
            this.setPersistent(false);
        }
        super.onDisconnect();
    }

    void doParse(ComposedByteBuffer rawData) throws IOException {
        while (rawData.available() > 0) {
            byte b = rawData.getByte();
            if (b == (byte)this.endSeparator.charAt(this.separatorIdx)) {
                ++this.separatorIdx;
                if (this.separatorIdx != this.endSeparator.length()) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("body read. set complete true");
                }
                this.stringBuilder.append(this.endSeparator);
                this.stringBuilder.append("\r\n");
                super.add(DataConverter.toByteBuffer((String)this.stringBuilder.toString(), (String)this.header.getCharacterEncoding()));
                this.setComplete();
                return;
            }
            if (this.separatorIdx > 0) {
                this.stringBuilder.append(this.endSeparator.substring(0, this.separatorIdx));
                this.separatorIdx = 0;
                continue;
            }
            this.stringBuilder.append((char)b);
        }
    }
}

