/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BadMessageException;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyType;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSession;
import org.xlightweb.IHttpSocketTimeoutHandler;
import org.xlightweb.IMessageWriter;
import org.xlightweb.InvokeOn;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.RequestHandlerBase;
import org.xlightweb.RequestHandlerInfo;
import org.xlightweb.ResponseHandlerInfo;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Execution(value=0)
public class RequestHandlerChain
extends RequestHandlerBase
implements IHttpRequestTimeoutHandler,
ILifeCycle {
    private static final Logger LOG = Logger.getLogger(RequestHandlerChain.class.getName());
    private final List<IHttpRequestHandler> handlers = new ArrayList<IHttpRequestHandler>();
    private final List<ILifeCycle> lifeCycleChain = new ArrayList<ILifeCycle>();
    private final ArrayList<IHttpRequestHandler> requestHandlerChain = new ArrayList();
    private boolean isOnRequestTimeoutPathMultithreaded = false;
    private final List<IHttpRequestTimeoutHandler> requestTimeoutHandlerChain = new ArrayList<IHttpRequestTimeoutHandler>();
    private final MultimodeExecutor executor = new MultimodeExecutor();

    public RequestHandlerChain() {
    }

    public RequestHandlerChain(List<IHttpRequestHandler> handlers) {
        for (IHttpRequestHandler hdl : handlers) {
            this.addLast(hdl);
        }
    }

    public void addFirst(IHttpRequestHandler handler) {
        this.handlers.add(0, handler);
        this.computePath();
    }

    public void addLast(IHttpRequestHandler handler) {
        this.handlers.add(handler);
        this.computePath();
    }

    public void remove(IHttpRequestHandler handler) {
        this.handlers.remove(handler);
        this.computePath();
    }

    public void clear() {
        this.handlers.clear();
        this.computePath();
    }

    public List<IHttpRequestHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    List<String> getHandlerInfo() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.handlers.size(); ++i) {
            RequestHandlerInfo info = HttpUtils.getHttpRequestHandlerInfo(this.handlers.get(i));
            result.add("[" + i + "] " + this.handlers.get(i).getClass().getSimpleName() + "#" + this.handlers.get(i).hashCode() + " (multithreaded=" + info.isRequestHandlerMultithreaded() + ", invokeOnMessageReceived=" + info.isRequestHandlerInvokeOnMessageReceived() + ")");
        }
        return result;
    }

    private void computePath() {
        this.lifeCycleChain.clear();
        this.requestHandlerChain.clear();
        this.requestTimeoutHandlerChain.clear();
        this.isOnRequestTimeoutPathMultithreaded = false;
        for (IHttpRequestHandler handler : this.handlers) {
            RequestHandlerInfo handlerInfo = HttpUtils.getHttpRequestHandlerInfo(handler);
            if (handlerInfo.isLifeCycle()) {
                this.lifeCycleChain.add((ILifeCycle)handler);
            }
            if (handlerInfo.isRequestTimeoutHandler()) {
                this.requestTimeoutHandlerChain.add((IHttpRequestTimeoutHandler)((Object)handler));
                boolean bl = this.isOnRequestTimeoutPathMultithreaded = this.isOnRequestTimeoutPathMultithreaded || handlerInfo.isRequestTimeoutHandlerMultithreaded();
            }
            if (handlerInfo.isRequestHandlerSynchronizedOnSession()) {
                handler = new SessionSynchronizedRequestHandler(handler);
            }
            if (handlerInfo.isRequestHandlerMultithreaded()) {
                handler = new MultithreadedMessageHandler(handler);
            }
            if (handlerInfo.isRequestHandlerInvokeOnMessageReceived()) {
                handler = new OnMessageHandler(handler);
            }
            this.requestHandlerChain.add(handler);
        }
    }

    public void onInit() {
        for (ILifeCycle lifeCycle : this.lifeCycleChain) {
            lifeCycle.onInit();
        }
    }

    public void onDestroy() throws IOException {
        for (ILifeCycle lifeCycle : this.lifeCycleChain) {
            lifeCycle.onDestroy();
        }
        this.executor.close();
    }

    @Override
    @InvokeOn(value=0)
    public void onRequest(IHttpExchange exchange) throws IOException {
        if (this.requestHandlerChain.isEmpty()) {
            exchange.forward(exchange.getRequest(), (IHttpResponseHandler)new HttpResponseHandler(exchange));
            return;
        }
        this.callOnRequestCallback(exchange);
    }

    private void callOnRequestCallback(IHttpExchange exchange) throws IOException {
        ChainExchange chainExchange = new ChainExchange(exchange, this.executor, exchange.getRequest(), (List)this.requestHandlerChain.clone(), new HttpResponseHandler(exchange));
        chainExchange.handle();
    }

    @Override
    public boolean onRequestTimeout(IHttpConnection httpConnection) throws IOException {
        if (this.requestTimeoutHandlerChain.isEmpty()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("no request timeout handler set. ignore callback");
            }
            return false;
        }
        if (this.isOnRequestTimeoutPathMultithreaded) {
            ((AbstractHttpConnection)httpConnection).getExecutor().processMultithreaded(new OnRequestTimeoutCaller(httpConnection));
        } else {
            ((AbstractHttpConnection)httpConnection).getExecutor().processNonthreaded(new OnRequestTimeoutCaller(httpConnection));
        }
        return true;
    }

    private boolean callOnRequestTimeoutCallback(IHttpConnection connection) throws IOException {
        for (IHttpRequestTimeoutHandler requestTimeoutHandler : this.requestTimeoutHandlerChain) {
            boolean result = requestTimeoutHandler.onRequestTimeout(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Execution(value=0)
    static final class DoNothingResponseHandler
    implements IHttpResponseHandler {
        DoNothingResponseHandler() {
        }

        public void onResponse(IHttpResponse response) throws IOException {
        }

        public void onException(IOException ioe) throws IOException {
        }
    }

    @Execution(value=0)
    private static final class ForwardingResponseHandler
    implements IHttpResponseHandler {
        private IHttpExchange exchange = null;

        public ForwardingResponseHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        public void onResponse(IHttpResponse response) throws IOException {
            this.exchange.send(response);
        }

        public void onException(IOException ioe) throws IOException {
            this.exchange.sendError(ioe);
        }
    }

    private static final class MultithreadedMessageHandler
    implements IHttpRequestHandler {
        private IHttpRequestHandler delegee = null;

        public MultithreadedMessageHandler(IHttpRequestHandler delegee) {
            this.delegee = delegee;
        }

        public void onRequest(final IHttpExchange exchange) throws IOException {
            Runnable task = new Runnable(){

                public void run() {
                    block3: {
                        try {
                            MultithreadedMessageHandler.this.delegee.onRequest(exchange);
                        }
                        catch (BadMessageException bme) {
                            exchange.sendError(bme);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block3;
                            LOG.fine("error occured by performing onRequest call back " + ioe.toString());
                        }
                    }
                }
            };
            AbstractHttpConnection con = (AbstractHttpConnection)exchange.getConnection();
            if (con != null) {
                con.getExecutor().processMultithreaded(task);
            } else {
                ((ChainExchange)exchange).getExecutor().processMultithreaded(task);
            }
        }

        public String toString() {
            return super.toString() + " (delegee: " + this.delegee.toString() + ")";
        }
    }

    private static final class SessionSynchronizedRequestHandler
    implements IHttpRequestHandler {
        private IHttpRequestHandler delegee = null;

        public SessionSynchronizedRequestHandler(IHttpRequestHandler delegee) {
            this.delegee = delegee;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRequest(IHttpExchange exchange) throws IOException {
            IHttpSession session = exchange.getSession(false);
            if (session == null) {
                this.delegee.onRequest(exchange);
            } else {
                IHttpSession iHttpSession = session;
                synchronized (iHttpSession) {
                    this.delegee.onRequest(exchange);
                }
            }
        }
    }

    @Execution(value=0)
    private static final class OnMessageHandler
    implements IHttpRequestHandler {
        private IHttpRequestHandler delegee = null;

        public OnMessageHandler(IHttpRequestHandler delegee) {
            this.delegee = delegee;
        }

        public void onRequest(final IHttpExchange exchange) throws IOException {
            NonBlockingBodyDataSource bodyDataSource;
            if (exchange.getRequest().hasBody() && !(bodyDataSource = exchange.getRequest().getNonBlockingBody()).isComplete()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    @Execution(value=0)
                    public void onComplete() throws IOException {
                        try {
                            OnMessageHandler.this.delegee.onRequest(exchange);
                        }
                        catch (BadMessageException bme) {
                            exchange.sendError(bme);
                        }
                    }
                };
                bodyDataSource.addCompleteListener(cl);
                return;
            }
            try {
                this.delegee.onRequest(exchange);
            }
            catch (BadMessageException bme) {
                exchange.sendError(400, bme.getMessage());
            }
        }
    }

    private static final class MessageWriter
    implements IMessageWriter {
        private NonBlockingBodyDataSource bodyDataSource = null;

        public MessageWriter(NonBlockingBodyDataSource bodyDataSource) {
            this.bodyDataSource = bodyDataSource;
        }

        public void flush(ByteBuffer[] bodyData, boolean isContentImmutable, IConnection.FlushMode flushMode, IWriteCompletionHandler completionHandler) throws IOException {
            this.bodyDataSource.append(isContentImmutable, bodyData, completionHandler);
        }

        public void close() throws IOException {
            this.bodyDataSource.setComplete(true);
        }

        public void destroy() {
            this.bodyDataSource.destroy();
        }

        public boolean isNetworkEndpoint() {
            return false;
        }

        public int getPendingWriteDataSize() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChainExchange
    implements IHttpExchange {
        private IHttpExchange exchange = null;
        private List<IHttpRequestHandler> requestHandlerChain = null;
        private final AbstractHttpConnection.IMultimodeExecutor executor;
        private IHttpRequest request = null;
        private IHttpResponseHandler responseHandler = null;
        private ResponseHandlerInfo responseHandlerInfo = null;

        public ChainExchange(IHttpExchange exchange, AbstractHttpConnection.IMultimodeExecutor executor, IHttpRequest request, List<IHttpRequestHandler> requestHandlerChain, IHttpResponseHandler responseHandler) {
            this.exchange = exchange;
            this.executor = executor;
            this.request = request;
            this.requestHandlerChain = requestHandlerChain;
            this.responseHandler = responseHandler;
            if (responseHandler != null) {
                this.responseHandlerInfo = HttpUtils.getResponseHandlerInfo(responseHandler);
            }
        }

        void handle() throws IOException {
            if (this.requestHandlerChain.isEmpty()) {
                IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                    @Execution(value=0)
                    public void onResponse(IHttpResponse response) throws IOException {
                        ChainExchange.this.send(response);
                    }

                    public void onException(IOException ioe) {
                        ChainExchange.this.sendError(ioe);
                    }
                };
                this.exchange.forward(this.request, respHdl);
            } else {
                final IHttpRequestHandler requestHandler = this.requestHandlerChain.remove(0);
                if (this.getRequest().hasBody() && HttpUtils.isContentTypeFormUrlencoded(this.getRequest())) {
                    this.request = HttpUtils.newFormEncodedRequestWrapper(this.request);
                    if (!this.getRequest().getNonBlockingBody().isComplete()) {
                        IBodyCompleteListener cl = new IBodyCompleteListener(){

                            @Execution(value=0)
                            public void onComplete() throws IOException {
                                ChainExchange.this.performOnRequest(requestHandler);
                            }
                        };
                        this.getRequest().getNonBlockingBody().addCompleteListener(cl);
                        return;
                    }
                }
                this.performOnRequest(requestHandler);
            }
        }

        private AbstractHttpConnection.IMultimodeExecutor getExecutor() {
            return this.executor;
        }

        private void performOnRequest(IHttpRequestHandler requestHandler) throws IOException {
            try {
                requestHandler.onRequest(this);
            }
            catch (BadMessageException bme) {
                this.exchange.sendError(400, bme.getMessage());
            }
        }

        @Override
        public IHttpConnection getConnection() {
            return this.exchange.getConnection();
        }

        @Override
        public IHttpRequest getRequest() {
            return this.request;
        }

        @Override
        public IHttpSession getSession(boolean create) {
            return this.exchange.getSession(create);
        }

        @Override
        public String encodeURL(String url) {
            return this.exchange.encodeURL(url);
        }

        @Override
        public void destroy() {
            this.exchange.destroy();
        }

        @Override
        public BodyDataSink send(IHttpResponseHeader header) throws IOException {
            if (this.responseHandler == null) {
                return new BodyDataSink((AbstractHttpConnection)this.exchange.getConnection(), this.getExecutor(this.exchange), null, "ISO-8859-1");
            }
            if (header.getContentLength() != -1) {
                header.removeHeader("Content-Length");
            }
            if (header.getTransferEncoding() == null) {
                header.setHeader("Transfer-Encoding", "chunked");
            }
            NonBlockingBodyDataSource bodyDataSource = new NonBlockingBodyDataSource(BodyType.IN_MEMORY, header.getCharacterEncoding());
            MessageWriter messageWriter = new MessageWriter(bodyDataSource);
            BodyDataSink bodyDataSink = new BodyDataSink((AbstractHttpConnection)this.exchange.getConnection(), this.getExecutor(this.exchange), messageWriter, header.getCharacterEncoding());
            this.send(new HttpResponse(header, bodyDataSource));
            return bodyDataSink;
        }

        @Override
        public BodyDataSink send(IHttpResponseHeader header, int contentLength) throws IOException {
            if (this.responseHandler == null) {
                return new BodyDataSink((AbstractHttpConnection)this.exchange.getConnection(), this.getExecutor(this.exchange), null, "ISO-8859-1");
            }
            if (header.getTransferEncoding() != null && header.getTransferEncoding().equalsIgnoreCase("chunked")) {
                header.removeHeader("Transfer-Encoding");
            }
            if (header.getContentLength() == -1) {
                header.setContentLength(contentLength);
            }
            NonBlockingBodyDataSource bodyDataSource = new NonBlockingBodyDataSource(BodyType.IN_MEMORY, header.getCharacterEncoding());
            MessageWriter messageWriter = new MessageWriter(bodyDataSource);
            BodyDataSink bodyDataSink = new BodyDataSink((AbstractHttpConnection)this.exchange.getConnection(), this.getExecutor(this.exchange), messageWriter, header.getCharacterEncoding());
            this.send(new HttpResponse(header, bodyDataSource));
            return bodyDataSink;
        }

        @Override
        public void send(final IHttpResponse response) throws IOException {
            if (this.responseHandler == null) {
                LOG.warning("response will not been send, because no response handler is assigned");
                return;
            }
            if (this.responseHandlerInfo.isResponseHandlerInvokeOnMessageReceived()) {
                IBodyCompleteListener copmleteListener = new IBodyCompleteListener(){

                    @Execution(value=0)
                    public void onComplete() throws IOException {
                        ChainExchange.this.performOnResponse(response);
                    }
                };
                response.getNonBlockingBody().addCompleteListener(copmleteListener);
            } else {
                this.performOnResponse(response);
            }
        }

        private void performOnResponse(final IHttpResponse response) throws IOException {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            ChainExchange.this.responseHandler.onResponse(response);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("error occured by performing on response on " + ChainExchange.this.responseHandler);
                        }
                    }
                }
            };
            if (this.responseHandlerInfo.isResponseHandlerMultithreaded()) {
                this.performMultithreaded(task);
            } else {
                this.performNonthreaded(task);
            }
        }

        @Override
        public void sendError(final Exception e) throws IllegalStateException {
            if (this.responseHandlerInfo.isSocketTimeoutHandler() && e instanceof SocketTimeoutException) {
                Runnable task = new Runnable(){

                    public void run() {
                        ((IHttpSocketTimeoutHandler)((Object)ChainExchange.this.responseHandler)).onException((SocketTimeoutException)e);
                    }
                };
                if (this.responseHandlerInfo.isSocketTimeoutHandlerMultithreaded()) {
                    this.performMultithreaded(task);
                } else {
                    this.performNonthreaded(task);
                }
            } else if (e instanceof IOException) {
                Runnable task = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                ChainExchange.this.responseHandler.onException((IOException)e);
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("Error occured by performing onException " + ChainExchange.this.responseHandler + ". reason: " + ioe.toString());
                            }
                        }
                    }
                };
                if (this.responseHandlerInfo.isResponseExeptionHandlerMultithreaded()) {
                    this.performMultithreaded(task);
                } else {
                    this.performNonthreaded(task);
                }
            } else if (HttpUtils.isShowDetailedError()) {
                this.sendError(500, DataConverter.toString((Throwable)e));
            } else {
                this.sendError(500);
            }
        }

        @Override
        public void sendError(int errorCode) {
            this.sendError(errorCode, HttpUtils.getReason(errorCode));
        }

        @Override
        public void sendError(int errorCode, String msg) {
            try {
                String id = "<unset>";
                if (this.exchange.getConnection() != null) {
                    id = this.exchange.getConnection().getId();
                }
                this.send(new HttpResponse(errorCode, "text/html", AbstractHttpConnection.generateErrorMessageHtml(errorCode, msg, id)));
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("could not send error message " + errorCode + " reason " + ioe.toString());
                }
                this.destroy();
            }
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader) throws IOException, ConnectException {
            return this.forward(requestHeader, (IHttpResponseHandler)new ForwardingResponseHandler(this));
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            if (requestHeader.getContentLength() != -1) {
                requestHeader.removeHeader("Content-Length");
            }
            if (requestHeader.getMethod().equalsIgnoreCase("GET") || requestHeader.getMethod().equalsIgnoreCase("HEAD")) {
                throw new IOException(requestHeader.getMethod() + " is a bodyless request");
            }
            if (requestHeader.getTransferEncoding() == null) {
                requestHeader.setHeader("Transfer-Encoding", "chunked");
            }
            NonBlockingBodyDataSource bodyDataSource = new NonBlockingBodyDataSource(BodyType.IN_MEMORY, requestHeader.getCharacterEncoding());
            HttpRequest request = new HttpRequest(requestHeader, bodyDataSource);
            MessageWriter messageWriter = new MessageWriter(bodyDataSource);
            BodyDataSink bodyDataSink = new BodyDataSink((AbstractHttpConnection)this.exchange.getConnection(), this.getExecutor(this.exchange), messageWriter, requestHeader.getCharacterEncoding());
            ChainExchange chainExchange = new ChainExchange(this.exchange, this.executor, request, this.requestHandlerChain, responseHandler);
            chainExchange.handle();
            return bodyDataSink;
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength) throws IOException, ConnectException {
            return this.forward(requestHeader, contentLength, new ForwardingResponseHandler(this));
        }

        @Override
        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            if (requestHeader.getTransferEncoding() != null && requestHeader.getTransferEncoding().equalsIgnoreCase("chunked")) {
                requestHeader.removeHeader("Transfer-Encoding");
            }
            if (requestHeader.getMethod().equalsIgnoreCase("GET") || requestHeader.getMethod().equalsIgnoreCase("HEAD")) {
                throw new IOException(requestHeader.getMethod() + " is a bodyless request");
            }
            if (requestHeader.getContentLength() == -1) {
                requestHeader.setContentLength(contentLength);
            }
            NonBlockingBodyDataSource bodyDataSource = new NonBlockingBodyDataSource(BodyType.IN_MEMORY, requestHeader.getCharacterEncoding());
            HttpRequest request = new HttpRequest(requestHeader, bodyDataSource);
            MessageWriter messageWriter = new MessageWriter(bodyDataSource);
            BodyDataSink bodyDataSink = new BodyDataSink((AbstractHttpConnection)this.exchange.getConnection(), this.getExecutor(this.exchange), messageWriter, requestHeader.getCharacterEncoding());
            ChainExchange chainExchange = new ChainExchange(this.exchange, this.executor, request, this.requestHandlerChain, responseHandler);
            chainExchange.handle();
            return bodyDataSink;
        }

        @Override
        public void forward(IHttpRequest request) throws IOException, ConnectException {
            this.forward(request, (IHttpResponseHandler)new ForwardingResponseHandler(this));
        }

        @Override
        public void forward(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            ChainExchange chainExchange = new ChainExchange(this.exchange, this.executor, request, this.requestHandlerChain, responseHandler);
            chainExchange.handle();
        }

        private void performMultithreaded(Runnable task) {
            AbstractHttpConnection con = (AbstractHttpConnection)this.exchange.getConnection();
            if (con != null) {
                con.getExecutor().processMultithreaded(task);
            } else {
                this.executor.processMultithreaded(task);
            }
        }

        private void performNonthreaded(Runnable task) {
            AbstractHttpConnection con = (AbstractHttpConnection)this.exchange.getConnection();
            if (con != null) {
                con.getExecutor().processNonthreaded(task);
            } else {
                task.run();
            }
        }

        AbstractHttpConnection.IMultimodeExecutor getExecutor(IHttpExchange exchange) {
            AbstractHttpConnection con = (AbstractHttpConnection)exchange.getConnection();
            if (con != null) {
                return con.getExecutor();
            }
            return this.executor;
        }
    }

    private static final class MultimodeExecutor
    implements AbstractHttpConnection.IMultimodeExecutor,
    Closeable {
        private ExecutorService workerpool = Executors.newCachedThreadPool();
        private final SerializedTaskQueue taskQueue = new SerializedTaskQueue();

        private MultimodeExecutor() {
        }

        public void processMultithreaded(Runnable task) {
            this.taskQueue.performMultiThreaded(task, (Executor)this.workerpool);
        }

        public void processNonthreaded(Runnable task) {
            this.taskQueue.performNonThreaded(task, (Executor)this.workerpool);
        }

        public void close() {
            this.workerpool.shutdown();
        }
    }

    private final class OnRequestTimeoutCaller
    implements Runnable {
        private IHttpConnection httpConnection = null;

        public OnRequestTimeoutCaller(IHttpConnection httpConnection) {
            this.httpConnection = httpConnection;
        }

        public void run() {
            block2: {
                try {
                    RequestHandlerChain.this.callOnRequestTimeoutCallback(this.httpConnection);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by calling onRequestTimeout callback " + ioe.toString());
                }
            }
        }
    }

    private static final class HttpResponseHandler
    implements IHttpResponseHandler {
        private IHttpExchange exchange = null;

        public HttpResponseHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        @Execution(value=0)
        public void onResponse(IHttpResponse response) throws IOException {
            this.exchange.send(response);
        }

        @Execution(value=0)
        public void onException(IOException ioe) {
            this.exchange.sendError(ioe);
        }
    }
}

