/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xlightweb.BodyDataSink;
import org.xlightweb.FutureResponseHandler;
import org.xlightweb.HttpRequest;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IFutureResponse;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.RequestHandlerChain;
import org.xlightweb.client.AutoRedirectHandler;
import org.xlightweb.client.CookieHandler;
import org.xlightweb.client.HttpClientConnection;
import org.xlightweb.client.IHttpClientEndpoint;
import org.xlightweb.client.ProxyHandler;
import org.xlightweb.client.SessionManager;
import org.xsocket.DataConverter;
import org.xsocket.ILifeCycle;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnection;
import org.xsocket.connection.NonBlockingConnectionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient
implements IHttpClientEndpoint,
IConnectionPool,
Closeable {
    private static final Logger LOG = Logger.getLogger(HttpClient.class.getName());
    public static final int DEFAULT_POOLED_IDLE_TIMEOUT_MILLIS = 10000;
    public static final int DEFAULT_POOLED_LIFE_TIMEOUT_MILLIS = 180000;
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final boolean DEFAULT_FOLLOWS_REDIRECT = false;
    public static final boolean DEFAULT_TREAT_302_REDIRECT_AS_303 = false;
    public static final Long DEFAULT_RESPONSE_TIMEOUT_SEC = Long.MAX_VALUE;
    private int maxRedirects = 5;
    private boolean isFollowsRedirect = false;
    private boolean isTreat302RedirectAs303 = false;
    public static final boolean DEFAULT_AUTOHANDLING_COOKIES = true;
    private boolean isAutohandlingCookies = true;
    private boolean isProxyActivated = false;
    private boolean isSSLSupported = false;
    private final SSLContext sslCtx;
    private long responseTimeoutMillis = Long.MAX_VALUE;
    private long bodyDataReceiveTimeoutMillis = Long.MAX_VALUE;
    private boolean isPooled = true;
    private final NonBlockingConnectionPool pool;
    private final RequestHandlerChain httpClientRequestHandlerChain = new RequestHandlerChain();
    private final AutoRedirectHandler redirectHandler = new AutoRedirectHandler(this);
    private final CookieHandler cookiesHandler = new CookieHandler();
    private final ProxyHandler proxyHandler = new ProxyHandler();
    private SessionManager sessionManager = null;
    private long lastTimeRequestSentMillis = System.currentTimeMillis();
    private TransactionLog transactionLog = new TransactionLog(0);
    private TransactionMonitor transactionMonitor = null;

    public HttpClient() {
        this((SSLContext)null, new IHttpRequestHandler[0]);
    }

    public HttpClient(IHttpRequestHandler ... interceptors) {
        this((SSLContext)null, interceptors);
    }

    public HttpClient(SSLContext sslCtx) {
        this(sslCtx, new IHttpRequestHandler[0]);
    }

    public HttpClient(SSLContext sslCtx, IHttpRequestHandler ... interceptors) {
        this.sslCtx = sslCtx;
        if (sslCtx != null) {
            this.pool = new NonBlockingConnectionPool(sslCtx);
            this.isSSLSupported = true;
        } else {
            this.pool = new NonBlockingConnectionPool();
            this.isSSLSupported = false;
        }
        this.proxyHandler.setSSLContext(sslCtx);
        this.pool.setPooledMaxIdleTimeMillis(10000);
        this.pool.setPooledMaxLifeTimeMillis(180000);
        this.sessionManager = new SessionManager();
        this.resetChain();
        for (IHttpRequestHandler interceptor : interceptors) {
            this.addInterceptor(interceptor);
        }
    }

    public void addInterceptor(IHttpRequestHandler interceptor) {
        if (interceptor instanceof ILifeCycle) {
            ((ILifeCycle)interceptor).onInit();
        }
        this.httpClientRequestHandlerChain.addLast(interceptor);
        this.resetChain();
    }

    public void setFollowsRedirect(boolean isFollowsRedirect) {
        if (this.isFollowsRedirect == isFollowsRedirect) {
            return;
        }
        this.isFollowsRedirect = isFollowsRedirect;
        this.resetChain();
    }

    public boolean getFollowsRedirect() {
        return this.isFollowsRedirect;
    }

    public void setAutoHandleCookies(boolean isAutohandlingCookies) {
        if (this.isAutohandlingCookies == isAutohandlingCookies) {
            return;
        }
        this.isAutohandlingCookies = isAutohandlingCookies;
        this.resetChain();
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHandler.setProxyHost(proxyHost);
        if (proxyHost != null && proxyHost.length() > 1) {
            this.isProxyActivated = true;
        }
        this.resetChain();
    }

    public void setProxyPort(int proxyPort) {
        this.proxyHandler.setProxyPort(proxyPort);
    }

    public void setProxySecuredHost(String proxyHost) {
        this.proxyHandler.setSecuredProxyHost(proxyHost);
        if (proxyHost != null && proxyHost.length() > 1) {
            this.isProxyActivated = true;
        }
        this.resetChain();
    }

    public void setProxySecuredPort(int proxyPort) {
        this.proxyHandler.setSecuredProxyPort(proxyPort);
    }

    public void setProxyUser(String proxyUser) {
        this.proxyHandler.setProxyUser(proxyUser);
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyHandler.setProxyPassword(proxyPassword);
    }

    private void resetChain() {
        this.httpClientRequestHandlerChain.remove(this.cookiesHandler);
        this.httpClientRequestHandlerChain.remove(this.redirectHandler);
        this.httpClientRequestHandlerChain.remove(this.proxyHandler);
        if (this.isFollowsRedirect) {
            this.httpClientRequestHandlerChain.addFirst(this.redirectHandler);
        }
        if (this.isAutohandlingCookies) {
            this.httpClientRequestHandlerChain.addFirst(this.cookiesHandler);
        }
        if (this.isProxyActivated) {
            this.httpClientRequestHandlerChain.addLast(this.proxyHandler);
        }
    }

    public boolean isAutohandleCookies() {
        return this.isAutohandlingCookies;
    }

    SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setTreat302RedirectAs303(boolean isTreat303RedirectAs302) {
        this.isTreat302RedirectAs303 = isTreat303RedirectAs302;
    }

    public boolean isTreat302RedirectAs303() {
        return this.isTreat302RedirectAs303;
    }

    int getTransactionLogMaxSize() {
        return this.transactionLog.getMaxSize();
    }

    Integer getTransactionsPending() {
        if (this.transactionMonitor != null) {
            return this.transactionMonitor.getPendingTransactions();
        }
        return null;
    }

    void setTransactionLogMaxSize(int maxSize) {
        this.transactionLog.setMaxSize(maxSize);
        this.transactionMonitor = maxSize == 0 ? null : new TransactionMonitor(this.transactionLog);
    }

    public void setWorkerpool(Executor workerpool) {
        this.pool.setWorkerpool(workerpool);
    }

    Executor getWorkerpool() {
        return this.pool.getWorkerpool();
    }

    public boolean isPooled() {
        return this.isPooled;
    }

    public void setPooled(boolean isPooled) {
        this.isPooled = isPooled;
    }

    @Override
    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        if (responseTimeoutMillis < 0L) {
            LOG.warning("try to set response time out with " + responseTimeoutMillis + ". This will be ignored");
            return;
        }
        this.responseTimeoutMillis = responseTimeoutMillis;
    }

    @Override
    public long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public final void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        this.bodyDataReceiveTimeoutMillis = bodyDataReceiveTimeoutMillis;
    }

    @Override
    public void close() throws IOException {
        this.pool.close();
        this.httpClientRequestHandlerChain.onDestroy();
        this.httpClientRequestHandlerChain.clear();
        this.sessionManager.close();
        this.sessionManager = null;
    }

    public boolean isOpen() {
        return this.pool.isOpen();
    }

    @Override
    public String getId() {
        return Integer.toString(this.hashCode());
    }

    public void addListener(ILifeCycle listener) {
        this.pool.addListener(listener);
    }

    public boolean removeListener(ILifeCycle listener) {
        return this.pool.removeListener(listener);
    }

    public void setPooledMaxIdleTimeMillis(int idleTimeoutMillis) {
        this.pool.setPooledMaxIdleTimeMillis(idleTimeoutMillis);
    }

    public int getPooledMaxIdleTimeMillis() {
        return this.pool.getPooledMaxIdleTimeMillis();
    }

    public void setPooledMaxLifeTimeMillis(int lifeTimeoutMillis) {
        this.pool.setPooledMaxLifeTimeMillis(lifeTimeoutMillis);
    }

    public int getPooledMaxLifeTimeMillis() {
        return this.pool.getPooledMaxLifeTimeMillis();
    }

    public long getCreationMaxWaitMillis() {
        return this.pool.getCreationMaxWaitMillis();
    }

    public void setCreationMaxWaitMillis(long maxWaitMillis) {
        this.pool.setCreationMaxWaitMillis(maxWaitMillis);
    }

    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    public int getMaxIdle() {
        return this.pool.getMaxIdle();
    }

    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    int getNumPendingGet() {
        return this.pool.getNumPendingGet();
    }

    public int getNumCreated() {
        return this.pool.getNumCreated();
    }

    public int getNumDestroyed() {
        return this.pool.getNumDestroyed();
    }

    int getNumCreationError() {
        return this.pool.getNumCreationError();
    }

    public int getNumTimeoutPooledMaxIdleTime() {
        return this.pool.getNumTimeoutPooledMaxIdleTime();
    }

    public int getNumTimeoutPooledMaxLifeTime() {
        return this.pool.getNumTimeoutPooledMaxLifeTime();
    }

    public List<String> getActiveConnectionInfos() {
        return this.pool.getActiveConnectionInfos();
    }

    public List<String> getIdleConnectionInfos() {
        return this.pool.getIdleConnectionInfos();
    }

    List<String> getTransactionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        for (Transaction transaction : this.transactionLog.getTransactions()) {
            result.add(transaction.toString());
        }
        return result;
    }

    @Override
    public IHttpResponse call(IHttpRequest request) throws IOException, SocketTimeoutException {
        try {
            IFutureResponse futureResponse = this.send(request);
            return futureResponse.getResponse();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    @Override
    public IFutureResponse send(IHttpRequest request) throws IOException, ConnectException {
        FutureResponseHandler responseHandler = new FutureResponseHandler();
        this.send(request, (IHttpResponseHandler)responseHandler);
        return responseHandler;
    }

    @Override
    public void send(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        this.lastTimeRequestSentMillis = System.currentTimeMillis();
        if (responseHandler == null) {
            responseHandler = new HttpClientConnection.DoNothingResponseHandler();
        }
        HttpClientConnection.ClientExchange exchange = new HttpClientConnection.ClientExchange(this, this.getWorkerpool());
        exchange.init(request, responseHandler);
        this.httpClientRequestHandlerChain.onRequest(exchange);
        if (this.transactionMonitor != null) {
            this.transactionMonitor.register(request.getRequestHeader());
        }
    }

    @Override
    public BodyDataSink send(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        requestHeader.setContentLength(contentLength);
        return this.sendInternal(requestHeader, responseHandler);
    }

    @Override
    public BodyDataSink send(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        requestHeader.setTransferEncoding("chunked");
        return this.sendInternal(requestHeader, responseHandler);
    }

    private BodyDataSink sendInternal(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        this.lastTimeRequestSentMillis = System.currentTimeMillis();
        if (responseHandler == null) {
            responseHandler = new HttpClientConnection.DoNothingResponseHandler();
        }
        HttpClientConnection.ClientExchange exchange = new HttpClientConnection.ClientExchange(this, this.getWorkerpool());
        HttpClientConnection.IBodySinkPair pair = HttpClientConnection.newBodySinkPair(null, exchange.getExecutor(), requestHeader.getCharacterEncoding());
        HttpRequest request = new HttpRequest(requestHeader, pair.getBodyDataSource());
        exchange.init(request, responseHandler);
        this.httpClientRequestHandlerChain.onRequest(exchange);
        if (this.transactionMonitor != null) {
            this.transactionMonitor.register(requestHeader);
        }
        return pair.getBodyDataSink();
    }

    long getLastTimeRequestSentMillis() {
        return this.lastTimeRequestSentMillis;
    }

    HttpClientConnection getConnection(boolean isSSL, String host, int port, String scheme, IHttpRequestHandler filter) throws IOException, ConnectException {
        if (port == -1) {
            if (scheme.equalsIgnoreCase("HTTP")) {
                port = 80;
            } else if (scheme.equalsIgnoreCase("HTTPS")) {
                port = 443;
            } else {
                throw new IOException("wrong address host=" + host + " port=" + port + " scheme=" + scheme);
            }
        }
        if (isSSL && !this.isSSLSupported) {
            throw new IOException("ssl connection are not supported (use pool sslContext parameter constructor)");
        }
        INonBlockingConnection tcpConnection = null;
        if (this.isPooled) {
            try {
                tcpConnection = this.pool.getNonBlockingConnection(host, port, isSSL);
            }
            catch (IOException ioe) {
                throw new ConnectException("could not connect to " + host + ":" + port);
            }
        }
        try {
            if (this.sslCtx != null) {
                tcpConnection = new NonBlockingConnection(host, port, this.sslCtx, true);
                ((NonBlockingConnection)tcpConnection).setWorkerpool(this.pool.getWorkerpool());
            } else {
                tcpConnection = new NonBlockingConnection(host, port);
                ((NonBlockingConnection)tcpConnection).setWorkerpool(this.pool.getWorkerpool());
            }
        }
        catch (IOException ioe) {
            throw new ConnectException("could not connect to " + host + ":" + port + " reason: " + ioe.toString());
        }
        HttpClientConnection httpConnection = new HttpClientConnection(tcpConnection);
        httpConnection.setResponseTimeoutMillis(this.responseTimeoutMillis);
        httpConnection.setBodyDataReceiveTimeoutMillis(this.bodyDataReceiveTimeoutMillis);
        httpConnection.setAutocloseAfterResponse(true);
        if (this.transactionMonitor != null) {
            httpConnection.setTransactionMonitor(this.transactionMonitor);
        }
        return httpConnection;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\r\nactive connections:");
        for (String connectionInfo : this.getActiveConnectionInfos()) {
            sb.append("\r\n " + connectionInfo);
        }
        sb.append("\r\nidle connections:");
        for (String connectionInfo : this.getIdleConnectionInfos()) {
            sb.append("\r\n " + connectionInfo);
        }
        sb.append("\r\ntransaction log:");
        for (String transactionInfo : this.getTransactionInfos()) {
            sb.append("\r\n " + transactionInfo);
        }
        return sb.toString();
    }

    private static final class Transaction {
        private final TransactionMonitor monitor;
        private String requestHeaderInfo = "";
        private String requestBodyInfo = "";
        private String responseHeaderInfo = "";
        private String responseBodyInfo = "";
        private String conInfo = "";
        private boolean isHeaderReceived = false;
        private boolean isBodyReceived = false;
        private Long requestHeaderSend = null;
        private Long responseBodyReceived = null;
        private SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");

        public Transaction(TransactionMonitor monitor) {
            this.monitor = monitor;
        }

        public void register(IHttpRequestHeader requestHeader) {
            this.monitor.incPending();
            this.requestHeaderSend = System.currentTimeMillis();
            this.requestHeaderInfo = requestHeader.getQueryString() != null ? "[" + this.df.format(new Date()) + "] " + requestHeader.getServerName() + ":" + requestHeader.getServerPort() + " " + requestHeader.getMethod() + " " + requestHeader.getRequestURI() + requestHeader.getQueryString() : "[" + this.df.format(new Date()) + "] " + requestHeader.getServerName() + ":" + requestHeader.getServerPort() + " " + requestHeader.getMethod() + " " + requestHeader.getRequestURI();
        }

        public void register(HttpClientConnection con, IHttpResponse response) {
            this.isHeaderReceived = true;
            IHttpResponseHeader responseHeader = response.getResponseHeader();
            this.responseHeaderInfo = responseHeader.getStatus() + " " + responseHeader.getReason();
            if (responseHeader.containsHeader("connection")) {
                this.responseHeaderInfo = this.responseHeaderInfo + " (connection: " + responseHeader.getHeader("connection") + ")";
            }
            if (response.hasBody()) {
                try {
                    this.responseBodyInfo = "(" + HttpClientConnection.getBodytype(response.getNonBlockingBody()) + ")";
                    IBodyCompleteListener cl = new IBodyCompleteListener(){

                        public void onComplete() throws IOException {
                            Transaction.this.register();
                        }
                    };
                    response.getNonBlockingBody().addCompleteListener(cl);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by registering complete listener " + ioe.toString());
                    }
                }
            } else {
                this.responseBodyInfo = "(NO BODY)";
                this.register();
            }
            this.conInfo = "id=" + con.getId();
        }

        private void register() {
            this.monitor.decPending();
            this.isBodyReceived = true;
            this.responseBodyReceived = System.currentTimeMillis();
        }

        public String toString() {
            String elapsed = "";
            elapsed = this.responseBodyReceived != null ? "elapsed=" + DataConverter.toFormatedDuration((long)(this.responseBodyReceived - this.requestHeaderSend)) : "elapsed=" + DataConverter.toFormatedDuration((long)(System.currentTimeMillis() - this.requestHeaderSend));
            if (this.isBodyReceived) {
                return this.requestHeaderInfo + " " + this.requestBodyInfo + "-> " + this.responseHeaderInfo + " " + this.responseBodyInfo + " [" + elapsed + " " + this.conInfo + "]";
            }
            if (this.isHeaderReceived) {
                return this.requestHeaderInfo + " " + this.requestBodyInfo + "-> " + this.responseHeaderInfo + " " + this.responseBodyInfo + " [READING BODY " + elapsed + " " + this.conInfo + "]";
            }
            return this.requestHeaderInfo + " " + this.requestBodyInfo + "-> " + this.responseHeaderInfo + " " + this.responseBodyInfo + " [WAITING FOR HEADER " + elapsed + " " + this.conInfo + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TransactionLog {
        private LinkedList<Transaction> transactions = new LinkedList();
        private int maxSize = 0;

        TransactionLog(int maxSize) {
            this.maxSize = maxSize;
        }

        void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            this.removeOddEntries();
        }

        int getMaxSize() {
            return this.maxSize;
        }

        void add(Transaction transaction) {
            this.transactions.add(transaction);
            this.removeOddEntries();
        }

        private void removeOddEntries() {
            while (this.transactions.size() > this.maxSize) {
                try {
                    this.transactions.removeFirst();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by removing list entry " + e.toString());
                }
            }
        }

        public List<Transaction> getTransactions() {
            return (List)this.transactions.clone();
        }
    }

    static final class TransactionMonitor {
        private final Map<IHttpRequestHeader, Transaction> pendingTransactions = new HashMap<IHttpRequestHeader, Transaction>();
        private final AtomicInteger pending = new AtomicInteger(0);
        private final TransactionLog transactionLog;

        public TransactionMonitor(TransactionLog transactionLog) {
            this.transactionLog = transactionLog;
        }

        public void register(IHttpRequestHeader requestHeader) {
            Transaction transaction = new Transaction(this);
            transaction.register(requestHeader);
            this.pendingTransactions.put(requestHeader, transaction);
            this.transactionLog.add(transaction);
        }

        public void register(HttpClientConnection con, IHttpRequestHeader requestHeader, IHttpResponse response) {
            Transaction transaction = this.pendingTransactions.remove(requestHeader);
            if (transaction != null) {
                transaction.register(con, response);
            }
        }

        void incPending() {
            this.pending.incrementAndGet();
        }

        void decPending() {
            this.pending.decrementAndGet();
        }

        int getPendingTransactions() {
            return this.pending.get();
        }
    }
}

