/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.typing.descriptor.RegistryListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class MappingRegistry {
    protected final FileObject _configRoot;
    protected static final String MAPPINGS_FOLDER = "Maltego/TabularMappings/";
    public static final String EXT = "tmapping";
    private static MappingRegistry _default;
    private final Collection<RegistryListener> _listeners = Collections.synchronizedCollection(new LinkedList());

    protected MappingRegistry() {
        this._configRoot = FileUtil.getConfigRoot();
    }

    protected MappingRegistry(FileObject configRoot) {
        this._configRoot = configRoot;
    }

    public static synchronized MappingRegistry getDefault() {
        if (_default == null && (_default = (MappingRegistry)Lookup.getDefault().lookup(MappingRegistry.class)) == null) {
            throw new IllegalStateException("No mapping registry found.");
        }
        return _default;
    }

    public abstract TabularGraph get(String var1);

    public abstract Set<TabularGraph> getAll();

    public abstract void put(TabularGraph var1);

    public abstract void remove(String var1);

    public abstract boolean contains(String var1);

    public abstract void refreshProperties();

    public void addListener(RegistryListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(RegistryListener listener) {
        this._listeners.remove(listener);
    }

    protected void fireMappingAdded() {
        for (RegistryListener l : this._listeners) {
            l.typeAdded(null);
        }
    }

    protected void fireMappingRemoved() {
        for (RegistryListener l : this._listeners) {
            l.typeRemoved(null);
        }
    }

    protected void fireMappingUpdated() {
        for (RegistryListener l : this._listeners) {
            l.typeUpdated(null);
        }
    }
}

