/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.exp;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.table.io.exp.TabularGraphExportResult;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Exceptions;
import yguard.A.A.D;
import yguard.A.J.SA;

public abstract class GraphTableBuilder {
    protected SA viewGraph;
    protected ProgressHandle progressHandle;
    protected boolean selectionOnly;
    protected boolean distinct;
    protected boolean separateLinks;
    protected boolean removeHiddenProperties;
    protected GraphID graphID;
    protected GraphStore graphStore;
    protected GraphDataStore dataStore;
    protected GraphDataStoreReader dataStoreReader;
    protected GraphStructureStore structureStore;
    protected GraphStructureReader structureReader;
    protected EntityRegistry entityRegistry;
    private boolean built = false;
    private List<List<String>> table;
    private List<List<String>> split;
    private TabularGraphExportResult result;
    private Set<EntityID> entities;
    private Set<LinkID> links;

    public final List<List<String>> build() throws Exception {
        this.built = false;
        this.table = new Table();
        try {
            this.entityRegistry = EntityRegistry.forGraph((D)this.viewGraph);
            this.graphID = GraphIDProvider.forGraph((SA)this.viewGraph);
            this.graphStore = GraphStoreRegistry.getDefault().forGraphID(this.graphID);
            this.dataStore = this.graphStore.getGraphDataStore();
            this.dataStoreReader = this.dataStore.getDataStoreReader();
            this.structureStore = this.graphStore.getGraphStructureStore();
            this.structureReader = this.structureStore.getStructureReader();
            if (this.selectionOnly) {
                GraphSelection graphSelection = GraphSelection.forGraph((GraphID)this.graphID);
                this.entities = new HashSet<EntityID>(graphSelection.getSelectedModelEntities());
                this.links = new HashSet<LinkID>(graphSelection.getSelectedModelLinks());
            } else {
                this.entities = new HashSet<EntityID>(this.structureReader.getEntities());
                this.links = new HashSet<LinkID>(this.structureReader.getLinks());
            }
            this.links.addAll(this.structureReader.getLinksBetween(this.entities));
            this.progressUpdate("Building tabular output...");
            if (this.separateLinks) {
                this.result = this.build(this.entities, Collections.emptySet(), this.table);
                this.split = new Table();
                TabularGraphExportResult linksResult = this.build(Collections.emptySet(), this.links, this.split);
                this.result.setLinksExported(linksResult.getLinksExported());
                this.result.setLinesGenerated(this.result.getLinesGenerated() + linksResult.getLinesGenerated());
            } else {
                this.result = this.build(this.entities, this.links, this.table);
            }
            this.progressUpdate("Table build complete with #" + this.table.size() + " rows.");
        }
        catch (Exception e) {
            this.progressUpdate("An error occurred during the construction of the tabular output: " + e.getMessage());
            Exceptions.printStackTrace((Throwable)e);
            throw e;
        }
        this.built = true;
        return this.table;
    }

    public SA getViewGraph() {
        return this.viewGraph;
    }

    public ProgressHandle getHandle() {
        return this.progressHandle;
    }

    public GraphTableBuilder setViewGraph(SA viewGraph) {
        if (this.viewGraph != viewGraph) {
            this.built = false;
        }
        this.viewGraph = viewGraph;
        return this;
    }

    public GraphTableBuilder setHandle(ProgressHandle handle) {
        this.progressHandle = handle;
        return this;
    }

    public boolean isSelectionOnly() {
        return this.selectionOnly;
    }

    public GraphTableBuilder setSelectionOnly(boolean selectionOnly) {
        if (this.selectionOnly != selectionOnly) {
            this.built = false;
        }
        this.selectionOnly = selectionOnly;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public GraphTableBuilder setDistinct(boolean distinct) {
        if (this.distinct != distinct) {
            this.built = false;
        }
        this.distinct = distinct;
        return this;
    }

    public GraphTableBuilder setSeparateLinks(boolean separateLinks) {
        if (this.separateLinks != separateLinks) {
            this.built = false;
        }
        this.separateLinks = separateLinks;
        return this;
    }

    public boolean hasSeparateLinks() {
        return this.separateLinks && this.split != null && !this.split.isEmpty();
    }

    public GraphTableBuilder setRemoveHiddenProperties(boolean removeHiddenProperties) {
        if (this.removeHiddenProperties != removeHiddenProperties) {
            this.built = false;
        }
        this.removeHiddenProperties = removeHiddenProperties;
        return this;
    }

    public boolean removeHiddenProperties() {
        return this.removeHiddenProperties;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public List<List<String>> getTable() {
        return this.table;
    }

    public List<List<String>> getLinkTable() {
        return this.split;
    }

    public TabularGraphExportResult getResult() {
        return this.result;
    }

    protected void progressUpdate(String message) {
        if (this.progressHandle == null) {
            return;
        }
        this.progressHandle.setDisplayName(message);
    }

    protected MaltegoEntity getEntity(EntityID entityID) {
        try {
            MaltegoEntity entity = this.dataStoreReader.getEntity(entityID);
            if (this.removeHiddenProperties) {
                entity = entity.createClone();
                ArrayList<PropertyDescriptor> pdToRemove = new ArrayList<PropertyDescriptor>();
                PropertyDescriptorCollection properties = entity.getProperties();
                for (PropertyDescriptor property : properties) {
                    if (!property.isHidden()) continue;
                    pdToRemove.add(property);
                }
                properties.removeAll(pdToRemove);
            }
            return entity;
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected MaltegoLink getLink(LinkID linkID) {
        try {
            return this.dataStoreReader.getLink(linkID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected EntityID getSourceID(LinkID linkID) {
        try {
            return this.structureReader.getSource(linkID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected EntityID getTargetID(LinkID linkID) {
        try {
            return this.structureReader.getTarget(linkID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected MaltegoEntity getSourceEntity(LinkID linkID) {
        try {
            return this.dataStoreReader.getEntity(this.structureReader.getSource(linkID));
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected MaltegoEntity getTargetEntity(LinkID linkID) {
        try {
            return this.dataStoreReader.getEntity(this.structureReader.getTarget(linkID));
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected abstract TabularGraphExportResult build(Set<EntityID> var1, Set<LinkID> var2, List<List<String>> var3) throws Exception;

    class Table
    extends ArrayList<List<String>> {
        Table() {
        }

        @Override
        public boolean add(List<String> e) {
            boolean success = super.add(e);
            if (success) {
                GraphTableBuilder.this.progressUpdate("Added Table Row #" + this.size());
            }
            return success;
        }
    }
}

