/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.rules.neighbour;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.views.impl.CollectStrategy;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.NeighbourMode;
import com.paterva.maltego.graph.store.views.impl.structures.Pair;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import com.paterva.maltego.graph.store.views.impl.tools.CollectionUtils;
import com.paterva.maltego.graph.store.views.impl.tools.UncollectUtils;
import com.paterva.maltego.util.BulkStatusDisplayer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;

public class NeighbourCollectionRule
implements CollectStrategy {
    private static final Logger LOG = Logger.getLogger(NeighbourCollectionRule.class.getName());
    private static final int MAX_NEIGHBOURS = 20;
    private final InMemoryCollectionNodes _collectionNodes;
    private ModelSnapshotData _msd;
    private GraphStructureMods _imsm;
    private GraphDataMods _imdm;
    private Map<EntityID, EntityLinks> _entities;
    private Map<LinkID, LinkEntityIDs> _links;
    private final Set<EntityID> _touchedViewEntities = new HashSet<EntityID>();
    private final UncollectUtils _uncollectUtils;
    private final Map<NeighbourMode, Map<EntityID, Set<EntityID>>> _neighbourCache = new HashMap<NeighbourMode, Map<EntityID, Set<EntityID>>>();
    private final Map<EntityID, Boolean> _collectableCache = new HashMap<EntityID, Boolean>();

    public NeighbourCollectionRule(InMemoryCollectionNodes collectionNodes) {
        this._collectionNodes = collectionNodes;
        this._uncollectUtils = new UncollectUtils(collectionNodes);
        this._neighbourCache.put(NeighbourMode.PARENTS, new HashMap());
        this._neighbourCache.put(NeighbourMode.CHILDREN, new HashMap());
    }

    @Override
    public void collect(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) throws GraphStoreException {
        this._msd = msd;
        this._entities = entities;
        this._links = links;
        this._neighbourCache.get((Object)NeighbourMode.PARENTS).clear();
        this._neighbourCache.get((Object)NeighbourMode.CHILDREN).clear();
        this._collectableCache.clear();
        Map<Integer, Set<EntityID>> collections = this.getCollectionSet();
        Map<EntityID, Integer> modelEntityToCollectionKey = this.invert(collections);
        HashMap<Pair<Integer, Integer>, ViewLink> collectionToCollectionCollectionLink = new HashMap<Pair<Integer, Integer>, ViewLink>();
        HashMap<Pair<Integer, EntityID>, ViewLink> collectionToModelCollectionLink = new HashMap<Pair<Integer, EntityID>, ViewLink>();
        HashMap<Pair<EntityID, Integer>, ViewLink> modelToCollectionCollectionLink = new HashMap<Pair<EntityID, Integer>, ViewLink>();
        HashMap<Set<EntityID>, EntityID> collectionEntitiesToCollectionEntity = new HashMap<Set<EntityID>, EntityID>();
        this.getCollectionLinks(collections, modelEntityToCollectionKey, entities, collectionEntitiesToCollectionEntity, links, collectionToCollectionCollectionLink, collectionToModelCollectionLink, modelToCollectionCollectionLink);
        this.insertCollections(collections, collectionToCollectionCollectionLink, collectionToModelCollectionLink, modelToCollectionCollectionLink);
    }

    private void insertCollections(Map<Integer, Set<EntityID>> collections, Map<Pair<Integer, Integer>, ViewLink> collectionToCollectionCollectionLink, Map<Pair<Integer, EntityID>, ViewLink> collectionToModelCollectionLink, Map<Pair<EntityID, Integer>, ViewLink> modelToCollectionCollectionLink) throws GraphStoreException {
        HashMap<Integer, Pair<EntityID, ViewEntity>> collectionMap = new HashMap<Integer, Pair<EntityID, ViewEntity>>();
        this.addLinks(collections, collectionToCollectionCollectionLink, collectionMap);
        this.addLinks(collections, collectionToModelCollectionLink, collectionMap);
        this.addLinks(collections, modelToCollectionCollectionLink, collectionMap);
        Set<EntityID> entityKeySet = this._entities.keySet();
        for (Map.Entry<Integer, Set<EntityID>> entry : collections.entrySet()) {
            Set<EntityID> value = entry.getValue();
            entityKeySet.removeAll(value);
        }
        this.removeFromLinks(collectionToCollectionCollectionLink);
        this.removeFromLinks(collectionToModelCollectionLink);
        this.removeFromLinks(modelToCollectionCollectionLink);
    }

    private void removeFromLinks(Map map) {
        Set<LinkID> linkKeySet = this._links.keySet();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            ViewLink viewLink = (ViewLink)entry.getValue();
            linkKeySet.removeAll(viewLink.getCollection());
        }
    }

    private void addLinks(Map<Integer, Set<EntityID>> collections, Map map, Map<Integer, Pair<EntityID, ViewEntity>> collectionMap) throws GraphStoreException {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            EntityLinks entityLinks;
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            Pair key = (Pair)entry.getKey();
            ViewLink viewLink = (ViewLink)entry.getValue();
            LinkID collectionLinkId = LinkID.create();
            this._msd.addToCollectedViewLinks(collectionLinkId, viewLink);
            LinkEntityIDs linkEntities = viewLink.getEntities();
            Object objectSrc = key.getOne();
            Object objectTarget = key.getTwo();
            boolean srcIsInt = objectSrc instanceof Integer;
            boolean trgIsInt = objectTarget instanceof Integer;
            if (srcIsInt && trgIsInt) {
                this.addCollectionEntitySrc(collectionMap, (Integer)objectSrc, collections, linkEntities, collectionLinkId, viewLink);
                this.addCollectionEntityTrg(collectionMap, (Integer)objectTarget, collections, linkEntities, collectionLinkId, viewLink);
                continue;
            }
            if (srcIsInt) {
                this.addCollectionEntitySrc(collectionMap, (Integer)objectSrc, collections, linkEntities, collectionLinkId, viewLink);
                EntityID trgModelEntity = (EntityID)objectTarget;
                entityLinks = this._entities.get(trgModelEntity);
                entityLinks.getViewIncomingLinks().removeAll(viewLink.getCollection());
                entityLinks.getViewIncomingLinks().add(collectionLinkId);
                continue;
            }
            if (trgIsInt) {
                this.addCollectionEntityTrg(collectionMap, (Integer)objectTarget, collections, linkEntities, collectionLinkId, viewLink);
                EntityID srcModelEntity = (EntityID)objectSrc;
                entityLinks = this._entities.get(srcModelEntity);
                entityLinks.getViewOutgoingLinks().removeAll(viewLink.getCollection());
                entityLinks.getViewOutgoingLinks().add(collectionLinkId);
                continue;
            }
            throw new IllegalStateException("Target nor source entity is valid, there is a problem with the algorithm");
        }
    }

    private Pair<EntityID, ViewEntity> addCollectionEntityTrg(Map<Integer, Pair<EntityID, ViewEntity>> collectionMap, Integer objectTarget, Map<Integer, Set<EntityID>> collections, LinkEntityIDs linkEntities, LinkID collectionLinkId, ViewLink viewLink) throws GraphStoreException {
        EntityLinks entLinks;
        Pair<EntityID, ViewEntity> collectionPair = collectionMap.get(objectTarget);
        if (collectionPair == null) {
            Set<EntityID> entsToCollect = collections.get(objectTarget);
            String entType = this._msd.getEntityType(entsToCollect.iterator().next());
            entLinks = new EntityLinks();
            ViewEntity ve = new ViewEntity(entType, entsToCollect, entLinks);
            collectionPair = new Pair<EntityID, ViewEntity>(linkEntities.getTargetID(), ve);
            collectionMap.put(objectTarget, collectionPair);
        }
        entLinks = collectionPair.getTwo().getAllLinks();
        entLinks.getViewIncomingLinks().add(collectionLinkId);
        entLinks.getModelIncomingLinks().addAll(viewLink.getCollection());
        this._msd.addToCollectedViewEntities(collectionPair.getOne(), collectionPair.getTwo());
        return collectionPair;
    }

    private Pair<EntityID, ViewEntity> addCollectionEntitySrc(Map<Integer, Pair<EntityID, ViewEntity>> collectionMap, Integer objectSrc, Map<Integer, Set<EntityID>> collections, LinkEntityIDs linkEntities, LinkID collectionLinkId, ViewLink viewLink) throws GraphStoreException {
        EntityLinks entLinks;
        Pair<EntityID, ViewEntity> collectionPair = collectionMap.get(objectSrc);
        if (collectionPair == null) {
            Set<EntityID> entsToCollect = collections.get(objectSrc);
            String entType = this._msd.getEntityType(entsToCollect.iterator().next());
            entLinks = new EntityLinks();
            ViewEntity ve = new ViewEntity(entType, entsToCollect, entLinks);
            collectionPair = new Pair<EntityID, ViewEntity>(linkEntities.getSourceID(), ve);
            collectionMap.put(objectSrc, collectionPair);
        }
        entLinks = collectionPair.getTwo().getAllLinks();
        entLinks.getViewOutgoingLinks().add(collectionLinkId);
        entLinks.getModelOutgoingLinks().addAll(viewLink.getCollection());
        this._msd.addToCollectedViewEntities(collectionPair.getOne(), collectionPair.getTwo());
        return collectionPair;
    }

    private void getCollectionLinks(Map<Integer, Set<EntityID>> collections, Map<EntityID, Integer> modelEntityToCollectionKey, Map<EntityID, EntityLinks> entities, Map<Set<EntityID>, EntityID> collectionEntitiesToCollectionEntity, Map<LinkID, LinkEntityIDs> links, Map<Pair<Integer, Integer>, ViewLink> collectionToCollectionCollectionLink, Map<Pair<Integer, EntityID>, ViewLink> collectionToModelCollectionLink, Map<Pair<EntityID, Integer>, ViewLink> modelToCollectionCollectionLink) throws GraphStoreException {
        HashSet<LinkID> allLinksToCollect = new HashSet<LinkID>();
        HashMap<EntityID, Set<EntityID>> collectionEntitiesReused = new HashMap<EntityID, Set<EntityID>>();
        for (Map.Entry<Integer, Set<EntityID>> entry : collections.entrySet()) {
            Set<EntityID> collection = entry.getValue();
            for (EntityID collectionEntity : collection) {
                allLinksToCollect.addAll(entities.get(collectionEntity).getModelLinks());
            }
        }
        for (LinkID linkID : allLinksToCollect) {
            Map<Pair<Integer, Integer>, ViewLink> map;
            Pair<Integer, Integer> key;
            LinkEntityIDs linkEntities = links.get(linkID);
            EntityID sourceID = linkEntities.getSourceID();
            EntityID targetID = linkEntities.getTargetID();
            Integer sourceKey = modelEntityToCollectionKey.get(sourceID);
            Integer targetKey = modelEntityToCollectionKey.get(targetID);
            EntityID src = null;
            EntityID trg = null;
            if (sourceKey != null && targetKey != null) {
                key = new Pair<Integer, Integer>(sourceKey, targetKey);
                map = collectionToCollectionCollectionLink;
            } else if (sourceKey == null) {
                key = new Pair<EntityID, Integer>(sourceID, targetKey);
                map = modelToCollectionCollectionLink;
                src = sourceID;
            } else {
                key = new Pair<Integer, EntityID>(sourceKey, targetID);
                map = collectionToModelCollectionLink;
                trg = targetID;
            }
            ViewLink viewLink = map.get(key);
            if (viewLink == null) {
                EntityID temp;
                Pair<EntityID, ViewEntity> entPair;
                Set<EntityID> collectionSrc = null;
                Set<EntityID> collectionTrg = null;
                if (src == null && (entPair = this._collectionNodes.getFirstViewEntityThatIsACollection(collectionSrc = collections.get(sourceKey))) != null && !this._msd.collectedViewEntitiesContains(entPair.getOne())) {
                    temp = entPair.getOne();
                    src = this.reuseIfPossible(collectionEntitiesReused, temp, collectionSrc);
                }
                if (trg == null && (entPair = this._collectionNodes.getFirstViewEntityThatIsACollection(collectionTrg = collections.get(targetKey))) != null && !this._msd.collectedViewEntitiesContains(entPair.getOne())) {
                    temp = entPair.getOne();
                    trg = this.reuseIfPossible(collectionEntitiesReused, temp, collectionTrg);
                }
                if (src == null && (src = collectionEntitiesToCollectionEntity.get(collectionSrc)) == null) {
                    src = EntityID.create();
                    collectionEntitiesToCollectionEntity.put(collectionSrc, src);
                }
                if (trg == null && (trg = collectionEntitiesToCollectionEntity.get(collectionTrg)) == null) {
                    trg = EntityID.create();
                    collectionEntitiesToCollectionEntity.put(collectionTrg, trg);
                }
                viewLink = new ViewLink(src, trg);
                map.put(key, viewLink);
            }
            viewLink.getCollection().add(linkID);
        }
    }

    private boolean canReuseCollectionEntityID(Map<EntityID, Set<EntityID>> collectionEntitiesReused, EntityID entity, Set<EntityID> collection) {
        Set<EntityID> set = collectionEntitiesReused.get(entity);
        if (set == null) {
            return true;
        }
        return set.containsAll(collection);
    }

    private EntityID reuseIfPossible(Map<EntityID, Set<EntityID>> collectionEntitiesReused, EntityID entity, Set<EntityID> collection) {
        if (this.canReuseCollectionEntityID(collectionEntitiesReused, entity, collection)) {
            collectionEntitiesReused.put(entity, collection);
            return entity;
        }
        return null;
    }

    private Map<EntityID, Integer> invert(Map<Integer, Set<EntityID>> collections) {
        HashMap<EntityID, Integer> modelEntityToCollectionKey = new HashMap<EntityID, Integer>();
        for (Map.Entry<Integer, Set<EntityID>> entry : collections.entrySet()) {
            Integer key = entry.getKey();
            Set<EntityID> value = entry.getValue();
            for (EntityID entityID : value) {
                modelEntityToCollectionKey.put(entityID, key);
            }
        }
        return modelEntityToCollectionKey;
    }

    private Map<Integer, Set<EntityID>> getCollectionSet() throws GraphStoreException {
        HashMap<Integer, Set<EntityID>> collectionsToMake = new HashMap<Integer, Set<EntityID>>();
        int keyCounter = 0;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Incoming entities {0}", this._entities.toString());
        }
        Map<String, Map<Set<EntityID>, Map<Set<EntityID>, List<EntityID>>>> groupByNeighbours = this.groupByNeighbours();
        for (Map.Entry<String, Map<Set<EntityID>, Map<Set<EntityID>, List<EntityID>>>> entry : groupByNeighbours.entrySet()) {
            String type = entry.getKey();
            int min = this._msd.getMinEntityCountForCollection(type);
            for (Map.Entry<Set<EntityID>, Map<Set<EntityID>, List<EntityID>>> entry2 : entry.getValue().entrySet()) {
                for (Map.Entry<Set<EntityID>, List<EntityID>> entry3 : entry2.getValue().entrySet()) {
                    List<EntityID> group = entry3.getValue();
                    if (group.size() < min) continue;
                    collectionsToMake.put(keyCounter++, new HashSet<EntityID>(group));
                }
            }
        }
        return collectionsToMake;
    }

    private Map<String, Map<Set<EntityID>, Map<Set<EntityID>, List<EntityID>>>> groupByNeighbours() {
        BulkStatusDisplayer status = new BulkStatusDisplayer("Grouping neighbors (%d/" + this._entities.size() + ")");
        Map<String, Map<Set<EntityID>, Map<Set<EntityID>, List<EntityID>>>> grouped = this._entities.keySet().stream().peek(id -> status.increment()).filter(this::isCollectable).collect(Collectors.groupingBy(entity -> this.getType((EntityID)entity), Collectors.groupingBy(entity -> this.getEntities((EntityID)entity, NeighbourMode.PARENTS), Collectors.groupingBy(entity -> this.getEntities((EntityID)entity, NeighbourMode.CHILDREN)))));
        return grouped;
    }

    private String getType(EntityID entity) {
        try {
            return this._msd.getEntityType(entity);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "";
        }
    }

    private synchronized boolean isCollectable(EntityID entity) {
        Boolean collectable = this._collectableCache.get(entity);
        if (collectable == null) {
            try {
                collectable = CollectionUtils.isCollectable(this._msd, entity, 20);
                this._collectableCache.put(entity, collectable);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                collectable = false;
            }
        }
        return collectable;
    }

    private synchronized Set<EntityID> getEntities(EntityID entity, NeighbourMode mode) {
        Map<EntityID, Set<EntityID>> neighboursCache = this._neighbourCache.get((Object)mode);
        Set<EntityID> neighbours = neighboursCache.get(entity);
        if (neighbours == null) {
            try {
                neighbours = CollectionUtils.getEntities(this._msd, this._entities, this._links, entity, mode);
                neighboursCache.put(entity, neighbours);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                neighbours = Collections.EMPTY_SET;
            }
        }
        return neighbours;
    }

    private Set<EntityID> getViewNeighbour(EntityID ent, NeighbourMode mode) throws GraphStoreException {
        Map<LinkID, EntityID> map;
        Map<EntityID, ViewEntity> viewEntities = this._collectionNodes.getViewEntities();
        HashSet<EntityID> touched = new HashSet<EntityID>();
        touched.add(ent);
        ViewEntity ve = viewEntities.get(ent);
        switch (mode) {
            case CHILDREN: {
                map = this._collectionNodes.getTargets(ve.getAllLinks().getViewOutgoingLinks());
                break;
            }
            case PARENTS: {
                map = this._collectionNodes.getSources(ve.getAllLinks().getViewIncomingLinks());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported mode");
            }
        }
        for (Map.Entry<LinkID, EntityID> entry : map.entrySet()) {
            EntityID value = entry.getValue();
            touched.add(value);
        }
        return touched;
    }

    private Set<EntityID> getViewSiblings(Map<LinkID, ViewLink> viewLinks, ViewEntity ve) throws GraphStoreException {
        LinkEntityIDs entities;
        ViewLink vl;
        HashSet<EntityID> touched = new HashSet<EntityID>();
        EntityLinks allLinks = ve.getAllLinks();
        for (LinkID incomingLinkID : allLinks.getViewIncomingLinks()) {
            vl = viewLinks.get(incomingLinkID);
            entities = vl.getEntities();
            touched.addAll(this.getViewNeighbour(entities.getSourceID(), NeighbourMode.CHILDREN));
        }
        for (LinkID outgoingLinkID : allLinks.getViewOutgoingLinks()) {
            vl = viewLinks.get(outgoingLinkID);
            entities = vl.getEntities();
            touched.addAll(this.getViewNeighbour(entities.getTargetID(), NeighbourMode.PARENTS));
        }
        return touched;
    }

    private Set<EntityID> lookupTouched(Set<EntityID> existingModelEntitiesInView) throws GraphStoreException {
        Map<LinkID, ViewLink> viewLinks = this._collectionNodes.getViewLinks();
        HashSet<EntityID> touched = new HashSet<EntityID>();
        for (EntityID existingModelEntity : existingModelEntitiesInView) {
            Pair<EntityID, ViewEntity> viewEntityPair = this._collectionNodes.getViewEntityPair(existingModelEntity);
            ViewEntity ve = viewEntityPair.getTwo();
            touched.addAll(this.getViewSiblings(viewLinks, ve));
        }
        return touched;
    }

    @Override
    public Set<EntityID> determineTouchedViewEntities(GraphStructureMods imsm, GraphDataMods imdm) throws GraphStoreException {
        this._touchedViewEntities.clear();
        this._imsm = imsm;
        this._imdm = imdm;
        Set<EntityID> existingModelEntitiesInView = this._uncollectUtils.getExistingModelEntitiesInView(this._imsm, this._imdm);
        Set<EntityID> touchedFormExistingModelEntitiesInView = this.lookupTouched(existingModelEntitiesInView);
        this._touchedViewEntities.addAll(this._uncollectUtils.addNeighbouringCollections(touchedFormExistingModelEntitiesInView, new HashSet<EntityID>(touchedFormExistingModelEntitiesInView)));
        return this._touchedViewEntities;
    }
}

