/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.layout.LayoutFactory;
import com.paterva.maltego.layout.view.LayoutHandler;
import com.paterva.maltego.ui.graph.view2d.InteractiveMoveSelectionMode;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import yguard.A.A.C;
import yguard.A.A.Z;
import yguard.A.A._;
import yguard.A.G.B.H;
import yguard.A.G.NA;
import yguard.A.G.RA;
import yguard.A.G.Y;
import yguard.A.G.n;
import yguard.A.I.M;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.mB;
import yguard.A.J.q;

public class InteractiveLayoutViewHandler
implements LayoutHandler {
    public static final String PROP_LAYOUTER = "layouterChanged";
    private static final int CLEANUP_DELAY = 600000;
    private long _lastCleanup;
    private U _view;
    private Timer _timer;
    private n _layouter;
    private UpdateHandler _updater;
    private static final int RELAYOUT_NODE_COUNT = 2000;
    private int _nodesChanged = 0;
    private boolean _preparingView = false;
    private final Object _relayoutLock = new Object();
    private LayoutMode _layoutMode;
    private boolean _preventWakeUp = false;
    private boolean _showing = false;
    private PropertyChangeSupport _layouterChangeSupport = new PropertyChangeSupport(this);
    private Y _copiedLayoutGraph;

    InteractiveLayoutViewHandler(U view) {
        this._view = view;
        this._updater = new UpdateHandler();
        this._timer = new Timer(21, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = InteractiveLayoutViewHandler.this._relayoutLock;
                synchronized (object) {
                    if (InteractiveLayoutViewHandler.this._preparingView) {
                        return;
                    }
                }
                if (InteractiveLayoutViewHandler.this._layouter instanceof yguard.A.G.B.C) {
                    yguard.A.G.B.C layouter = (yguard.A.G.B.C)InteractiveLayoutViewHandler.this._layouter;
                    if (layouter.A(50.0, 0.1) > 0.0) {
                        InteractiveLayoutViewHandler.this.clearBendsAndResetPorts();
                        InteractiveLayoutViewHandler.this._view.getGraph2D().\u0107();
                    }
                    if (layouter.L() && InteractiveLayoutViewHandler.this.needsCleanup()) {
                        InteractiveLayoutViewHandler.this.cleanup();
                    }
                }
            }
        });
    }

    public void setLayoutMode(LayoutMode newLayoutMode) {
        if (this._layoutMode == newLayoutMode) {
            return;
        }
        this._layoutMode = newLayoutMode;
        if (this._layoutMode == null) {
            if (this._timer != null) {
                this._timer.stop();
            }
            this.dispose(this._copiedLayoutGraph);
            this._copiedLayoutGraph = null;
            this._layouter = null;
            return;
        }
        if (this._showing) {
            this.createLayouter();
            this._timer.start();
        }
    }

    private void clearBendsAndResetPorts() {
        SA graph2D = this._view.getGraph2D();
        this._preventWakeUp = true;
        graph2D.\u00cc();
        Z edges = graph2D.u();
        while (edges.ok()) {
            yguard.A.A.H edge = edges.D();
            q realizer = graph2D.X(edge);
            realizer.clearBends();
            graph2D.A(edge, M.B);
            graph2D.C(edge, M.B);
            edges.next();
        }
        graph2D.\u00a3();
        this._preventWakeUp = false;
    }

    public mB getMoveSelectionMode() {
        if (this._layouter instanceof yguard.A.G.B.C) {
            yguard.A.G.B.C layouter = (yguard.A.G.B.C)this._layouter;
            return new InteractiveMoveSelectionMode(layouter);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGraphChanged(SA oldGraph, SA newGraph) {
        if (oldGraph != null) {
            oldGraph.B((_)this._updater);
        }
        if (newGraph != null) {
            Object object = this._relayoutLock;
            synchronized (object) {
                this._nodesChanged = newGraph.v();
            }
            if (this._showing) {
                this.createLayouter();
                this._timer.start();
            } else {
                this.dispose(this._copiedLayoutGraph);
                this._copiedLayoutGraph = null;
                this._layouter = null;
            }
            newGraph.A((_)this._updater);
        }
    }

    @Override
    public void onGraphUpdated(Set<yguard.A.A.Y> newNodes) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareToShow() {
        boolean relayout;
        Object object = this._relayoutLock;
        synchronized (object) {
            relayout = this._nodesChanged >= 2000;
            this._preparingView = true;
        }
        if (relayout) {
            H organicLayouter = new H();
            organicLayouter.enableOnlyCore();
            organicLayouter.b(760.0);
            organicLayouter.Z(0.48);
            organicLayouter.t(false);
            organicLayouter.r(true);
            organicLayouter.a(0.72);
            organicLayouter.q(false);
            organicLayouter.n(false);
            new NA((n)organicLayouter).doLayout((RA)this._view.getGraph2D());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InteractiveLayoutViewHandler.this._view.fitContent();
                }
            });
        }
        object = this._relayoutLock;
        synchronized (object) {
            this._nodesChanged = 0;
            this._preparingView = false;
        }
    }

    private void createLayouter() {
        double nodeCount = this._view.getGraph2D().v();
        int delay = (int)(nodeCount * nodeCount / 100000.0 + 21.0);
        delay = Math.min(delay, 1000);
        this._timer.setDelay(delay);
        n old = this._layouter;
        if (this._layoutMode == null) {
            this._layoutMode = LayoutMode.BLOCK;
        }
        this._layouter = LayoutFactory.getLayouter(this._view.getGraph2D(), this._layoutMode, false);
        if (this._layouter instanceof yguard.A.G.B.C) {
            yguard.A.G.B.C layouter = (yguard.A.G.B.C)this._layouter;
            if (!layouter.O()) {
                this.dispose(this._copiedLayoutGraph);
                this._copiedLayoutGraph = new Y((RA)this._view.getGraph2D());
                layouter.B((RA)this._copiedLayoutGraph);
            }
            layouter.G();
        }
        this._layouterChangeSupport.firePropertyChange(PROP_LAYOUTER, old, this._layouter);
        this._lastCleanup = System.currentTimeMillis();
    }

    private void dispose(Y graph) {
        if (graph != null) {
            Object[] dataProviders;
            graph.t();
            for (Object dataProvider : dataProviders = graph.q()) {
                graph.E(dataProvider);
            }
        }
    }

    @Override
    public void onComponentShowing() {
        this._showing = true;
        if (this._layoutMode != null) {
            if (this._layouter == null) {
                this.createLayouter();
            }
            this._timer.start();
        }
    }

    @Override
    public void onComponentHidden() {
        this._showing = false;
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
    }

    @Override
    public void onComponentClosed() {
        if (this._layouter != null) {
            if (this._layouter instanceof yguard.A.G.B.C) {
                yguard.A.G.B.C layouter = (yguard.A.G.B.C)this._layouter;
                layouter.M();
            }
            this.dispose(this._copiedLayoutGraph);
            this._copiedLayoutGraph = null;
            this._layouter = null;
        }
    }

    private boolean needsCleanup() {
        return System.currentTimeMillis() - this._lastCleanup > 600000L;
    }

    private void cleanup() {
        this._timer.stop();
        if (this._layouter instanceof yguard.A.G.B.C) {
            yguard.A.G.B.C layouter = (yguard.A.G.B.C)this._layouter;
            layouter.E();
        }
        this.createLayouter();
        this._timer.start();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._layouterChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._layouterChangeSupport.removePropertyChangeListener(listener);
    }

    private class UpdateHandler
    implements _ {
        private int _block = 0;

        private UpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onGraphEvent(C e) {
            if (e.B() instanceof SA) {
                Object object;
                switch (e.C()) {
                    case 12: {
                        ++this._block;
                        break;
                    }
                    case 13: {
                        --this._block;
                        break;
                    }
                    case 0: 
                    case 3: {
                        object = InteractiveLayoutViewHandler.this._relayoutLock;
                        synchronized (object) {
                            if (!InteractiveLayoutViewHandler.this._view.isShowing()) {
                                InteractiveLayoutViewHandler.this._nodesChanged++;
                            }
                            break;
                        }
                    }
                }
                if (this._block == 0) {
                    object = InteractiveLayoutViewHandler.this._relayoutLock;
                    synchronized (object) {
                        if (!InteractiveLayoutViewHandler.this._preparingView && !InteractiveLayoutViewHandler.this._preventWakeUp && InteractiveLayoutViewHandler.this._layouter instanceof yguard.A.G.B.C) {
                            yguard.A.G.B.C layouter = (yguard.A.G.B.C)InteractiveLayoutViewHandler.this._layouter;
                            layouter.G();
                        }
                    }
                }
            }
        }
    }
}

