/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api.remote;

import com.maltego.tx3.java.api.constraints.execution.DefaultUnknownConstraint;
import com.maltego.tx3.java.api.constraints.execution.entity.BaseEntitySatisfies;
import com.maltego.tx3.java.api.constraints.execution.entity.EntitySatisfiesAll;
import com.maltego.tx3.java.api.constraints.execution.entity.EntitySatisfiesAny;
import com.maltego.tx3.java.api.constraints.execution.entity.EntitySatisfiesNone;
import com.maltego.tx3.java.api.constraints.execution.entity.EntityTypeConstraint;
import com.maltego.tx3.java.api.constraints.execution.graph.GraphSatisfiesAll;
import com.maltego.tx3.java.api.constraints.execution.graph.GraphSatisfiesAny;
import com.maltego.tx3.java.api.constraints.execution.graph.GraphSatisfiesNone;
import com.maltego.tx3.java.api.constraints.execution.link.LinkSatisfiesAll;
import com.maltego.tx3.java.api.constraints.execution.link.LinkSatisfiesAny;
import com.maltego.tx3.java.api.constraints.execution.link.LinkSatisfiesNone;
import com.maltego.tx3.java.api.constraints.execution.property.AbstractStringMatchConstraint;
import com.maltego.tx3.java.api.constraints.execution.property.PropertyExists;
import com.maltego.tx3.java.api.constraints.execution.property.PropertySatisfiesAll;
import com.maltego.tx3.java.api.constraints.execution.property.PropertySatisfiesAny;
import com.maltego.tx3.java.api.constraints.execution.property.PropertySatisfiesNone;
import com.maltego.tx3.java.api.constraints.execution.property.PropertyTypeConstraint;
import com.maltego.tx3.java.api.discovery.TransformDefinition;
import com.maltego.tx3.java.api.discovery.TransformSetting;
import com.maltego.tx3.java.api.discovery.V3OAuthAuthenticatorInfo;
import com.maltego.tx3.java.api.execution.TransformRunSetting;
import com.paterva.maltego.transform.descriptor.CompositeInputConstraint;
import com.paterva.maltego.transform.descriptor.ConstraintStringMatchTypeEnum;
import com.paterva.maltego.transform.descriptor.ConstraintTargetTypeEnum;
import com.paterva.maltego.transform.descriptor.ConstraintTypeEnum;
import com.paterva.maltego.transform.descriptor.InputConstraint;
import com.paterva.maltego.transform.descriptor.LogicalOperation;
import com.paterva.maltego.transform.descriptor.StringMatchConstraint;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.protocol.api.OAuthAuthenticatorInfo;
import com.paterva.maltego.transform.protocol.api.TransformFindException;
import com.paterva.maltego.transform.protocol.api.TransformInfo;
import com.paterva.maltego.transform.protocol.api.TransformInputDescriptor;
import com.paterva.maltego.transform.protocol.v3.api.V3TransformInfo;
import com.paterva.maltego.transform.protocol.v3.api.remote.V3ValueConverter;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openide.util.Exceptions;

public class RemoteTransformTranslator {
    private static final String TRANSFORM_NAME_REGEX = "[a-zA-Z0-9\\-\\_]+";
    private static final String UNKNOWN_CONSTRAINT_VALUE = "UnknownConstraint";
    private static final Set<Class> NO_JSON_NATIVE_TYPES = new HashSet<Class>(Arrays.asList(Date.class, DateTime.class, DateRange.class, Date[].class, DateTime[].class, DateRange[].class));

    public TransformInfo translate(TransformDefinition desc) throws TransformFindException {
        this.validate(desc);
        V3TransformInfo info = new V3TransformInfo();
        info.setAuthor(desc.getAuthor());
        info.setDescription(desc.getDescription());
        info.setDisclaimer(desc.getDisclaimer());
        info.setDisplayName(desc.getDisplayName());
        info.setInputEntityTypes(desc.getInput().getTypeIds());
        info.setMaxInputs(desc.getMaxEntityInputCount());
        info.setMaxOutputs(desc.getMaxEntityOutputCount());
        info.setName(desc.getName());
        info.setOutputEntityTypes((String[])desc.getOutput().getTypeIds().stream().toArray(String[]::new));
        info.setOwner(desc.getOwner());
        info.setVersion(desc.getVersion());
        info.setInputType(desc.getInput().getType());
        info.setPropertyInputType(desc.getInput().getPropertyInputType());
        info.setInputEntityProperties(desc.getInput().getProperties());
        info.setAuthenticator(desc.getAuthenticator());
        if (null != desc.getInput() && null != desc.getInput().getInputConstraint()) {
            info.setInputConstraint(RemoteTransformTranslator.translateTransformConstraint(desc.getInput().getInputConstraint()));
        }
        this.copyInputs(info, desc.getTransformSettings());
        return info;
    }

    public Collection<? extends TransformInfo> translate(List<TransformDefinition> descriptors) throws Exception {
        ArrayList<TransformInfo> info = new ArrayList<TransformInfo>();
        for (TransformDefinition d : descriptors) {
            TransformInfo transformInfo = this.translate(d);
            boolean skip = false;
            if (transformInfo instanceof V3TransformInfo) {
                V3TransformInfo v3TransformInfo = (V3TransformInfo)transformInfo;
                skip = this.containsUnknownConstraint(v3TransformInfo.getInputConstraint());
            }
            if (skip) continue;
            info.add(transformInfo);
        }
        return info;
    }

    private boolean containsUnknownConstraint(InputConstraint inputConstraint) throws TransformFindException {
        CompositeInputConstraint groupConstraint;
        if (null == inputConstraint) {
            return false;
        }
        if (inputConstraint instanceof StringMatchConstraint) {
            StringMatchConstraint propConstr = (StringMatchConstraint)inputConstraint;
            if (UNKNOWN_CONSTRAINT_VALUE.equals(propConstr.getValue())) {
                return true;
            }
        } else if (inputConstraint instanceof CompositeInputConstraint && null != (groupConstraint = (CompositeInputConstraint)inputConstraint).getInnerConstraints()) {
            for (InputConstraint innerConstraint : groupConstraint.getInnerConstraints()) {
                if (!this.containsUnknownConstraint(innerConstraint)) continue;
                return true;
            }
        }
        return false;
    }

    private void copyInputs(TransformInfo info, List<TransformSetting> setting) throws TransformFindException {
        if (setting != null) {
            LinkedHashSet inputs = info.getInputs();
            for (TransformInputDescriptor input : this.translateInputs(setting)) {
                inputs.add(input);
            }
        }
    }

    public Set<TransformInputDescriptor> translateInputs(List<TransformSetting> settings) throws TransformFindException {
        LinkedHashSet<TransformInputDescriptor> inputs = new LinkedHashSet<TransformInputDescriptor>();
        if (settings != null) {
            for (TransformSetting setting : settings) {
                inputs.add(this.translate(setting));
            }
        }
        return inputs;
    }

    private TransformInputDescriptor translate(TransformSetting setting) throws TransformFindException {
        TransformInputDescriptor tid = new TransformInputDescriptor();
        tid.setGlobal(setting.isGlobal());
        tid.setAuth(setting.isAuth());
        tid.setName(setting.getName());
        tid.setDisplayName(setting.getDisplayName());
        tid.setRequired(!setting.isOptional());
        tid.setPopup(setting.isPopup());
        Object settingValue = setting.getDefaultValue();
        Class toClazz = V3ValueConverter.getType(setting.getType());
        if (toClazz == null) {
            throw new TransformFindException("Could not get class for input type " + setting.getType());
        }
        tid.setType(toClazz);
        if (setting.getDefaultValue() != null) {
            if (toClazz.isArray()) {
                Class toArrayClazz = NO_JSON_NATIVE_TYPES.contains(toClazz) ? String.class : toClazz.getComponentType();
                settingValue = Converter.changeArrayType((Object)settingValue, toArrayClazz);
            }
            if (NO_JSON_NATIVE_TYPES.contains(toClazz)) {
                Class fromClazz = toClazz.isArray() ? String[].class : String.class;
                settingValue = Converter.convert((Object)settingValue, fromClazz, (Class)toClazz);
            }
        }
        tid.setDefaultValue(settingValue);
        return tid;
    }

    public Collection<? extends OAuthAuthenticatorInfo> translateOAuth(List<V3OAuthAuthenticatorInfo> oathList) {
        ArrayList<OAuthAuthenticatorInfo> info = new ArrayList<OAuthAuthenticatorInfo>();
        for (V3OAuthAuthenticatorInfo v3AuthInfo : oathList) {
            OAuthAuthenticatorInfo v2Auth = new OAuthAuthenticatorInfo();
            v2Auth.setAccessTokenEndpoint(v3AuthInfo.getAccessTokenEndpoint());
            v2Auth.setAccessTokenInput(v3AuthInfo.getAccessTokenInput());
            v2Auth.setAppKey(v3AuthInfo.getAppKey());
            v2Auth.setAppSecret(v3AuthInfo.getAppSecret());
            v2Auth.setAuthorizationUrl(v3AuthInfo.getAuthorizationUrl());
            v2Auth.setCallbackPort(v3AuthInfo.getCallbackPort());
            v2Auth.setDescription(v3AuthInfo.getDescription());
            v2Auth.setDisplayName(v3AuthInfo.getDisplayName());
            v2Auth.setIcon(v3AuthInfo.getIcon());
            v2Auth.setName(v3AuthInfo.getName());
            v2Auth.setOAuthVersion(v3AuthInfo.getOauthVersion());
            v2Auth.setRefreshTokenEndpoint(v3AuthInfo.getRefreshTokenEndpoint());
            v2Auth.setRequestTokenEndpoint(v3AuthInfo.getRequestTokenEndpoint());
            v2Auth.setRequestTypeForAccessToken(v3AuthInfo.getRequestTypeForAccessToken());
            v2Auth.setRequestTypeForAuthorizationUrl(v3AuthInfo.getRequestTypeForAuthorizationUrl());
            v2Auth.setRequestTypeForRequestToken(v3AuthInfo.getRequestTypeForRequestToken());
            v2Auth.setUseSSLHost(v3AuthInfo.isUseSSLHost());
            v2Auth.setUseClientAuthorizationHeader(v3AuthInfo.isUseClientAuthorizationHeader());
            v2Auth.setAccessTokenPublicKey(v3AuthInfo.getAccessTokenPublicKey());
            info.add(v2Auth);
        }
        return info;
    }

    private void validate(TransformDefinition desc) throws TransformFindException {
        String name;
        String[] parts;
        if (desc.getName() != null && (parts = desc.getName().split("\\.")).length > 0 && !(name = parts[parts.length - 1]).matches(TRANSFORM_NAME_REGEX)) {
            throw new TransformFindException(String.format("The discovered transform name %s is invalid. The name may only contain alphanumeric characters, hyphens, and underscores.", name));
        }
    }

    public static List<TransformRunSetting> translate(TransformDescriptor transform, DataSource transformInputs) throws TransformRunException {
        Args.notNull((Object)transform, (String)"transform");
        Args.notNull((Object)transformInputs, (String)"transformInputs");
        ArrayList<TransformRunSetting> settings = new ArrayList<TransformRunSetting>();
        for (DisplayDescriptor dd : transform.getProperties()) {
            try {
                ArrayList<String> value = transformInputs.getValue((PropertyDescriptor)dd);
                if (NO_JSON_NATIVE_TYPES.contains(dd.getType())) {
                    if (value != null && value instanceof Object[]) {
                        ArrayList<String> values = new ArrayList<String>();
                        for (Object obj : (Object[])value) {
                            values.add(V3ValueConverter.write(obj, dd.getType().getComponentType()));
                        }
                        value = values;
                    } else {
                        value = V3ValueConverter.write(value, dd.getType());
                    }
                }
                if (value == null) continue;
                settings.add(new TransformRunSetting(dd.getName(), (Object)value));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return settings;
    }

    public static InputConstraint translateTransformConstraint(com.maltego.tx3.java.api.constraints.execution.InputConstraint discoveryConstraint) throws TransformFindException {
        InputConstraint result = null;
        if (discoveryConstraint == null) {
            return null;
        }
        LogicalOperation logicalOperation = null == discoveryConstraint.getConstraintOperation() ? LogicalOperation.ANY : LogicalOperation.valueOf((String)discoveryConstraint.getConstraintOperation().name());
        result = discoveryConstraint.getConstraintType() == com.maltego.tx3.java.api.constraints.ConstraintTypeEnum.GROUP_CONSTRAINT ? RemoteTransformTranslator.translateGroupConstraint(discoveryConstraint, logicalOperation) : RemoteTransformTranslator.translateLeafConstraint(discoveryConstraint);
        return result;
    }

    private static InputConstraint translateGroupConstraint(com.maltego.tx3.java.api.constraints.execution.InputConstraint discoveryConstraint, LogicalOperation logicalOperation) throws TransformFindException {
        ArrayList<InputConstraint> innerConstraints = new ArrayList<InputConstraint>();
        if (null != discoveryConstraint.getInnerConstraints()) {
            for (com.maltego.tx3.java.api.constraints.execution.InputConstraint innerDiscoveryConstraint : discoveryConstraint.getInnerConstraints()) {
                innerConstraints.add(RemoteTransformTranslator.translateTransformConstraint(innerDiscoveryConstraint));
            }
        }
        ConstraintTypeEnum compositeConstraintType = null;
        if (discoveryConstraint instanceof EntitySatisfiesAll || discoveryConstraint instanceof EntitySatisfiesAny || discoveryConstraint instanceof EntitySatisfiesNone) {
            compositeConstraintType = ConstraintTypeEnum.ENTITY;
        } else if (discoveryConstraint instanceof PropertySatisfiesAll || discoveryConstraint instanceof PropertySatisfiesAny || discoveryConstraint instanceof PropertySatisfiesNone) {
            compositeConstraintType = ConstraintTypeEnum.PROPERTY;
        } else if (discoveryConstraint instanceof GraphSatisfiesAll || discoveryConstraint instanceof GraphSatisfiesAny || discoveryConstraint instanceof GraphSatisfiesNone) {
            compositeConstraintType = ConstraintTypeEnum.GRAPH;
        } else if (discoveryConstraint instanceof LinkSatisfiesAll || discoveryConstraint instanceof LinkSatisfiesAny || discoveryConstraint instanceof LinkSatisfiesNone) {
            compositeConstraintType = ConstraintTypeEnum.LINK;
        } else {
            throw new TransformFindException("Unknown composite constraint class " + discoveryConstraint.toString());
        }
        return new CompositeInputConstraint(innerConstraints, logicalOperation, compositeConstraintType);
    }

    private static InputConstraint translateLeafConstraint(com.maltego.tx3.java.api.constraints.execution.InputConstraint discoveryConstraint) throws TransformFindException {
        ConstraintTargetTypeEnum targetType = ConstraintTargetTypeEnum.valueOf((String)discoveryConstraint.getConstraintTargetType().name());
        String value = null;
        Boolean ignoreCase = false;
        ConstraintStringMatchTypeEnum matchType = null;
        if (discoveryConstraint instanceof PropertyExists) {
            value = ((PropertyExists)discoveryConstraint).getPropertyName();
            ignoreCase = true;
            matchType = ConstraintStringMatchTypeEnum.EQUALSIGNORECASE;
        } else if (discoveryConstraint instanceof PropertyTypeConstraint) {
            PropertyTypeConstraint propertyTypeConstraint = (PropertyTypeConstraint)discoveryConstraint;
            value = propertyTypeConstraint.getValue();
            ignoreCase = true;
            matchType = ConstraintStringMatchTypeEnum.EQUALS;
        } else if (discoveryConstraint instanceof AbstractStringMatchConstraint) {
            AbstractStringMatchConstraint abstractConstraint = (AbstractStringMatchConstraint)discoveryConstraint;
            value = abstractConstraint.getValue();
            ignoreCase = abstractConstraint.getIgnoreCase();
            matchType = ConstraintStringMatchTypeEnum.valueOf((String)abstractConstraint.getMatchType().name());
        } else if (discoveryConstraint instanceof EntityTypeConstraint) {
            EntityTypeConstraint entityTypeConstraint = (EntityTypeConstraint)discoveryConstraint;
            value = entityTypeConstraint.getEntityType();
            ignoreCase = true;
            matchType = ConstraintStringMatchTypeEnum.EQUALSIGNORECASE;
        } else if (discoveryConstraint instanceof BaseEntitySatisfies) {
            BaseEntitySatisfies baseEntitySatisfies = (BaseEntitySatisfies)discoveryConstraint;
            value = baseEntitySatisfies.getMatchValue();
            ignoreCase = false;
            matchType = baseEntitySatisfies.getOperation() == BaseEntitySatisfies.MatchOperation.CONTAINS ? ConstraintStringMatchTypeEnum.CONTAINS : ConstraintStringMatchTypeEnum.EQUALS;
        } else if (discoveryConstraint instanceof DefaultUnknownConstraint) {
            value = UNKNOWN_CONSTRAINT_VALUE;
            matchType = ConstraintStringMatchTypeEnum.EQUALS;
        } else {
            throw new TransformFindException("Unsupported constraint type: " + discoveryConstraint.getClass().getName());
        }
        return new StringMatchConstraint(value, matchType, ignoreCase, targetType, ConstraintTypeEnum.valueOf((String)discoveryConstraint.getConstraintType().name()));
    }
}

