/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.types;

import com.pinkmatter.types.Converter;
import com.pinkmatter.types.Geography;
import com.pinkmatter.types.SpatialFactory;
import com.vividsolutions.jts.geom.Geometry;

public class Coordinate
extends Geography {
    private double _lat;
    private double _lon;

    public Coordinate(double lat, double lon) {
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public double getLatitude() {
        return this._lat;
    }

    public final void setLatitude(double lat) {
        if (!Coordinate.isValidLatitude(lat)) {
            throw new IllegalArgumentException("Invalid latitude. Value must be between -90 and 90 value is '" + lat + "'");
        }
        this._lat = lat;
    }

    public double getLongitude() {
        return this._lon;
    }

    public final void setLongitude(double lon) {
        if (!Coordinate.isValidLongitude(lon)) {
            throw new IllegalArgumentException("Invalid longitude. Value must be between -180 and 180 value is '" + lon + "'");
        }
        this._lon = lon;
    }

    public static boolean isValidLongitude(double lon) {
        return lon <= 180.0 && lon >= -180.0;
    }

    public static boolean isValidLatitude(double lat) {
        return lat <= 90.0 && lat >= -90.0;
    }

    public boolean isEast() {
        return Coordinate.isEastLongitude(this._lon);
    }

    public boolean isNorth() {
        return Coordinate.isNorthLatitude(this._lat);
    }

    public static boolean isEastLongitude(double lon) {
        return lon >= 0.0;
    }

    public static boolean isNorthLatitude(double lat) {
        return lat >= 0.0;
    }

    public static boolean cross180Longitude(Coordinate from, Coordinate to) {
        return from.getLongitude() > to.getLongitude();
    }

    public String toString() {
        return this._lat + " " + this._lon;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (int)(Double.doubleToLongBits(this._lat) ^ Double.doubleToLongBits(this._lat) >>> 32);
        hash = 41 * hash + (int)(Double.doubleToLongBits(this._lon) ^ Double.doubleToLongBits(this._lon) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coordinate) {
            return this.equals((Coordinate)obj);
        }
        return false;
    }

    public boolean equals(Coordinate coord) {
        if (coord == null) {
            return false;
        }
        return this._lat == coord._lat && this._lon == coord._lon;
    }

    @Override
    public Coordinate getCoordinate() {
        return this;
    }

    @Override
    public Coordinate getCentroid() {
        return this;
    }

    @Override
    public Coordinate[] getCoordinates() {
        return new Coordinate[]{this};
    }

    @Override
    protected Geometry getGeometry() {
        return SpatialFactory.getDefault().getGeometryFactory().createPoint(Converter.toJts(this));
    }
}

