/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.settings;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.netbeans.modules.jumpto.settings.GoToSettings;
import org.netbeans.modules.jumpto.settings.JumpToOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class JumpToPanel
extends JPanel
implements ActionListener {
    private final JumpToOptionsPanelController controller;
    private JComboBox by;
    private JComboBox highlight;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JComboBox<GoToSettings.SortingType> orderBy;
    private JLabel orderByLabel;
    private JCheckBox preferOpenPrj;

    JumpToPanel(JumpToOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        for (GoToSettings.SortingType t : GoToSettings.SortingType.values()) {
            this.orderBy.addItem(t);
        }
        this.orderBy.setRenderer(new SortingTypeRenderer());
        this.highlight.addActionListener(this);
        this.by.addActionListener(this);
        this.orderBy.addActionListener(this);
        this.preferOpenPrj.addActionListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.highlight = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.by = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.orderByLabel = new JLabel();
        this.orderBy = new JComboBox();
        this.jLabel4 = new JLabel();
        this.preferOpenPrj = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jLabel1.setLabelFor(this.highlight);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JumpToPanel.class, (String)"LBL_Highlight"));
        this.highlight.setModel(new DefaultComboBoxModel<GoToSettings.HighlightingMode>(GoToSettings.HighlightingMode.values()));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(JumpToPanel.class, (String)"LBL_Highlighting"));
        this.jLabel3.setLabelFor(this.by);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(JumpToPanel.class, (String)"LBL_Highlight_By"));
        this.jLabel3.setToolTipText(NbBundle.getMessage(JumpToPanel.class, (String)"JumpToPanel.jLabel3.toolTipText"));
        this.by.setModel(new DefaultComboBoxModel<GoToSettings.HighlightingType>(GoToSettings.HighlightingType.values()));
        this.orderByLabel.setLabelFor(this.orderBy);
        Mnemonics.setLocalizedText((JLabel)this.orderByLabel, (String)NbBundle.getMessage(JumpToPanel.class, (String)"JumpToPanel.orderByLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(JumpToPanel.class, (String)"JumpToPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.preferOpenPrj, (String)NbBundle.getMessage(JumpToPanel.class, (String)"JumpToPanel.preferOpenPrj.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.orderByLabel).addGap(51, 51, 51).addComponent(this.orderBy, -2, 200, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.highlight, 0, -1, Short.MAX_VALUE).addComponent(this.by, -2, 200, -2)))).addComponent(this.jLabel4)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.preferOpenPrj).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jSeparator1, -2, 10, -2)).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.highlight, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.by, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.orderBy, -2, -1, -2).addComponent(this.orderByLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preferOpenPrj).addContainerGap(37, Short.MAX_VALUE)));
        this.highlight.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JumpToPanel.class, (String)"AD_Highlight"));
        this.by.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JumpToPanel.class, (String)"AD_Highlight_By"));
    }

    void load() {
        GoToSettings settings = GoToSettings.getDefault();
        this.highlight.setSelectedItem((Object)settings.getHighlightingMode());
        this.by.setSelectedItem((Object)settings.getHighlightingType());
        this.orderBy.setSelectedItem((Object)settings.getSortingType());
        this.preferOpenPrj.setSelected(settings.isSortingPreferOpenProjects());
    }

    void store() {
        GoToSettings settings = GoToSettings.getDefault();
        settings.setHighlightingMode((GoToSettings.HighlightingMode)((Object)this.highlight.getSelectedItem()));
        settings.setHighlightingType((GoToSettings.HighlightingType)((Object)this.by.getSelectedItem()));
        settings.setSortingType((GoToSettings.SortingType)((Object)this.orderBy.getSelectedItem()));
        settings.setSortingPreferOpenProjects(this.preferOpenPrj.isSelected());
    }

    boolean valid() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isChanged = false;
        GoToSettings settings = GoToSettings.getDefault();
        if (this.highlight.getSelectedItem() != settings.getHighlightingMode() || this.by.getSelectedItem() != settings.getHighlightingType() || this.orderBy.getSelectedItem() != settings.getSortingType() || this.preferOpenPrj.isSelected() ^ settings.isSortingPreferOpenProjects()) {
            isChanged = true;
        }
        this.controller.changed(isChanged);
    }

    private static final class SortingTypeRenderer
    extends DefaultListCellRenderer {
        private SortingTypeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof GoToSettings.SortingType) {
                value = ((GoToSettings.SortingType)((Object)value)).getDisplayName();
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

