/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.external;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.MaltegoGraphSnippet;
import com.paterva.maltego.graph.external.MaltegoGraphXNewGraphAction;
import com.paterva.maltego.graph.external.MaltegoGraphXRegistry;
import com.paterva.maltego.graph.external.api.GraphXDescriptor;
import com.paterva.maltego.graph.external.api.GraphXEntryPoint;
import com.paterva.maltego.graph.external.api.GraphXException;
import com.paterva.maltego.graph.external.api.GraphXListener;
import com.paterva.maltego.graph.external.api.GraphXNewGraphResult;
import com.paterva.maltego.graph.external.api.GraphXRegistry;
import com.paterva.maltego.graph.external.api.GraphXTransactionListener;
import com.paterva.maltego.graph.external.api.GraphXUpdateResult;
import com.paterva.maltego.graph.store.GraphStoreFactory;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.matching.api.GraphMatchStrategy;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.merging.GraphMergerFactory;
import com.paterva.maltego.ui.graph.GraphCopyHelper;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;

public class MaltegoGraphXEntryPoint
extends GraphXEntryPoint {
    public List<GraphXDescriptor> getGraphs() throws GraphXException {
        this.checkThread();
        try {
            return GraphXRegistry.getDefault().getGraphXDescriptors();
        }
        catch (Exception ex) {
            this.rethrow(ex);
            return null;
        }
    }

    public GraphID getGraphID(int id, boolean clone) throws GraphXException {
        this.checkThread();
        try {
            GraphID graphID = GraphXRegistry.getDefault().getGraphID(id);
            if (graphID != null && clone) {
                graphID = GraphCopyHelper.copy((GraphID)graphID);
            }
            return graphID;
        }
        catch (Exception ex) {
            this.rethrow(ex);
            return null;
        }
    }

    public GraphXNewGraphResult newGraph(String name) throws GraphXException {
        this.checkThread();
        try {
            MaltegoGraphXNewGraphAction openAction = (MaltegoGraphXNewGraphAction)SystemAction.get(MaltegoGraphXNewGraphAction.class);
            openAction.setName(name);
            openAction.performAction();
            GraphDataObject gdo = (GraphDataObject)openAction.getCreatedDataObject();
            GraphXDescriptor descriptor = MaltegoGraphXRegistry.getGraphXDescriptor(gdo);
            return new GraphXNewGraphResult(descriptor.getId(), descriptor.getName());
        }
        catch (Exception ex) {
            this.rethrow(ex);
            return null;
        }
    }

    public GraphXUpdateResult update(int id, MaltegoGraphSnippet graph, GraphMatchStrategy matchStrat, GraphMergeStrategy mergeStrat) throws GraphXException {
        this.checkThread();
        try {
            GraphID srcGraphID = this.createGraph(graph);
            GraphID destGraphID = GraphXRegistry.getDefault().getGraphID(id);
            String descriptionStr = "%s " + GraphTransactionHelper.getDescriptionForEntities((GraphID)destGraphID, (Collection)graph.getEntities(), (boolean)true);
            SimilarStrings descriptions = new SimilarStrings(descriptionStr, "Add/update", "Delete/unmerge");
            GraphMerger graphMerger = GraphMergerFactory.getDefault().create(descriptions, matchStrat, mergeStrat, null, true, true, true);
            graphMerger.setGraphs(destGraphID, srcGraphID, null);
            graphMerger.append();
            GraphXUpdateResult result = new GraphXUpdateResult();
            result.putEntities(graphMerger.getEntityMapping());
            result.putLinks(graphMerger.getLinkMapping());
            return result;
        }
        catch (Exception ex) {
            this.rethrow(ex);
            return null;
        }
    }

    private GraphID createGraph(MaltegoGraphSnippet graphSnippet) {
        GraphID graphID = GraphID.create();
        try {
            EntityRegistry.associate((GraphID)graphID, (EntityRegistry)EntityRegistry.getDefault());
            LinkRegistry.associate((GraphID)graphID, (LinkRegistry)LinkRegistry.getDefault());
            GraphStoreFactory.getDefault().create(graphID, true);
            Collection links = graphSnippet.getLinks();
            HashMap<MaltegoLink, LinkEntityIDs> linksMap = new HashMap<MaltegoLink, LinkEntityIDs>(links.size());
            for (MaltegoLink link : links) {
                LinkEntityIDs entityIDs = (LinkEntityIDs)graphSnippet.getConnections().get(link.getID());
                linksMap.put(link, entityIDs);
            }
            GraphStoreWriter.addEntities((GraphID)graphID, (Collection)graphSnippet.getEntities());
            GraphStoreWriter.addLinks((GraphID)graphID, linksMap);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return graphID;
    }

    public void addGraphXListener(GraphXListener listener) throws GraphXException {
        this.checkThread();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeGraphXListener(GraphXListener listener) throws GraphXException {
        this.checkThread();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addGraphXTransactionListener(int id, GraphXTransactionListener listener) throws GraphXException {
        this.checkThread();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeGraphXTransactionListener(int id, GraphXTransactionListener listener) throws GraphXException {
        this.checkThread();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void checkThread() throws GraphXException {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new GraphXException("GraphX API may only be accessed from the UI thread.");
        }
    }

    private void rethrow(Exception ex) throws GraphXException {
        if (ex instanceof GraphXException) {
            throw (GraphXException)ex;
        }
        throw new GraphXException((Throwable)ex);
    }
}

