/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.util.Objects;

class LineMargin {
    private final int clearX;
    private final int clearY;
    private final LineMargin next;

    public LineMargin(LineMargin next, int cleary, int totalXOffset) {
        this.next = next;
        this.clearY = cleary;
        this.clearX = totalXOffset;
    }

    public int getClearY() {
        return this.clearY;
    }

    public LineMargin getNext() {
        return this.next;
    }

    public int getOffset() {
        return this.clearX;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LineMargin)) {
            return false;
        }
        LineMargin olm = (LineMargin)other;
        return olm.clearX == this.clearX && olm.clearY == this.clearY && Objects.equals(olm.next, this.next);
    }

    public LineMargin translated(int yoffset, int xoffset) {
        LineMargin oldNext;
        int newClearY = this.clearY - yoffset;
        int newOffsetX = this.clearX - xoffset;
        if (newOffsetX < 0) {
            newOffsetX = 0;
        }
        LineMargin newNext = (oldNext = this.next) == null ? null : oldNext.translated(yoffset, xoffset);
        return new LineMargin(newNext, newClearY, newOffsetX);
    }
}

