/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.csv.io;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180Parser;
import com.paterva.maltego.graph.table.Table;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CSVTableReader
extends Table {
    public CSVTableReader(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr, 131072);
             CSVReader reader = new CSVReaderBuilder((Reader)br).withCSVParser((ICSVParser)new RFC4180Parser()).build();){
            for (String[] array : reader) {
                if (array.length == 1 && array[0].isEmpty()) {
                    super.addRow(Collections.emptyList());
                    continue;
                }
                super.addRow(Arrays.stream(array).collect(Collectors.toList()));
            }
        }
    }

    public void addRow(List<String> row) {
        throw new UnsupportedOperationException("This is a READER only");
    }
}

