/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.FileEntry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveOutputStream;
import com.paterva.maltego.archive.mtz.MaltegoWriter;
import com.paterva.maltego.archive.mtz.MtzVersion;
import com.paterva.maltego.archive.mtz.MtzVersionEntry;
import com.paterva.maltego.util.FileUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class MaltegoArchiveWriter
implements MaltegoWriter {
    private MaltegoArchiveOutputStream _stream;
    private ZipFile _zipFile;
    private ZipParameters _params;
    private final Set<String> _entries = new HashSet<String>();

    public MaltegoArchiveWriter(MtzVersion version, OutputStream stream) throws IOException {
        this._stream = new MaltegoArchiveOutputStream(stream);
        this.writeVersion(version);
    }

    public MaltegoArchiveWriter(MtzVersion version, ZipFile zipFile, ZipParameters params) throws IOException {
        this._zipFile = zipFile;
        this._params = params;
        this.writeVersion(version);
    }

    @Override
    public <T> void write(Entry<T> entry) throws IOException {
        String name = entry.getName();
        if (!this._entries.contains(name)) {
            if (this._stream != null) {
                this.writeNormal(entry);
            } else {
                this.writeEncrypted(entry);
            }
            this._entries.add(name);
        }
    }

    private <T> void writeNormal(Entry<T> entry) throws IOException {
        try {
            this._stream.addEntry(entry);
            entry.write(entry.getData(), this._stream);
        }
        finally {
            this._stream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void writeEncrypted(Entry<T> entry) throws IOException {
        File f = null;
        boolean tmpFile = false;
        if (entry instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)entry;
            f = fileEntry.getFile();
        } else {
            File dir = FileUtilities.createTempDir((String)"Zip");
            FileUtilities.deleteContents((File)dir);
            f = new File(dir, entry.getTypeName() + "." + entry.getType());
            try (FileOutputStream fOS = null;){
                fOS = new FileOutputStream(f);
                entry.write(entry.getData(), fOS);
            }
            tmpFile = true;
        }
        this._params.setRootFolderInZip(entry.getFolder());
        try {
            this._zipFile.addFile(f, this._params);
        }
        catch (ZipException ex) {
            throw new IOException(ex);
        }
        finally {
            if (tmpFile && f != null) {
                f.delete();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
    }

    private void writeVersion(MtzVersion version) throws IOException {
        this.write(new MtzVersionEntry(version));
    }
}

