/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.option;

import com.paterva.maltego.automation.option.HashSeperatedPairs;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MachineOptions {
    private String _optionText;
    private String _machineText;
    private String _argumentText;
    private String _entityText;
    private List<String[]> _entityPairs;
    private Boolean _shutdown;
    private Integer _iterations;
    private Boolean _fullscreen;

    public MachineOptions(String optionText) {
        this._optionText = optionText;
    }

    public synchronized String getMachineText() {
        if (this._machineText == null) {
            this.splitOptionText();
        }
        return this._machineText;
    }

    public synchronized String getArgumentText() {
        if (this._argumentText == null) {
            this.splitOptionText();
        }
        return this._argumentText;
    }

    public synchronized String getEntityText() {
        if (this._entityText == null) {
            this.splitOptionText();
        }
        return this._entityText;
    }

    public synchronized List<String[]> getEntityPairs() throws ParseException {
        if (this._entityPairs == null) {
            this._entityPairs = HashSeperatedPairs.parse(this.getEntityText());
        }
        return this._entityPairs;
    }

    public synchronized boolean shutdownWhenComplete() {
        if (this._shutdown == null) {
            String argumentText = this.getArgumentText();
            this._shutdown = argumentText.contains("-q");
        }
        return this._shutdown;
    }

    public synchronized boolean isFullscreen() {
        if (this._fullscreen == null) {
            String argumentText = this.getArgumentText();
            this._fullscreen = argumentText.contains("-f");
        }
        return this._fullscreen;
    }

    public synchronized int getIterations() {
        if (this._iterations == null) {
            int iterations = Integer.MAX_VALUE;
            String argumentText = this.getArgumentText();
            Matcher matcher = Pattern.compile("-i(\\d+)").matcher(argumentText);
            if (matcher.find()) {
                String iterationsStr = matcher.group(1);
                iterations = Integer.parseInt(iterationsStr);
            }
            this._iterations = iterations;
        }
        return this._iterations;
    }

    public static String[] getEntityTypes(List<String[]> entityPairs) {
        String[] provided = new String[entityPairs.size()];
        for (int i = 0; i < entityPairs.size(); ++i) {
            provided[i] = entityPairs.get(i)[0];
        }
        return provided;
    }

    private void splitOptionText() {
        String otherText;
        int index = this._optionText.indexOf(32);
        if (index == -1) {
            this._machineText = this._optionText;
            otherText = "";
        } else {
            this._machineText = this._optionText.substring(0, index);
            otherText = this._optionText.substring(index + 1);
        }
        int spaceIndex = otherText.indexOf(32);
        int equalsIndex = otherText.indexOf(61);
        if (equalsIndex > 0) {
            if (spaceIndex > 0 && spaceIndex < equalsIndex) {
                spaceIndex = otherText.lastIndexOf(32, equalsIndex);
                this._argumentText = otherText.substring(0, spaceIndex).trim();
                this._entityText = otherText.substring(spaceIndex + 1);
            } else {
                this._argumentText = "";
                this._entityText = otherText;
            }
        } else {
            this._argumentText = otherText.trim();
            this._entityText = "";
        }
    }
}

