/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view;

import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.view.MachineDetailsControl;
import com.paterva.maltego.licensing.UserInfo;
import com.paterva.maltego.typing.TypeNameValidator;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import org.openide.WizardDescriptor;

class MachineDetailsController
extends ValidatingController<MachineDetailsControl> {
    MachineDetailsController() {
    }

    protected MachineDetailsControl createComponent() {
        final MachineDetailsControl c = new MachineDetailsControl();
        c.addChangeListener(this.changeListener());
        c.addDisplayNameFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String id = c.getID();
                if (id.trim().length() == 0) {
                    c.setID(MachineDetailsController.this.createID(c.getDisplayName()));
                }
            }
        });
        return c;
    }

    private String createID(String displayName) {
        UserInfo userInfo = new UserInfo();
        String prefix = userInfo.getNamespace();
        if (StringUtilities.isNullOrEmpty((String)prefix)) {
            prefix = userInfo.isEmailUser() ? userInfo.getFullName() : userInfo.getUsername();
        }
        if (StringUtilities.isNullOrEmpty((String)prefix)) {
            prefix = "yourorganization";
        }
        return (prefix.toLowerCase() + "." + displayName).replaceAll(" ", "");
    }

    protected String getFirstError(MachineDetailsControl component) {
        try {
            String name = component.getDisplayName();
            if (name.trim().length() == 0) {
                return "Display name is required";
            }
            String id = component.getID();
            if ((id = id.trim()).length() == 0) {
                return "Machine ID is required";
            }
            String error = TypeNameValidator.checkName((String)id);
            if (error != null) {
                return error;
            }
            MachineRepository registry = (MachineRepository)((Object)this.getDescriptor().getProperty("repository"));
            if (registry.get(id) != null) {
                return "A machine with ID '" + id + "' is already registered";
            }
            return null;
        }
        catch (IOException ex) {
            return "Error accessing machine repository: " + ex.getMessage();
        }
    }

    protected void readSettings(WizardDescriptor descriptor) {
        String name = (String)descriptor.getProperty("displayName");
        String id = (String)descriptor.getProperty("id");
        String description = (String)descriptor.getProperty("description");
        String author = (String)descriptor.getProperty("author");
        ((MachineDetailsControl)this.component()).setDisplayName(name);
        ((MachineDetailsControl)this.component()).setID(id);
        ((MachineDetailsControl)this.component()).setDescription(description);
        ((MachineDetailsControl)this.component()).setAuthor(author);
    }

    protected void storeSettings(WizardDescriptor descriptor) {
        descriptor.putProperty("id", (Object)((MachineDetailsControl)this.component()).getID());
        descriptor.putProperty("displayName", (Object)((MachineDetailsControl)this.component()).getDisplayName());
        descriptor.putProperty("description", (Object)((MachineDetailsControl)this.component()).getDescription());
        descriptor.putProperty("author", (Object)((MachineDetailsControl)this.component()).getAuthor());
    }
}

