/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.BodyParser;
import com.kenai.jbosh.BodyParserResults;
import com.kenai.jbosh.BodyQName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class BodyParserSAX
implements BodyParser {
    private static final Logger LOG = Logger.getLogger(BodyParserSAX.class.getName());
    private static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    private static final ThreadLocal<SoftReference<SAXParser>> PARSER;

    BodyParserSAX() {
    }

    public BodyParserResults parse(String xml) throws BOSHException {
        Exception thrown;
        BodyParserResults result = new BodyParserResults();
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(xml.getBytes());
            SAXParser parser = BodyParserSAX.getSAXParser();
            parser.parse((InputStream)inStream, (DefaultHandler)new Handler(parser, result));
            return result;
        }
        catch (SAXException saxx) {
            thrown = saxx;
        }
        catch (IOException iox) {
            thrown = iox;
        }
        throw new BOSHException("Could not parse body:\n" + xml, thrown);
    }

    private static SAXParser getSAXParser() {
        SoftReference<SAXParser> ref = PARSER.get();
        SAXParser result = ref.get();
        if (result == null) {
            Exception thrown;
            try {
                result = SAX_FACTORY.newSAXParser();
                ref = new SoftReference<SAXParser>(result);
                PARSER.set(ref);
                return result;
            }
            catch (ParserConfigurationException ex) {
                thrown = ex;
            }
            catch (SAXException ex) {
                thrown = ex;
            }
            throw new IllegalStateException("Could not create SAX parser", thrown);
        }
        result.reset();
        return result;
    }

    static {
        SAX_FACTORY.setNamespaceAware(true);
        SAX_FACTORY.setValidating(false);
        PARSER = new ThreadLocal<SoftReference<SAXParser>>(){

            @Override
            protected SoftReference<SAXParser> initialValue() {
                return new SoftReference<Object>(null);
            }
        };
    }

    private static final class Handler
    extends DefaultHandler {
        private final BodyParserResults result;
        private final SAXParser parser;
        private String defaultNS = null;

        private Handler(SAXParser theParser, BodyParserResults results) {
            this.parser = theParser;
            this.result = results;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            BodyQName bodyName;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Start element: " + qName);
                LOG.finest("    URI: " + uri);
                LOG.finest("    local: " + localName);
            }
            if (!(bodyName = AbstractBody.getBodyQName()).getNamespaceURI().equals(uri) || !bodyName.getLocalPart().equals(localName)) {
                throw new IllegalStateException("Root element was not '" + bodyName.getLocalPart() + "' in the '" + bodyName.getNamespaceURI() + "' namespace.  (Was '" + localName + "' in '" + uri + "')");
            }
            for (int idx = 0; idx < attributes.getLength(); ++idx) {
                String attrURI = attributes.getURI(idx);
                if (attrURI.length() == 0) {
                    attrURI = this.defaultNS;
                }
                String attrLN = attributes.getLocalName(idx);
                String attrVal = attributes.getValue(idx);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("    Attribute: {" + attrURI + "}" + attrLN + " = '" + attrVal + "'");
                }
                BodyQName aqn = BodyQName.create(attrURI, attrLN);
                this.result.addBodyAttributeValue(aqn, attrVal);
            }
            this.parser.reset();
        }

        public void startPrefixMapping(String prefix, String uri) {
            if (prefix.length() == 0) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Prefix mapping: <DEFAULT> => " + uri);
                }
                this.defaultNS = uri;
            } else if (LOG.isLoggable(Level.FINEST)) {
                LOG.info("Prefix mapping: " + prefix + " => " + uri);
            }
        }
    }
}

