﻿// <auto-generated />

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using Microsoft.AspNetCore.Razor.Language.Legacy;

namespace Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax
{


  internal abstract partial class RazorBlockSyntax : RazorSyntaxNode
  {
    internal RazorBlockSyntax(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal RazorBlockSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract SyntaxList<RazorSyntaxNode> Children { get; }
  }

  internal sealed partial class RazorDocumentSyntax : RazorSyntaxNode
  {
    private readonly RazorBlockSyntax _document;
    private readonly SyntaxToken _endOfFile;

    internal RazorDocumentSyntax(SyntaxKind kind, RazorBlockSyntax document, SyntaxToken endOfFile, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(document);
        _document = document;
        AdjustFlagsAndWidth(endOfFile);
        _endOfFile = endOfFile;
    }


    internal RazorDocumentSyntax(SyntaxKind kind, RazorBlockSyntax document, SyntaxToken endOfFile)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(document);
        _document = document;
        AdjustFlagsAndWidth(endOfFile);
        _endOfFile = endOfFile;
    }

    public RazorBlockSyntax Document { get { return _document; } }
    public SyntaxToken EndOfFile { get { return _endOfFile; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _document;
            case 1: return _endOfFile;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.RazorDocumentSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorDocument(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorDocument(this);
    }

    public RazorDocumentSyntax Update(RazorBlockSyntax document, SyntaxToken endOfFile)
    {
        if (document != Document || endOfFile != EndOfFile)
        {
            var newNode = SyntaxFactory.RazorDocument(document, endOfFile);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new RazorDocumentSyntax(Kind, _document, _endOfFile, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new RazorDocumentSyntax(Kind, _document, _endOfFile, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class RazorCommentBlockSyntax : RazorSyntaxNode
  {
    private readonly SyntaxToken _startCommentTransition;
    private readonly SyntaxToken _startCommentStar;
    private readonly SyntaxToken _comment;
    private readonly SyntaxToken _endCommentStar;
    private readonly SyntaxToken _endCommentTransition;

    internal RazorCommentBlockSyntax(SyntaxKind kind, SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 5;
        AdjustFlagsAndWidth(startCommentTransition);
        _startCommentTransition = startCommentTransition;
        AdjustFlagsAndWidth(startCommentStar);
        _startCommentStar = startCommentStar;
        AdjustFlagsAndWidth(comment);
        _comment = comment;
        AdjustFlagsAndWidth(endCommentStar);
        _endCommentStar = endCommentStar;
        AdjustFlagsAndWidth(endCommentTransition);
        _endCommentTransition = endCommentTransition;
    }


    internal RazorCommentBlockSyntax(SyntaxKind kind, SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
        : base(kind)
    {
        SlotCount = 5;
        AdjustFlagsAndWidth(startCommentTransition);
        _startCommentTransition = startCommentTransition;
        AdjustFlagsAndWidth(startCommentStar);
        _startCommentStar = startCommentStar;
        AdjustFlagsAndWidth(comment);
        _comment = comment;
        AdjustFlagsAndWidth(endCommentStar);
        _endCommentStar = endCommentStar;
        AdjustFlagsAndWidth(endCommentTransition);
        _endCommentTransition = endCommentTransition;
    }

    public SyntaxToken StartCommentTransition { get { return _startCommentTransition; } }
    public SyntaxToken StartCommentStar { get { return _startCommentStar; } }
    public SyntaxToken Comment { get { return _comment; } }
    public SyntaxToken EndCommentStar { get { return _endCommentStar; } }
    public SyntaxToken EndCommentTransition { get { return _endCommentTransition; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _startCommentTransition;
            case 1: return _startCommentStar;
            case 2: return _comment;
            case 3: return _endCommentStar;
            case 4: return _endCommentTransition;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.RazorCommentBlockSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorCommentBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorCommentBlock(this);
    }

    public RazorCommentBlockSyntax Update(SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
    {
        if (startCommentTransition != StartCommentTransition || startCommentStar != StartCommentStar || comment != Comment || endCommentStar != EndCommentStar || endCommentTransition != EndCommentTransition)
        {
            var newNode = SyntaxFactory.RazorCommentBlock(startCommentTransition, startCommentStar, comment, endCommentStar, endCommentTransition);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new RazorCommentBlockSyntax(Kind, _startCommentTransition, _startCommentStar, _comment, _endCommentStar, _endCommentTransition, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new RazorCommentBlockSyntax(Kind, _startCommentTransition, _startCommentStar, _comment, _endCommentStar, _endCommentTransition, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class RazorMetaCodeSyntax : RazorSyntaxNode
  {
    private readonly GreenNode _metaCode;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal RazorMetaCodeSyntax(SyntaxKind kind, GreenNode metaCode, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (metaCode != null)
        {
            AdjustFlagsAndWidth(metaCode);
            _metaCode = metaCode;
        }
        _chunkGenerator = chunkGenerator;
    }


    internal RazorMetaCodeSyntax(SyntaxKind kind, GreenNode metaCode, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (metaCode != null)
        {
            AdjustFlagsAndWidth(metaCode);
            _metaCode = metaCode;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> MetaCode { get { return new SyntaxList<SyntaxToken>(_metaCode); } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _metaCode;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.RazorMetaCodeSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorMetaCode(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorMetaCode(this);
    }

    public RazorMetaCodeSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> metaCode, ISpanChunkGenerator chunkGenerator)
    {
        if (metaCode != MetaCode)
        {
            var newNode = SyntaxFactory.RazorMetaCode(metaCode, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new RazorMetaCodeSyntax(Kind, _metaCode, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new RazorMetaCodeSyntax(Kind, _metaCode, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class GenericBlockSyntax : RazorBlockSyntax
  {
    private readonly GreenNode _children;

    internal GenericBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }


    internal GenericBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children { get { return new SyntaxList<RazorSyntaxNode>(_children); } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.GenericBlockSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitGenericBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitGenericBlock(this);
    }

    public GenericBlockSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.GenericBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new GenericBlockSyntax(Kind, _children, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new GenericBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class UnclassifiedTextLiteralSyntax : RazorSyntaxNode
  {
    private readonly GreenNode _literalTokens;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal UnclassifiedTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }


    internal UnclassifiedTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens { get { return new SyntaxList<SyntaxToken>(_literalTokens); } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.UnclassifiedTextLiteralSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitUnclassifiedTextLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitUnclassifiedTextLiteral(this);
    }

    public UnclassifiedTextLiteralSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.UnclassifiedTextLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new UnclassifiedTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new UnclassifiedTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal abstract partial class MarkupSyntaxNode : RazorSyntaxNode
  {
    internal MarkupSyntaxNode(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal MarkupSyntaxNode(SyntaxKind kind)
      : base(kind)
    {
    }
  }

  internal sealed partial class MarkupBlockSyntax : RazorBlockSyntax
  {
    private readonly GreenNode _children;

    internal MarkupBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }


    internal MarkupBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children { get { return new SyntaxList<RazorSyntaxNode>(_children); } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupBlockSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupBlock(this);
    }

    public MarkupBlockSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupBlockSyntax(Kind, _children, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupTransitionSyntax : MarkupSyntaxNode
  {
    private readonly GreenNode _transitionTokens;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupTransitionSyntax(SyntaxKind kind, GreenNode transitionTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (transitionTokens != null)
        {
            AdjustFlagsAndWidth(transitionTokens);
            _transitionTokens = transitionTokens;
        }
        _chunkGenerator = chunkGenerator;
    }


    internal MarkupTransitionSyntax(SyntaxKind kind, GreenNode transitionTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (transitionTokens != null)
        {
            AdjustFlagsAndWidth(transitionTokens);
            _transitionTokens = transitionTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> TransitionTokens { get { return new SyntaxList<SyntaxToken>(_transitionTokens); } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _transitionTokens;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupTransitionSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTransition(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTransition(this);
    }

    public MarkupTransitionSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> transitionTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (transitionTokens != TransitionTokens)
        {
            var newNode = SyntaxFactory.MarkupTransition(transitionTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupTransitionSyntax(Kind, _transitionTokens, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupTransitionSyntax(Kind, _transitionTokens, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupTextLiteralSyntax : MarkupSyntaxNode
  {
    private readonly GreenNode _literalTokens;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }


    internal MarkupTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens { get { return new SyntaxList<SyntaxToken>(_literalTokens); } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupTextLiteralSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTextLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTextLiteral(this);
    }

    public MarkupTextLiteralSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.MarkupTextLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupEphemeralTextLiteralSyntax : MarkupSyntaxNode
  {
    private readonly GreenNode _literalTokens;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupEphemeralTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }


    internal MarkupEphemeralTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens { get { return new SyntaxList<SyntaxToken>(_literalTokens); } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupEphemeralTextLiteralSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupEphemeralTextLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupEphemeralTextLiteral(this);
    }

    public MarkupEphemeralTextLiteralSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.MarkupEphemeralTextLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupEphemeralTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupEphemeralTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupCommentBlockSyntax : RazorBlockSyntax
  {
    private readonly GreenNode _children;

    internal MarkupCommentBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }


    internal MarkupCommentBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children { get { return new SyntaxList<RazorSyntaxNode>(_children); } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupCommentBlockSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupCommentBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupCommentBlock(this);
    }

    public MarkupCommentBlockSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupCommentBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupCommentBlockSyntax(Kind, _children, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupCommentBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupMinimizedAttributeBlockSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTextLiteralSyntax _namePrefix;
    private readonly MarkupTextLiteralSyntax _name;

    internal MarkupMinimizedAttributeBlockSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
    }


    internal MarkupMinimizedAttributeBlockSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
        : base(kind)
    {
        SlotCount = 2;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
    }

    public MarkupTextLiteralSyntax NamePrefix { get { return _namePrefix; } }
    public MarkupTextLiteralSyntax Name { get { return _name; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _name;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupMinimizedAttributeBlockSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupMinimizedAttributeBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupMinimizedAttributeBlock(this);
    }

    public MarkupMinimizedAttributeBlockSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        if (namePrefix != NamePrefix || name != Name)
        {
            var newNode = SyntaxFactory.MarkupMinimizedAttributeBlock(namePrefix, name);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupMinimizedAttributeBlockSyntax(Kind, _namePrefix, _name, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupMinimizedAttributeBlockSyntax(Kind, _namePrefix, _name, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupAttributeBlockSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTextLiteralSyntax _namePrefix;
    private readonly MarkupTextLiteralSyntax _name;
    private readonly MarkupTextLiteralSyntax _nameSuffix;
    private readonly SyntaxToken _equalsToken;
    private readonly MarkupTextLiteralSyntax _valuePrefix;
    private readonly RazorBlockSyntax _value;
    private readonly MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupAttributeBlockSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 7;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        if (value != null)
        {
            AdjustFlagsAndWidth(value);
            _value = value;
        }
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }


    internal MarkupAttributeBlockSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
        : base(kind)
    {
        SlotCount = 7;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        if (value != null)
        {
            AdjustFlagsAndWidth(value);
            _value = value;
        }
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    public MarkupTextLiteralSyntax NamePrefix { get { return _namePrefix; } }
    public MarkupTextLiteralSyntax Name { get { return _name; } }
    public MarkupTextLiteralSyntax NameSuffix { get { return _nameSuffix; } }
    public SyntaxToken EqualsToken { get { return _equalsToken; } }
    public MarkupTextLiteralSyntax ValuePrefix { get { return _valuePrefix; } }
    public RazorBlockSyntax Value { get { return _value; } }
    public MarkupTextLiteralSyntax ValueSuffix { get { return _valueSuffix; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _name;
            case 2: return _nameSuffix;
            case 3: return _equalsToken;
            case 4: return _valuePrefix;
            case 5: return _value;
            case 6: return _valueSuffix;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupAttributeBlockSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupAttributeBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupAttributeBlock(this);
    }

    public MarkupAttributeBlockSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || name != Name || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupAttributeBlock(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupAttributeBlockSyntax(Kind, _namePrefix, _name, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupAttributeBlockSyntax(Kind, _namePrefix, _name, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupMiscAttributeContentSyntax : MarkupSyntaxNode
  {
    private readonly GreenNode _children;

    internal MarkupMiscAttributeContentSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }


    internal MarkupMiscAttributeContentSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public SyntaxList<RazorSyntaxNode> Children { get { return new SyntaxList<RazorSyntaxNode>(_children); } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupMiscAttributeContentSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupMiscAttributeContent(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupMiscAttributeContent(this);
    }

    public MarkupMiscAttributeContentSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupMiscAttributeContent(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupMiscAttributeContentSyntax(Kind, _children, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupMiscAttributeContentSyntax(Kind, _children, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupLiteralAttributeValueSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTextLiteralSyntax _prefix;
    private readonly MarkupTextLiteralSyntax _value;

    internal MarkupLiteralAttributeValueSyntax(SyntaxKind kind, MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        if (prefix != null)
        {
            AdjustFlagsAndWidth(prefix);
            _prefix = prefix;
        }
        if (value != null)
        {
            AdjustFlagsAndWidth(value);
            _value = value;
        }
    }


    internal MarkupLiteralAttributeValueSyntax(SyntaxKind kind, MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
        : base(kind)
    {
        SlotCount = 2;
        if (prefix != null)
        {
            AdjustFlagsAndWidth(prefix);
            _prefix = prefix;
        }
        if (value != null)
        {
            AdjustFlagsAndWidth(value);
            _value = value;
        }
    }

    public MarkupTextLiteralSyntax Prefix { get { return _prefix; } }
    public MarkupTextLiteralSyntax Value { get { return _value; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _prefix;
            case 1: return _value;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupLiteralAttributeValueSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupLiteralAttributeValue(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupLiteralAttributeValue(this);
    }

    public MarkupLiteralAttributeValueSyntax Update(MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
    {
        if (prefix != Prefix || value != Value)
        {
            var newNode = SyntaxFactory.MarkupLiteralAttributeValue(prefix, value);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupLiteralAttributeValueSyntax(Kind, _prefix, _value, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupLiteralAttributeValueSyntax(Kind, _prefix, _value, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupDynamicAttributeValueSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTextLiteralSyntax _prefix;
    private readonly RazorBlockSyntax _value;

    internal MarkupDynamicAttributeValueSyntax(SyntaxKind kind, MarkupTextLiteralSyntax prefix, RazorBlockSyntax value, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        if (prefix != null)
        {
            AdjustFlagsAndWidth(prefix);
            _prefix = prefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
    }


    internal MarkupDynamicAttributeValueSyntax(SyntaxKind kind, MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
        : base(kind)
    {
        SlotCount = 2;
        if (prefix != null)
        {
            AdjustFlagsAndWidth(prefix);
            _prefix = prefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
    }

    public MarkupTextLiteralSyntax Prefix { get { return _prefix; } }
    public RazorBlockSyntax Value { get { return _value; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _prefix;
            case 1: return _value;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupDynamicAttributeValueSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupDynamicAttributeValue(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupDynamicAttributeValue(this);
    }

    public MarkupDynamicAttributeValueSyntax Update(MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
    {
        if (prefix != Prefix || value != Value)
        {
            var newNode = SyntaxFactory.MarkupDynamicAttributeValue(prefix, value);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupDynamicAttributeValueSyntax(Kind, _prefix, _value, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupDynamicAttributeValueSyntax(Kind, _prefix, _value, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupElementSyntax : MarkupSyntaxNode
  {
    private readonly MarkupStartTagSyntax _startTag;
    private readonly GreenNode _body;
    private readonly MarkupEndTagSyntax _endTag;

    internal MarkupElementSyntax(SyntaxKind kind, MarkupStartTagSyntax startTag, GreenNode body, MarkupEndTagSyntax endTag, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 3;
        if (startTag != null)
        {
            AdjustFlagsAndWidth(startTag);
            _startTag = startTag;
        }
        if (body != null)
        {
            AdjustFlagsAndWidth(body);
            _body = body;
        }
        if (endTag != null)
        {
            AdjustFlagsAndWidth(endTag);
            _endTag = endTag;
        }
    }


    internal MarkupElementSyntax(SyntaxKind kind, MarkupStartTagSyntax startTag, GreenNode body, MarkupEndTagSyntax endTag)
        : base(kind)
    {
        SlotCount = 3;
        if (startTag != null)
        {
            AdjustFlagsAndWidth(startTag);
            _startTag = startTag;
        }
        if (body != null)
        {
            AdjustFlagsAndWidth(body);
            _body = body;
        }
        if (endTag != null)
        {
            AdjustFlagsAndWidth(endTag);
            _endTag = endTag;
        }
    }

    public MarkupStartTagSyntax StartTag { get { return _startTag; } }
    public SyntaxList<RazorSyntaxNode> Body { get { return new SyntaxList<RazorSyntaxNode>(_body); } }
    public MarkupEndTagSyntax EndTag { get { return _endTag; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _startTag;
            case 1: return _body;
            case 2: return _endTag;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupElementSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupElement(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupElement(this);
    }

    public MarkupElementSyntax Update(MarkupStartTagSyntax startTag, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> body, MarkupEndTagSyntax endTag)
    {
        if (startTag != StartTag || body != Body || endTag != EndTag)
        {
            var newNode = SyntaxFactory.MarkupElement(startTag, body, endTag);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupElementSyntax(Kind, _startTag, _body, _endTag, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupElementSyntax(Kind, _startTag, _body, _endTag, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupStartTagSyntax : MarkupSyntaxNode
  {
    private readonly SyntaxToken _openAngle;
    private readonly SyntaxToken _bang;
    private readonly SyntaxToken _name;
    private readonly GreenNode _attributes;
    private readonly SyntaxToken _forwardSlash;
    private readonly SyntaxToken _closeAngle;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupStartTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, GreenNode attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (attributes != null)
        {
            AdjustFlagsAndWidth(attributes);
            _attributes = attributes;
        }
        if (forwardSlash != null)
        {
            AdjustFlagsAndWidth(forwardSlash);
            _forwardSlash = forwardSlash;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }


    internal MarkupStartTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, GreenNode attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (attributes != null)
        {
            AdjustFlagsAndWidth(attributes);
            _attributes = attributes;
        }
        if (forwardSlash != null)
        {
            AdjustFlagsAndWidth(forwardSlash);
            _forwardSlash = forwardSlash;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxToken OpenAngle { get { return _openAngle; } }
    public SyntaxToken Bang { get { return _bang; } }
    public SyntaxToken Name { get { return _name; } }
    public SyntaxList<RazorSyntaxNode> Attributes { get { return new SyntaxList<RazorSyntaxNode>(_attributes); } }
    public SyntaxToken ForwardSlash { get { return _forwardSlash; } }
    public SyntaxToken CloseAngle { get { return _closeAngle; } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _openAngle;
            case 1: return _bang;
            case 2: return _name;
            case 3: return _attributes;
            case 4: return _forwardSlash;
            case 5: return _closeAngle;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupStartTagSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupStartTag(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupStartTag(this);
    }

    public MarkupStartTagSyntax Update(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || bang != Bang || name != Name || attributes != Attributes || forwardSlash != ForwardSlash || closeAngle != CloseAngle)
        {
            var newNode = SyntaxFactory.MarkupStartTag(openAngle, bang, name, attributes, forwardSlash, closeAngle, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupStartTagSyntax(Kind, _openAngle, _bang, _name, _attributes, _forwardSlash, _closeAngle, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupStartTagSyntax(Kind, _openAngle, _bang, _name, _attributes, _forwardSlash, _closeAngle, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupEndTagSyntax : MarkupSyntaxNode
  {
    private readonly SyntaxToken _openAngle;
    private readonly SyntaxToken _forwardSlash;
    private readonly SyntaxToken _bang;
    private readonly SyntaxToken _name;
    private readonly MarkupMiscAttributeContentSyntax _miscAttributeContent;
    private readonly SyntaxToken _closeAngle;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupEndTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        AdjustFlagsAndWidth(forwardSlash);
        _forwardSlash = forwardSlash;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (miscAttributeContent != null)
        {
            AdjustFlagsAndWidth(miscAttributeContent);
            _miscAttributeContent = miscAttributeContent;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }


    internal MarkupEndTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        AdjustFlagsAndWidth(forwardSlash);
        _forwardSlash = forwardSlash;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (miscAttributeContent != null)
        {
            AdjustFlagsAndWidth(miscAttributeContent);
            _miscAttributeContent = miscAttributeContent;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxToken OpenAngle { get { return _openAngle; } }
    public SyntaxToken ForwardSlash { get { return _forwardSlash; } }
    public SyntaxToken Bang { get { return _bang; } }
    public SyntaxToken Name { get { return _name; } }
    public MarkupMiscAttributeContentSyntax MiscAttributeContent { get { return _miscAttributeContent; } }
    public SyntaxToken CloseAngle { get { return _closeAngle; } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _openAngle;
            case 1: return _forwardSlash;
            case 2: return _bang;
            case 3: return _name;
            case 4: return _miscAttributeContent;
            case 5: return _closeAngle;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupEndTagSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupEndTag(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupEndTag(this);
    }

    public MarkupEndTagSyntax Update(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || forwardSlash != ForwardSlash || bang != Bang || name != Name || miscAttributeContent != MiscAttributeContent || closeAngle != CloseAngle)
        {
            var newNode = SyntaxFactory.MarkupEndTag(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupEndTagSyntax(Kind, _openAngle, _forwardSlash, _bang, _name, _miscAttributeContent, _closeAngle, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupEndTagSyntax(Kind, _openAngle, _forwardSlash, _bang, _name, _miscAttributeContent, _closeAngle, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupTagHelperElementSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTagHelperStartTagSyntax _startTag;
    private readonly GreenNode _body;
    private readonly MarkupTagHelperEndTagSyntax _endTag;

    internal MarkupTagHelperElementSyntax(SyntaxKind kind, MarkupTagHelperStartTagSyntax startTag, GreenNode body, MarkupTagHelperEndTagSyntax endTag, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(startTag);
        _startTag = startTag;
        if (body != null)
        {
            AdjustFlagsAndWidth(body);
            _body = body;
        }
        if (endTag != null)
        {
            AdjustFlagsAndWidth(endTag);
            _endTag = endTag;
        }
    }


    internal MarkupTagHelperElementSyntax(SyntaxKind kind, MarkupTagHelperStartTagSyntax startTag, GreenNode body, MarkupTagHelperEndTagSyntax endTag)
        : base(kind)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(startTag);
        _startTag = startTag;
        if (body != null)
        {
            AdjustFlagsAndWidth(body);
            _body = body;
        }
        if (endTag != null)
        {
            AdjustFlagsAndWidth(endTag);
            _endTag = endTag;
        }
    }

    public MarkupTagHelperStartTagSyntax StartTag { get { return _startTag; } }
    public SyntaxList<RazorSyntaxNode> Body { get { return new SyntaxList<RazorSyntaxNode>(_body); } }
    public MarkupTagHelperEndTagSyntax EndTag { get { return _endTag; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _startTag;
            case 1: return _body;
            case 2: return _endTag;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupTagHelperElementSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperElement(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperElement(this);
    }

    public MarkupTagHelperElementSyntax Update(MarkupTagHelperStartTagSyntax startTag, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> body, MarkupTagHelperEndTagSyntax endTag)
    {
        if (startTag != StartTag || body != Body || endTag != EndTag)
        {
            var newNode = SyntaxFactory.MarkupTagHelperElement(startTag, body, endTag);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupTagHelperElementSyntax(Kind, _startTag, _body, _endTag, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupTagHelperElementSyntax(Kind, _startTag, _body, _endTag, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupTagHelperStartTagSyntax : MarkupSyntaxNode
  {
    private readonly SyntaxToken _openAngle;
    private readonly SyntaxToken _bang;
    private readonly SyntaxToken _name;
    private readonly GreenNode _attributes;
    private readonly SyntaxToken _forwardSlash;
    private readonly SyntaxToken _closeAngle;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupTagHelperStartTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, GreenNode attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (attributes != null)
        {
            AdjustFlagsAndWidth(attributes);
            _attributes = attributes;
        }
        if (forwardSlash != null)
        {
            AdjustFlagsAndWidth(forwardSlash);
            _forwardSlash = forwardSlash;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }


    internal MarkupTagHelperStartTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, GreenNode attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (attributes != null)
        {
            AdjustFlagsAndWidth(attributes);
            _attributes = attributes;
        }
        if (forwardSlash != null)
        {
            AdjustFlagsAndWidth(forwardSlash);
            _forwardSlash = forwardSlash;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxToken OpenAngle { get { return _openAngle; } }
    public SyntaxToken Bang { get { return _bang; } }
    public SyntaxToken Name { get { return _name; } }
    public SyntaxList<RazorSyntaxNode> Attributes { get { return new SyntaxList<RazorSyntaxNode>(_attributes); } }
    public SyntaxToken ForwardSlash { get { return _forwardSlash; } }
    public SyntaxToken CloseAngle { get { return _closeAngle; } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _openAngle;
            case 1: return _bang;
            case 2: return _name;
            case 3: return _attributes;
            case 4: return _forwardSlash;
            case 5: return _closeAngle;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupTagHelperStartTagSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperStartTag(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperStartTag(this);
    }

    public MarkupTagHelperStartTagSyntax Update(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || bang != Bang || name != Name || attributes != Attributes || forwardSlash != ForwardSlash || closeAngle != CloseAngle)
        {
            var newNode = SyntaxFactory.MarkupTagHelperStartTag(openAngle, bang, name, attributes, forwardSlash, closeAngle, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupTagHelperStartTagSyntax(Kind, _openAngle, _bang, _name, _attributes, _forwardSlash, _closeAngle, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupTagHelperStartTagSyntax(Kind, _openAngle, _bang, _name, _attributes, _forwardSlash, _closeAngle, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupTagHelperEndTagSyntax : MarkupSyntaxNode
  {
    private readonly SyntaxToken _openAngle;
    private readonly SyntaxToken _forwardSlash;
    private readonly SyntaxToken _bang;
    private readonly SyntaxToken _name;
    private readonly MarkupMiscAttributeContentSyntax _miscAttributeContent;
    private readonly SyntaxToken _closeAngle;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal MarkupTagHelperEndTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        AdjustFlagsAndWidth(forwardSlash);
        _forwardSlash = forwardSlash;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (miscAttributeContent != null)
        {
            AdjustFlagsAndWidth(miscAttributeContent);
            _miscAttributeContent = miscAttributeContent;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }


    internal MarkupTagHelperEndTagSyntax(SyntaxKind kind, SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 6;
        AdjustFlagsAndWidth(openAngle);
        _openAngle = openAngle;
        AdjustFlagsAndWidth(forwardSlash);
        _forwardSlash = forwardSlash;
        if (bang != null)
        {
            AdjustFlagsAndWidth(bang);
            _bang = bang;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (miscAttributeContent != null)
        {
            AdjustFlagsAndWidth(miscAttributeContent);
            _miscAttributeContent = miscAttributeContent;
        }
        AdjustFlagsAndWidth(closeAngle);
        _closeAngle = closeAngle;
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxToken OpenAngle { get { return _openAngle; } }
    public SyntaxToken ForwardSlash { get { return _forwardSlash; } }
    public SyntaxToken Bang { get { return _bang; } }
    public SyntaxToken Name { get { return _name; } }
    public MarkupMiscAttributeContentSyntax MiscAttributeContent { get { return _miscAttributeContent; } }
    public SyntaxToken CloseAngle { get { return _closeAngle; } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _openAngle;
            case 1: return _forwardSlash;
            case 2: return _bang;
            case 3: return _name;
            case 4: return _miscAttributeContent;
            case 5: return _closeAngle;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupTagHelperEndTagSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperEndTag(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperEndTag(this);
    }

    public MarkupTagHelperEndTagSyntax Update(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
        if (openAngle != OpenAngle || forwardSlash != ForwardSlash || bang != Bang || name != Name || miscAttributeContent != MiscAttributeContent || closeAngle != CloseAngle)
        {
            var newNode = SyntaxFactory.MarkupTagHelperEndTag(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupTagHelperEndTagSyntax(Kind, _openAngle, _forwardSlash, _bang, _name, _miscAttributeContent, _closeAngle, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupTagHelperEndTagSyntax(Kind, _openAngle, _forwardSlash, _bang, _name, _miscAttributeContent, _closeAngle, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupTagHelperAttributeSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTextLiteralSyntax _namePrefix;
    private readonly MarkupTextLiteralSyntax _name;
    private readonly MarkupTextLiteralSyntax _nameSuffix;
    private readonly SyntaxToken _equalsToken;
    private readonly MarkupTextLiteralSyntax _valuePrefix;
    private readonly MarkupTagHelperAttributeValueSyntax _value;
    private readonly MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupTagHelperAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 7;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }


    internal MarkupTagHelperAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
        : base(kind)
    {
        SlotCount = 7;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    public MarkupTextLiteralSyntax NamePrefix { get { return _namePrefix; } }
    public MarkupTextLiteralSyntax Name { get { return _name; } }
    public MarkupTextLiteralSyntax NameSuffix { get { return _nameSuffix; } }
    public SyntaxToken EqualsToken { get { return _equalsToken; } }
    public MarkupTextLiteralSyntax ValuePrefix { get { return _valuePrefix; } }
    public MarkupTagHelperAttributeValueSyntax Value { get { return _value; } }
    public MarkupTextLiteralSyntax ValueSuffix { get { return _valueSuffix; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _name;
            case 2: return _nameSuffix;
            case 3: return _equalsToken;
            case 4: return _valuePrefix;
            case 5: return _value;
            case 6: return _valueSuffix;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupTagHelperAttributeSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperAttribute(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperAttribute(this);
    }

    public MarkupTagHelperAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || name != Name || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupTagHelperAttribute(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupTagHelperAttributeSyntax(Kind, _namePrefix, _name, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupTagHelperAttributeSyntax(Kind, _namePrefix, _name, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupMinimizedTagHelperAttributeSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTextLiteralSyntax _namePrefix;
    private readonly MarkupTextLiteralSyntax _name;

    internal MarkupMinimizedTagHelperAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
    }


    internal MarkupMinimizedTagHelperAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
        : base(kind)
    {
        SlotCount = 2;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(name);
        _name = name;
    }

    public MarkupTextLiteralSyntax NamePrefix { get { return _namePrefix; } }
    public MarkupTextLiteralSyntax Name { get { return _name; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _name;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupMinimizedTagHelperAttributeSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupMinimizedTagHelperAttribute(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupMinimizedTagHelperAttribute(this);
    }

    public MarkupMinimizedTagHelperAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
        if (namePrefix != NamePrefix || name != Name)
        {
            var newNode = SyntaxFactory.MarkupMinimizedTagHelperAttribute(namePrefix, name);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupMinimizedTagHelperAttributeSyntax(Kind, _namePrefix, _name, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupMinimizedTagHelperAttributeSyntax(Kind, _namePrefix, _name, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupTagHelperAttributeValueSyntax : RazorBlockSyntax
  {
    private readonly GreenNode _children;

    internal MarkupTagHelperAttributeValueSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }


    internal MarkupTagHelperAttributeValueSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children { get { return new SyntaxList<RazorSyntaxNode>(_children); } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupTagHelperAttributeValueSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperAttributeValue(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperAttributeValue(this);
    }

    public MarkupTagHelperAttributeValueSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.MarkupTagHelperAttributeValue(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupTagHelperAttributeValueSyntax(Kind, _children, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupTagHelperAttributeValueSyntax(Kind, _children, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupTagHelperDirectiveAttributeSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTextLiteralSyntax _namePrefix;
    private readonly RazorMetaCodeSyntax _transition;
    private readonly MarkupTextLiteralSyntax _name;
    private readonly RazorMetaCodeSyntax _colon;
    private readonly MarkupTextLiteralSyntax _parameterName;
    private readonly MarkupTextLiteralSyntax _nameSuffix;
    private readonly SyntaxToken _equalsToken;
    private readonly MarkupTextLiteralSyntax _valuePrefix;
    private readonly MarkupTagHelperAttributeValueSyntax _value;
    private readonly MarkupTextLiteralSyntax _valueSuffix;

    internal MarkupTagHelperDirectiveAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 10;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(name);
        _name = name;
        if (colon != null)
        {
            AdjustFlagsAndWidth(colon);
            _colon = colon;
        }
        if (parameterName != null)
        {
            AdjustFlagsAndWidth(parameterName);
            _parameterName = parameterName;
        }
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }


    internal MarkupTagHelperDirectiveAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
        : base(kind)
    {
        SlotCount = 10;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(name);
        _name = name;
        if (colon != null)
        {
            AdjustFlagsAndWidth(colon);
            _colon = colon;
        }
        if (parameterName != null)
        {
            AdjustFlagsAndWidth(parameterName);
            _parameterName = parameterName;
        }
        if (nameSuffix != null)
        {
            AdjustFlagsAndWidth(nameSuffix);
            _nameSuffix = nameSuffix;
        }
        AdjustFlagsAndWidth(equalsToken);
        _equalsToken = equalsToken;
        if (valuePrefix != null)
        {
            AdjustFlagsAndWidth(valuePrefix);
            _valuePrefix = valuePrefix;
        }
        AdjustFlagsAndWidth(value);
        _value = value;
        if (valueSuffix != null)
        {
            AdjustFlagsAndWidth(valueSuffix);
            _valueSuffix = valueSuffix;
        }
    }

    public MarkupTextLiteralSyntax NamePrefix { get { return _namePrefix; } }
    public RazorMetaCodeSyntax Transition { get { return _transition; } }
    public MarkupTextLiteralSyntax Name { get { return _name; } }
    public RazorMetaCodeSyntax Colon { get { return _colon; } }
    public MarkupTextLiteralSyntax ParameterName { get { return _parameterName; } }
    public MarkupTextLiteralSyntax NameSuffix { get { return _nameSuffix; } }
    public SyntaxToken EqualsToken { get { return _equalsToken; } }
    public MarkupTextLiteralSyntax ValuePrefix { get { return _valuePrefix; } }
    public MarkupTagHelperAttributeValueSyntax Value { get { return _value; } }
    public MarkupTextLiteralSyntax ValueSuffix { get { return _valueSuffix; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _transition;
            case 2: return _name;
            case 3: return _colon;
            case 4: return _parameterName;
            case 5: return _nameSuffix;
            case 6: return _equalsToken;
            case 7: return _valuePrefix;
            case 8: return _value;
            case 9: return _valueSuffix;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupTagHelperDirectiveAttributeSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupTagHelperDirectiveAttribute(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupTagHelperDirectiveAttribute(this);
    }

    public MarkupTagHelperDirectiveAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
        if (namePrefix != NamePrefix || transition != Transition || name != Name || colon != Colon || parameterName != ParameterName || nameSuffix != NameSuffix || equalsToken != EqualsToken || valuePrefix != ValuePrefix || value != Value || valueSuffix != ValueSuffix)
        {
            var newNode = SyntaxFactory.MarkupTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupTagHelperDirectiveAttributeSyntax(Kind, _namePrefix, _transition, _name, _colon, _parameterName, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupTagHelperDirectiveAttributeSyntax(Kind, _namePrefix, _transition, _name, _colon, _parameterName, _nameSuffix, _equalsToken, _valuePrefix, _value, _valueSuffix, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class MarkupMinimizedTagHelperDirectiveAttributeSyntax : MarkupSyntaxNode
  {
    private readonly MarkupTextLiteralSyntax _namePrefix;
    private readonly RazorMetaCodeSyntax _transition;
    private readonly MarkupTextLiteralSyntax _name;
    private readonly RazorMetaCodeSyntax _colon;
    private readonly MarkupTextLiteralSyntax _parameterName;

    internal MarkupMinimizedTagHelperDirectiveAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 5;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(name);
        _name = name;
        if (colon != null)
        {
            AdjustFlagsAndWidth(colon);
            _colon = colon;
        }
        if (parameterName != null)
        {
            AdjustFlagsAndWidth(parameterName);
            _parameterName = parameterName;
        }
    }


    internal MarkupMinimizedTagHelperDirectiveAttributeSyntax(SyntaxKind kind, MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
        : base(kind)
    {
        SlotCount = 5;
        if (namePrefix != null)
        {
            AdjustFlagsAndWidth(namePrefix);
            _namePrefix = namePrefix;
        }
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(name);
        _name = name;
        if (colon != null)
        {
            AdjustFlagsAndWidth(colon);
            _colon = colon;
        }
        if (parameterName != null)
        {
            AdjustFlagsAndWidth(parameterName);
            _parameterName = parameterName;
        }
    }

    public MarkupTextLiteralSyntax NamePrefix { get { return _namePrefix; } }
    public RazorMetaCodeSyntax Transition { get { return _transition; } }
    public MarkupTextLiteralSyntax Name { get { return _name; } }
    public RazorMetaCodeSyntax Colon { get { return _colon; } }
    public MarkupTextLiteralSyntax ParameterName { get { return _parameterName; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _namePrefix;
            case 1: return _transition;
            case 2: return _name;
            case 3: return _colon;
            case 4: return _parameterName;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.MarkupMinimizedTagHelperDirectiveAttributeSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitMarkupMinimizedTagHelperDirectiveAttribute(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitMarkupMinimizedTagHelperDirectiveAttribute(this);
    }

    public MarkupMinimizedTagHelperDirectiveAttributeSyntax Update(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
    {
        if (namePrefix != NamePrefix || transition != Transition || name != Name || colon != Colon || parameterName != ParameterName)
        {
            var newNode = SyntaxFactory.MarkupMinimizedTagHelperDirectiveAttribute(namePrefix, transition, name, colon, parameterName);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new MarkupMinimizedTagHelperDirectiveAttributeSyntax(Kind, _namePrefix, _transition, _name, _colon, _parameterName, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new MarkupMinimizedTagHelperDirectiveAttributeSyntax(Kind, _namePrefix, _transition, _name, _colon, _parameterName, GetDiagnostics(), annotations);
    }
  }

  internal abstract partial class CSharpSyntaxNode : RazorSyntaxNode
  {
    internal CSharpSyntaxNode(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal CSharpSyntaxNode(SyntaxKind kind)
      : base(kind)
    {
    }
  }

  internal sealed partial class CSharpCodeBlockSyntax : RazorBlockSyntax
  {
    private readonly GreenNode _children;

    internal CSharpCodeBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }


    internal CSharpCodeBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children { get { return new SyntaxList<RazorSyntaxNode>(_children); } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpCodeBlockSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpCodeBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpCodeBlock(this);
    }

    public CSharpCodeBlockSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.CSharpCodeBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpCodeBlockSyntax(Kind, _children, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpCodeBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpTransitionSyntax : CSharpSyntaxNode
  {
    private readonly SyntaxToken _transition;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal CSharpTransitionSyntax(SyntaxKind kind, SyntaxToken transition, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        _chunkGenerator = chunkGenerator;
    }


    internal CSharpTransitionSyntax(SyntaxKind kind, SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxToken Transition { get { return _transition; } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpTransitionSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpTransition(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpTransition(this);
    }

    public CSharpTransitionSyntax Update(SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
    {
        if (transition != Transition)
        {
            var newNode = SyntaxFactory.CSharpTransition(transition, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpTransitionSyntax(Kind, _transition, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpTransitionSyntax(Kind, _transition, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpStatementLiteralSyntax : CSharpSyntaxNode
  {
    private readonly GreenNode _literalTokens;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal CSharpStatementLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }


    internal CSharpStatementLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens { get { return new SyntaxList<SyntaxToken>(_literalTokens); } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpStatementLiteralSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpStatementLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpStatementLiteral(this);
    }

    public CSharpStatementLiteralSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.CSharpStatementLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpStatementLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpStatementLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpExpressionLiteralSyntax : CSharpSyntaxNode
  {
    private readonly GreenNode _literalTokens;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal CSharpExpressionLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }


    internal CSharpExpressionLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens { get { return new SyntaxList<SyntaxToken>(_literalTokens); } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpExpressionLiteralSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpExpressionLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpExpressionLiteral(this);
    }

    public CSharpExpressionLiteralSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.CSharpExpressionLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpExpressionLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpExpressionLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpEphemeralTextLiteralSyntax : CSharpSyntaxNode
  {
    private readonly GreenNode _literalTokens;
    private readonly ISpanChunkGenerator _chunkGenerator;

    internal CSharpEphemeralTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }


    internal CSharpEphemeralTextLiteralSyntax(SyntaxKind kind, GreenNode literalTokens, ISpanChunkGenerator chunkGenerator)
        : base(kind)
    {
        SlotCount = 1;
        if (literalTokens != null)
        {
            AdjustFlagsAndWidth(literalTokens);
            _literalTokens = literalTokens;
        }
        _chunkGenerator = chunkGenerator;
    }

    public SyntaxList<SyntaxToken> LiteralTokens { get { return new SyntaxList<SyntaxToken>(_literalTokens); } }
    public ISpanChunkGenerator ChunkGenerator { get { return _chunkGenerator; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _literalTokens;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpEphemeralTextLiteralSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpEphemeralTextLiteral(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpEphemeralTextLiteral(this);
    }

    public CSharpEphemeralTextLiteralSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {
        if (literalTokens != LiteralTokens)
        {
            var newNode = SyntaxFactory.CSharpEphemeralTextLiteral(literalTokens, chunkGenerator);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpEphemeralTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpEphemeralTextLiteralSyntax(Kind, _literalTokens, _chunkGenerator, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpTemplateBlockSyntax : RazorBlockSyntax
  {
    private readonly GreenNode _children;

    internal CSharpTemplateBlockSyntax(SyntaxKind kind, GreenNode children, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }


    internal CSharpTemplateBlockSyntax(SyntaxKind kind, GreenNode children)
        : base(kind)
    {
        SlotCount = 1;
        if (children != null)
        {
            AdjustFlagsAndWidth(children);
            _children = children;
        }
    }

    public override SyntaxList<RazorSyntaxNode> Children { get { return new SyntaxList<RazorSyntaxNode>(_children); } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _children;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpTemplateBlockSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpTemplateBlock(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpTemplateBlock(this);
    }

    public CSharpTemplateBlockSyntax Update(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {
        if (children != Children)
        {
            var newNode = SyntaxFactory.CSharpTemplateBlock(children);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpTemplateBlockSyntax(Kind, _children, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpTemplateBlockSyntax(Kind, _children, GetDiagnostics(), annotations);
    }
  }

  internal abstract partial class CSharpRazorBlockSyntax : CSharpSyntaxNode
  {
    internal CSharpRazorBlockSyntax(SyntaxKind kind, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
      : base(kind, diagnostics, annotations)
    {
    }
    internal CSharpRazorBlockSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract CSharpTransitionSyntax Transition { get; }

    public abstract CSharpSyntaxNode Body { get; }
  }

  internal sealed partial class CSharpStatementSyntax : CSharpRazorBlockSyntax
  {
    private readonly CSharpTransitionSyntax _transition;
    private readonly CSharpSyntaxNode _body;

    internal CSharpStatementSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }


    internal CSharpStatementSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    public override CSharpTransitionSyntax Transition { get { return _transition; } }
    public override CSharpSyntaxNode Body { get { return _body; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            case 1: return _body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpStatementSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpStatement(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpStatement(this);
    }

    public CSharpStatementSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpStatement(transition, body);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpStatementSyntax(Kind, _transition, _body, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpStatementSyntax(Kind, _transition, _body, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpStatementBodySyntax : CSharpSyntaxNode
  {
    private readonly RazorMetaCodeSyntax _openBrace;
    private readonly CSharpCodeBlockSyntax _cSharpCode;
    private readonly RazorMetaCodeSyntax _closeBrace;

    internal CSharpStatementBodySyntax(SyntaxKind kind, RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeBrace, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(openBrace);
        _openBrace = openBrace;
        AdjustFlagsAndWidth(cSharpCode);
        _cSharpCode = cSharpCode;
        AdjustFlagsAndWidth(closeBrace);
        _closeBrace = closeBrace;
    }


    internal CSharpStatementBodySyntax(SyntaxKind kind, RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeBrace)
        : base(kind)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(openBrace);
        _openBrace = openBrace;
        AdjustFlagsAndWidth(cSharpCode);
        _cSharpCode = cSharpCode;
        AdjustFlagsAndWidth(closeBrace);
        _closeBrace = closeBrace;
    }

    public RazorMetaCodeSyntax OpenBrace { get { return _openBrace; } }
    public CSharpCodeBlockSyntax CSharpCode { get { return _cSharpCode; } }
    public RazorMetaCodeSyntax CloseBrace { get { return _closeBrace; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _openBrace;
            case 1: return _cSharpCode;
            case 2: return _closeBrace;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpStatementBodySyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpStatementBody(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpStatementBody(this);
    }

    public CSharpStatementBodySyntax Update(RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeBrace)
    {
        if (openBrace != OpenBrace || cSharpCode != CSharpCode || closeBrace != CloseBrace)
        {
            var newNode = SyntaxFactory.CSharpStatementBody(openBrace, cSharpCode, closeBrace);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpStatementBodySyntax(Kind, _openBrace, _cSharpCode, _closeBrace, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpStatementBodySyntax(Kind, _openBrace, _cSharpCode, _closeBrace, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpExplicitExpressionSyntax : CSharpRazorBlockSyntax
  {
    private readonly CSharpTransitionSyntax _transition;
    private readonly CSharpSyntaxNode _body;

    internal CSharpExplicitExpressionSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }


    internal CSharpExplicitExpressionSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    public override CSharpTransitionSyntax Transition { get { return _transition; } }
    public override CSharpSyntaxNode Body { get { return _body; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            case 1: return _body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpExplicitExpressionSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpExplicitExpression(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpExplicitExpression(this);
    }

    public CSharpExplicitExpressionSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpExplicitExpression(transition, body);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpExplicitExpressionSyntax(Kind, _transition, _body, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpExplicitExpressionSyntax(Kind, _transition, _body, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpExplicitExpressionBodySyntax : CSharpSyntaxNode
  {
    private readonly RazorMetaCodeSyntax _openParen;
    private readonly CSharpCodeBlockSyntax _cSharpCode;
    private readonly RazorMetaCodeSyntax _closeParen;

    internal CSharpExplicitExpressionBodySyntax(SyntaxKind kind, RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeParen, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(openParen);
        _openParen = openParen;
        AdjustFlagsAndWidth(cSharpCode);
        _cSharpCode = cSharpCode;
        AdjustFlagsAndWidth(closeParen);
        _closeParen = closeParen;
    }


    internal CSharpExplicitExpressionBodySyntax(SyntaxKind kind, RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeParen)
        : base(kind)
    {
        SlotCount = 3;
        AdjustFlagsAndWidth(openParen);
        _openParen = openParen;
        AdjustFlagsAndWidth(cSharpCode);
        _cSharpCode = cSharpCode;
        AdjustFlagsAndWidth(closeParen);
        _closeParen = closeParen;
    }

    public RazorMetaCodeSyntax OpenParen { get { return _openParen; } }
    public CSharpCodeBlockSyntax CSharpCode { get { return _cSharpCode; } }
    public RazorMetaCodeSyntax CloseParen { get { return _closeParen; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _openParen;
            case 1: return _cSharpCode;
            case 2: return _closeParen;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpExplicitExpressionBodySyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpExplicitExpressionBody(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpExplicitExpressionBody(this);
    }

    public CSharpExplicitExpressionBodySyntax Update(RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeParen)
    {
        if (openParen != OpenParen || cSharpCode != CSharpCode || closeParen != CloseParen)
        {
            var newNode = SyntaxFactory.CSharpExplicitExpressionBody(openParen, cSharpCode, closeParen);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpExplicitExpressionBodySyntax(Kind, _openParen, _cSharpCode, _closeParen, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpExplicitExpressionBodySyntax(Kind, _openParen, _cSharpCode, _closeParen, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpImplicitExpressionSyntax : CSharpRazorBlockSyntax
  {
    private readonly CSharpTransitionSyntax _transition;
    private readonly CSharpSyntaxNode _body;

    internal CSharpImplicitExpressionSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }


    internal CSharpImplicitExpressionSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    public override CSharpTransitionSyntax Transition { get { return _transition; } }
    public override CSharpSyntaxNode Body { get { return _body; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            case 1: return _body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpImplicitExpressionSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpImplicitExpression(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpImplicitExpression(this);
    }

    public CSharpImplicitExpressionSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.CSharpImplicitExpression(transition, body);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpImplicitExpressionSyntax(Kind, _transition, _body, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpImplicitExpressionSyntax(Kind, _transition, _body, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class CSharpImplicitExpressionBodySyntax : CSharpSyntaxNode
  {
    private readonly CSharpCodeBlockSyntax _cSharpCode;

    internal CSharpImplicitExpressionBodySyntax(SyntaxKind kind, CSharpCodeBlockSyntax cSharpCode, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 1;
        AdjustFlagsAndWidth(cSharpCode);
        _cSharpCode = cSharpCode;
    }


    internal CSharpImplicitExpressionBodySyntax(SyntaxKind kind, CSharpCodeBlockSyntax cSharpCode)
        : base(kind)
    {
        SlotCount = 1;
        AdjustFlagsAndWidth(cSharpCode);
        _cSharpCode = cSharpCode;
    }

    public CSharpCodeBlockSyntax CSharpCode { get { return _cSharpCode; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _cSharpCode;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.CSharpImplicitExpressionBodySyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitCSharpImplicitExpressionBody(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitCSharpImplicitExpressionBody(this);
    }

    public CSharpImplicitExpressionBodySyntax Update(CSharpCodeBlockSyntax cSharpCode)
    {
        if (cSharpCode != CSharpCode)
        {
            var newNode = SyntaxFactory.CSharpImplicitExpressionBody(cSharpCode);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new CSharpImplicitExpressionBodySyntax(Kind, _cSharpCode, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new CSharpImplicitExpressionBodySyntax(Kind, _cSharpCode, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class RazorDirectiveSyntax : CSharpRazorBlockSyntax
  {
    private readonly CSharpTransitionSyntax _transition;
    private readonly CSharpSyntaxNode _body;

    internal RazorDirectiveSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }


    internal RazorDirectiveSyntax(SyntaxKind kind, CSharpTransitionSyntax transition, CSharpSyntaxNode body)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(transition);
        _transition = transition;
        AdjustFlagsAndWidth(body);
        _body = body;
    }

    public override CSharpTransitionSyntax Transition { get { return _transition; } }
    public override CSharpSyntaxNode Body { get { return _body; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _transition;
            case 1: return _body;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.RazorDirectiveSyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorDirective(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorDirective(this);
    }

    public RazorDirectiveSyntax Update(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
        if (transition != Transition || body != Body)
        {
            var newNode = SyntaxFactory.RazorDirective(transition, body);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new RazorDirectiveSyntax(Kind, _transition, _body, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new RazorDirectiveSyntax(Kind, _transition, _body, GetDiagnostics(), annotations);
    }
  }

  internal sealed partial class RazorDirectiveBodySyntax : CSharpSyntaxNode
  {
    private readonly RazorSyntaxNode _keyword;
    private readonly CSharpCodeBlockSyntax _cSharpCode;

    internal RazorDirectiveBodySyntax(SyntaxKind kind, RazorSyntaxNode keyword, CSharpCodeBlockSyntax cSharpCode, RazorDiagnostic[] diagnostics, SyntaxAnnotation[] annotations)
        : base(kind, diagnostics, annotations)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(keyword);
        _keyword = keyword;
        if (cSharpCode != null)
        {
            AdjustFlagsAndWidth(cSharpCode);
            _cSharpCode = cSharpCode;
        }
    }


    internal RazorDirectiveBodySyntax(SyntaxKind kind, RazorSyntaxNode keyword, CSharpCodeBlockSyntax cSharpCode)
        : base(kind)
    {
        SlotCount = 2;
        AdjustFlagsAndWidth(keyword);
        _keyword = keyword;
        if (cSharpCode != null)
        {
            AdjustFlagsAndWidth(cSharpCode);
            _cSharpCode = cSharpCode;
        }
    }

    public RazorSyntaxNode Keyword { get { return _keyword; } }
    public CSharpCodeBlockSyntax CSharpCode { get { return _cSharpCode; } }

    internal override GreenNode GetSlot(int index)
    {
        switch (index)
        {
            case 0: return _keyword;
            case 1: return _cSharpCode;
            default: return null;
        }
    }

    internal override SyntaxNode CreateRed(SyntaxNode parent, int position)
    {
      return new Syntax.RazorDirectiveBodySyntax(this, parent, position);
    }

    public override TResult Accept<TResult>(SyntaxVisitor<TResult> visitor)
    {
        return visitor.VisitRazorDirectiveBody(this);
    }

    public override void Accept(SyntaxVisitor visitor)
    {
        visitor.VisitRazorDirectiveBody(this);
    }

    public RazorDirectiveBodySyntax Update(RazorSyntaxNode keyword, CSharpCodeBlockSyntax cSharpCode)
    {
        if (keyword != Keyword || cSharpCode != CSharpCode)
        {
            var newNode = SyntaxFactory.RazorDirectiveBody(keyword, cSharpCode);
            var diags = GetDiagnostics();
            if (diags != null && diags.Length > 0)
               newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations != null && annotations.Length > 0)
               newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(RazorDiagnostic[] diagnostics)
    {
         return new RazorDirectiveBodySyntax(Kind, _keyword, _cSharpCode, diagnostics, GetAnnotations());
    }

    internal override GreenNode SetAnnotations(SyntaxAnnotation[] annotations)
    {
         return new RazorDirectiveBodySyntax(Kind, _keyword, _cSharpCode, GetDiagnostics(), annotations);
    }
  }

  internal partial class SyntaxVisitor<TResult>
  {
    public virtual TResult VisitRazorDocument(RazorDocumentSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitRazorCommentBlock(RazorCommentBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitRazorMetaCode(RazorMetaCodeSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitGenericBlock(GenericBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupBlock(MarkupBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupTransition(MarkupTransitionSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupTextLiteral(MarkupTextLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupCommentBlock(MarkupCommentBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupElement(MarkupElementSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupStartTag(MarkupStartTagSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupEndTag(MarkupEndTagSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpCodeBlock(CSharpCodeBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpTransition(CSharpTransitionSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpStatement(CSharpStatementSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpStatementBody(CSharpStatementBodySyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitRazorDirective(RazorDirectiveSyntax node)
    {
      return DefaultVisit(node);
    }

    public virtual TResult VisitRazorDirectiveBody(RazorDirectiveBodySyntax node)
    {
      return DefaultVisit(node);
    }
  }


  internal partial class SyntaxVisitor
  {
    public virtual void VisitRazorDocument(RazorDocumentSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitRazorCommentBlock(RazorCommentBlockSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitRazorMetaCode(RazorMetaCodeSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitGenericBlock(GenericBlockSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupBlock(MarkupBlockSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupTransition(MarkupTransitionSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupTextLiteral(MarkupTextLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupCommentBlock(MarkupCommentBlockSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupElement(MarkupElementSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupStartTag(MarkupStartTagSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupEndTag(MarkupEndTagSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpCodeBlock(CSharpCodeBlockSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpTransition(CSharpTransitionSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpStatement(CSharpStatementSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpStatementBody(CSharpStatementBodySyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitRazorDirective(RazorDirectiveSyntax node)
    {
      DefaultVisit(node);
    }

    public virtual void VisitRazorDirectiveBody(RazorDirectiveBodySyntax node)
    {
      DefaultVisit(node);
    }
  }

  internal partial class SyntaxRewriter : SyntaxVisitor<GreenNode>
  {
    public override GreenNode VisitRazorDocument(RazorDocumentSyntax node)
    {
      var document = (RazorBlockSyntax)Visit(node.Document);
      var endOfFile = (SyntaxToken)Visit(node.EndOfFile);
      return node.Update(document, endOfFile);
    }

    public override GreenNode VisitRazorCommentBlock(RazorCommentBlockSyntax node)
    {
      var startCommentTransition = (SyntaxToken)Visit(node.StartCommentTransition);
      var startCommentStar = (SyntaxToken)Visit(node.StartCommentStar);
      var comment = (SyntaxToken)Visit(node.Comment);
      var endCommentStar = (SyntaxToken)Visit(node.EndCommentStar);
      var endCommentTransition = (SyntaxToken)Visit(node.EndCommentTransition);
      return node.Update(startCommentTransition, startCommentStar, comment, endCommentStar, endCommentTransition);
    }

    public override GreenNode VisitRazorMetaCode(RazorMetaCodeSyntax node)
    {
      var metaCode = VisitList(node.MetaCode);
      return node.Update(metaCode, node.ChunkGenerator);
    }

    public override GreenNode VisitGenericBlock(GenericBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override GreenNode VisitUnclassifiedTextLiteral(UnclassifiedTextLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens, node.ChunkGenerator);
    }

    public override GreenNode VisitMarkupBlock(MarkupBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override GreenNode VisitMarkupTransition(MarkupTransitionSyntax node)
    {
      var transitionTokens = VisitList(node.TransitionTokens);
      return node.Update(transitionTokens, node.ChunkGenerator);
    }

    public override GreenNode VisitMarkupTextLiteral(MarkupTextLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens, node.ChunkGenerator);
    }

    public override GreenNode VisitMarkupEphemeralTextLiteral(MarkupEphemeralTextLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens, node.ChunkGenerator);
    }

    public override GreenNode VisitMarkupCommentBlock(MarkupCommentBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override GreenNode VisitMarkupMinimizedAttributeBlock(MarkupMinimizedAttributeBlockSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      return node.Update(namePrefix, name);
    }

    public override GreenNode VisitMarkupAttributeBlock(MarkupAttributeBlockSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      var nameSuffix = (MarkupTextLiteralSyntax)Visit(node.NameSuffix);
      var equalsToken = (SyntaxToken)Visit(node.EqualsToken);
      var valuePrefix = (MarkupTextLiteralSyntax)Visit(node.ValuePrefix);
      var value = (RazorBlockSyntax)Visit(node.Value);
      var valueSuffix = (MarkupTextLiteralSyntax)Visit(node.ValueSuffix);
      return node.Update(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public override GreenNode VisitMarkupMiscAttributeContent(MarkupMiscAttributeContentSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override GreenNode VisitMarkupLiteralAttributeValue(MarkupLiteralAttributeValueSyntax node)
    {
      var prefix = (MarkupTextLiteralSyntax)Visit(node.Prefix);
      var value = (MarkupTextLiteralSyntax)Visit(node.Value);
      return node.Update(prefix, value);
    }

    public override GreenNode VisitMarkupDynamicAttributeValue(MarkupDynamicAttributeValueSyntax node)
    {
      var prefix = (MarkupTextLiteralSyntax)Visit(node.Prefix);
      var value = (RazorBlockSyntax)Visit(node.Value);
      return node.Update(prefix, value);
    }

    public override GreenNode VisitMarkupElement(MarkupElementSyntax node)
    {
      var startTag = (MarkupStartTagSyntax)Visit(node.StartTag);
      var body = VisitList(node.Body);
      var endTag = (MarkupEndTagSyntax)Visit(node.EndTag);
      return node.Update(startTag, body, endTag);
    }

    public override GreenNode VisitMarkupStartTag(MarkupStartTagSyntax node)
    {
      var openAngle = (SyntaxToken)Visit(node.OpenAngle);
      var bang = (SyntaxToken)Visit(node.Bang);
      var name = (SyntaxToken)Visit(node.Name);
      var attributes = VisitList(node.Attributes);
      var forwardSlash = (SyntaxToken)Visit(node.ForwardSlash);
      var closeAngle = (SyntaxToken)Visit(node.CloseAngle);
      return node.Update(openAngle, bang, name, attributes, forwardSlash, closeAngle, node.ChunkGenerator);
    }

    public override GreenNode VisitMarkupEndTag(MarkupEndTagSyntax node)
    {
      var openAngle = (SyntaxToken)Visit(node.OpenAngle);
      var forwardSlash = (SyntaxToken)Visit(node.ForwardSlash);
      var bang = (SyntaxToken)Visit(node.Bang);
      var name = (SyntaxToken)Visit(node.Name);
      var miscAttributeContent = (MarkupMiscAttributeContentSyntax)Visit(node.MiscAttributeContent);
      var closeAngle = (SyntaxToken)Visit(node.CloseAngle);
      return node.Update(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, node.ChunkGenerator);
    }

    public override GreenNode VisitMarkupTagHelperElement(MarkupTagHelperElementSyntax node)
    {
      var startTag = (MarkupTagHelperStartTagSyntax)Visit(node.StartTag);
      var body = VisitList(node.Body);
      var endTag = (MarkupTagHelperEndTagSyntax)Visit(node.EndTag);
      return node.Update(startTag, body, endTag);
    }

    public override GreenNode VisitMarkupTagHelperStartTag(MarkupTagHelperStartTagSyntax node)
    {
      var openAngle = (SyntaxToken)Visit(node.OpenAngle);
      var bang = (SyntaxToken)Visit(node.Bang);
      var name = (SyntaxToken)Visit(node.Name);
      var attributes = VisitList(node.Attributes);
      var forwardSlash = (SyntaxToken)Visit(node.ForwardSlash);
      var closeAngle = (SyntaxToken)Visit(node.CloseAngle);
      return node.Update(openAngle, bang, name, attributes, forwardSlash, closeAngle, node.ChunkGenerator);
    }

    public override GreenNode VisitMarkupTagHelperEndTag(MarkupTagHelperEndTagSyntax node)
    {
      var openAngle = (SyntaxToken)Visit(node.OpenAngle);
      var forwardSlash = (SyntaxToken)Visit(node.ForwardSlash);
      var bang = (SyntaxToken)Visit(node.Bang);
      var name = (SyntaxToken)Visit(node.Name);
      var miscAttributeContent = (MarkupMiscAttributeContentSyntax)Visit(node.MiscAttributeContent);
      var closeAngle = (SyntaxToken)Visit(node.CloseAngle);
      return node.Update(openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, node.ChunkGenerator);
    }

    public override GreenNode VisitMarkupTagHelperAttribute(MarkupTagHelperAttributeSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      var nameSuffix = (MarkupTextLiteralSyntax)Visit(node.NameSuffix);
      var equalsToken = (SyntaxToken)Visit(node.EqualsToken);
      var valuePrefix = (MarkupTextLiteralSyntax)Visit(node.ValuePrefix);
      var value = (MarkupTagHelperAttributeValueSyntax)Visit(node.Value);
      var valueSuffix = (MarkupTextLiteralSyntax)Visit(node.ValueSuffix);
      return node.Update(namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public override GreenNode VisitMarkupMinimizedTagHelperAttribute(MarkupMinimizedTagHelperAttributeSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      return node.Update(namePrefix, name);
    }

    public override GreenNode VisitMarkupTagHelperAttributeValue(MarkupTagHelperAttributeValueSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override GreenNode VisitMarkupTagHelperDirectiveAttribute(MarkupTagHelperDirectiveAttributeSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var transition = (RazorMetaCodeSyntax)Visit(node.Transition);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      var colon = (RazorMetaCodeSyntax)Visit(node.Colon);
      var parameterName = (MarkupTextLiteralSyntax)Visit(node.ParameterName);
      var nameSuffix = (MarkupTextLiteralSyntax)Visit(node.NameSuffix);
      var equalsToken = (SyntaxToken)Visit(node.EqualsToken);
      var valuePrefix = (MarkupTextLiteralSyntax)Visit(node.ValuePrefix);
      var value = (MarkupTagHelperAttributeValueSyntax)Visit(node.Value);
      var valueSuffix = (MarkupTextLiteralSyntax)Visit(node.ValueSuffix);
      return node.Update(namePrefix, transition, name, colon, parameterName, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public override GreenNode VisitMarkupMinimizedTagHelperDirectiveAttribute(MarkupMinimizedTagHelperDirectiveAttributeSyntax node)
    {
      var namePrefix = (MarkupTextLiteralSyntax)Visit(node.NamePrefix);
      var transition = (RazorMetaCodeSyntax)Visit(node.Transition);
      var name = (MarkupTextLiteralSyntax)Visit(node.Name);
      var colon = (RazorMetaCodeSyntax)Visit(node.Colon);
      var parameterName = (MarkupTextLiteralSyntax)Visit(node.ParameterName);
      return node.Update(namePrefix, transition, name, colon, parameterName);
    }

    public override GreenNode VisitCSharpCodeBlock(CSharpCodeBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override GreenNode VisitCSharpTransition(CSharpTransitionSyntax node)
    {
      var transition = (SyntaxToken)Visit(node.Transition);
      return node.Update(transition, node.ChunkGenerator);
    }

    public override GreenNode VisitCSharpStatementLiteral(CSharpStatementLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens, node.ChunkGenerator);
    }

    public override GreenNode VisitCSharpExpressionLiteral(CSharpExpressionLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens, node.ChunkGenerator);
    }

    public override GreenNode VisitCSharpEphemeralTextLiteral(CSharpEphemeralTextLiteralSyntax node)
    {
      var literalTokens = VisitList(node.LiteralTokens);
      return node.Update(literalTokens, node.ChunkGenerator);
    }

    public override GreenNode VisitCSharpTemplateBlock(CSharpTemplateBlockSyntax node)
    {
      var children = VisitList(node.Children);
      return node.Update(children);
    }

    public override GreenNode VisitCSharpStatement(CSharpStatementSyntax node)
    {
      var transition = (CSharpTransitionSyntax)Visit(node.Transition);
      var body = (CSharpSyntaxNode)Visit(node.Body);
      return node.Update(transition, body);
    }

    public override GreenNode VisitCSharpStatementBody(CSharpStatementBodySyntax node)
    {
      var openBrace = (RazorMetaCodeSyntax)Visit(node.OpenBrace);
      var cSharpCode = (CSharpCodeBlockSyntax)Visit(node.CSharpCode);
      var closeBrace = (RazorMetaCodeSyntax)Visit(node.CloseBrace);
      return node.Update(openBrace, cSharpCode, closeBrace);
    }

    public override GreenNode VisitCSharpExplicitExpression(CSharpExplicitExpressionSyntax node)
    {
      var transition = (CSharpTransitionSyntax)Visit(node.Transition);
      var body = (CSharpSyntaxNode)Visit(node.Body);
      return node.Update(transition, body);
    }

    public override GreenNode VisitCSharpExplicitExpressionBody(CSharpExplicitExpressionBodySyntax node)
    {
      var openParen = (RazorMetaCodeSyntax)Visit(node.OpenParen);
      var cSharpCode = (CSharpCodeBlockSyntax)Visit(node.CSharpCode);
      var closeParen = (RazorMetaCodeSyntax)Visit(node.CloseParen);
      return node.Update(openParen, cSharpCode, closeParen);
    }

    public override GreenNode VisitCSharpImplicitExpression(CSharpImplicitExpressionSyntax node)
    {
      var transition = (CSharpTransitionSyntax)Visit(node.Transition);
      var body = (CSharpSyntaxNode)Visit(node.Body);
      return node.Update(transition, body);
    }

    public override GreenNode VisitCSharpImplicitExpressionBody(CSharpImplicitExpressionBodySyntax node)
    {
      var cSharpCode = (CSharpCodeBlockSyntax)Visit(node.CSharpCode);
      return node.Update(cSharpCode);
    }

    public override GreenNode VisitRazorDirective(RazorDirectiveSyntax node)
    {
      var transition = (CSharpTransitionSyntax)Visit(node.Transition);
      var body = (CSharpSyntaxNode)Visit(node.Body);
      return node.Update(transition, body);
    }

    public override GreenNode VisitRazorDirectiveBody(RazorDirectiveBodySyntax node)
    {
      var keyword = (RazorSyntaxNode)Visit(node.Keyword);
      var cSharpCode = (CSharpCodeBlockSyntax)Visit(node.CSharpCode);
      return node.Update(keyword, cSharpCode);
    }
  }

  internal static partial class SyntaxFactory
  {
    public static RazorDocumentSyntax RazorDocument(RazorBlockSyntax document, SyntaxToken endOfFile)
    {
      if (document == null)
        throw new ArgumentNullException(nameof(document));
      if (endOfFile == null)
        throw new ArgumentNullException(nameof(endOfFile));
      switch (endOfFile.Kind)
      {
        case SyntaxKind.EndOfFile:
          break;
        default:
          throw new ArgumentException("endOfFile");
      }

      var result = new RazorDocumentSyntax(SyntaxKind.RazorDocument, document, endOfFile);

      return result;
    }

    public static RazorCommentBlockSyntax RazorCommentBlock(SyntaxToken startCommentTransition, SyntaxToken startCommentStar, SyntaxToken comment, SyntaxToken endCommentStar, SyntaxToken endCommentTransition)
    {
      if (startCommentTransition == null)
        throw new ArgumentNullException(nameof(startCommentTransition));
      switch (startCommentTransition.Kind)
      {
        case SyntaxKind.RazorCommentTransition:
          break;
        default:
          throw new ArgumentException("startCommentTransition");
      }
      if (startCommentStar == null)
        throw new ArgumentNullException(nameof(startCommentStar));
      switch (startCommentStar.Kind)
      {
        case SyntaxKind.RazorCommentStar:
          break;
        default:
          throw new ArgumentException("startCommentStar");
      }
      if (comment == null)
        throw new ArgumentNullException(nameof(comment));
      switch (comment.Kind)
      {
        case SyntaxKind.RazorCommentLiteral:
          break;
        default:
          throw new ArgumentException("comment");
      }
      if (endCommentStar == null)
        throw new ArgumentNullException(nameof(endCommentStar));
      switch (endCommentStar.Kind)
      {
        case SyntaxKind.RazorCommentStar:
          break;
        default:
          throw new ArgumentException("endCommentStar");
      }
      if (endCommentTransition == null)
        throw new ArgumentNullException(nameof(endCommentTransition));
      switch (endCommentTransition.Kind)
      {
        case SyntaxKind.RazorCommentTransition:
          break;
        default:
          throw new ArgumentException("endCommentTransition");
      }

      return new RazorCommentBlockSyntax(SyntaxKind.RazorComment, startCommentTransition, startCommentStar, comment, endCommentStar, endCommentTransition);
    }

    public static RazorMetaCodeSyntax RazorMetaCode(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> metaCode, ISpanChunkGenerator chunkGenerator)
    {

      var result = new RazorMetaCodeSyntax(SyntaxKind.RazorMetaCode, metaCode.Node, chunkGenerator);

      return result;
    }

    public static GenericBlockSyntax GenericBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {

      var result = new GenericBlockSyntax(SyntaxKind.GenericBlock, children.Node);

      return result;
    }

    public static UnclassifiedTextLiteralSyntax UnclassifiedTextLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {

      var result = new UnclassifiedTextLiteralSyntax(SyntaxKind.UnclassifiedTextLiteral, literalTokens.Node, chunkGenerator);

      return result;
    }

    public static MarkupBlockSyntax MarkupBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {

      var result = new MarkupBlockSyntax(SyntaxKind.MarkupBlock, children.Node);

      return result;
    }

    public static MarkupTransitionSyntax MarkupTransition(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> transitionTokens, ISpanChunkGenerator chunkGenerator)
    {

      var result = new MarkupTransitionSyntax(SyntaxKind.MarkupTransition, transitionTokens.Node, chunkGenerator);

      return result;
    }

    public static MarkupTextLiteralSyntax MarkupTextLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {

      var result = new MarkupTextLiteralSyntax(SyntaxKind.MarkupTextLiteral, literalTokens.Node, chunkGenerator);

      return result;
    }

    public static MarkupEphemeralTextLiteralSyntax MarkupEphemeralTextLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {

      var result = new MarkupEphemeralTextLiteralSyntax(SyntaxKind.MarkupEphemeralTextLiteral, literalTokens.Node, chunkGenerator);

      return result;
    }

    public static MarkupCommentBlockSyntax MarkupCommentBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {

      var result = new MarkupCommentBlockSyntax(SyntaxKind.MarkupCommentBlock, children.Node);

      return result;
    }

    public static MarkupMinimizedAttributeBlockSyntax MarkupMinimizedAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
      if (name == null)
        throw new ArgumentNullException(nameof(name));

      var result = new MarkupMinimizedAttributeBlockSyntax(SyntaxKind.MarkupMinimizedAttributeBlock, namePrefix, name);

      return result;
    }

    public static MarkupAttributeBlockSyntax MarkupAttributeBlock(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, RazorBlockSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      if (equalsToken == null)
        throw new ArgumentNullException(nameof(equalsToken));
      switch (equalsToken.Kind)
      {
        case SyntaxKind.Equals:
          break;
        default:
          throw new ArgumentException("equalsToken");
      }

      return new MarkupAttributeBlockSyntax(SyntaxKind.MarkupAttributeBlock, namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public static MarkupMiscAttributeContentSyntax MarkupMiscAttributeContent(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {

      var result = new MarkupMiscAttributeContentSyntax(SyntaxKind.MarkupMiscAttributeContent, children.Node);

      return result;
    }

    public static MarkupLiteralAttributeValueSyntax MarkupLiteralAttributeValue(MarkupTextLiteralSyntax prefix, MarkupTextLiteralSyntax value)
    {

      var result = new MarkupLiteralAttributeValueSyntax(SyntaxKind.MarkupLiteralAttributeValue, prefix, value);

      return result;
    }

    public static MarkupDynamicAttributeValueSyntax MarkupDynamicAttributeValue(MarkupTextLiteralSyntax prefix, RazorBlockSyntax value)
    {
      if (value == null)
        throw new ArgumentNullException(nameof(value));

      var result = new MarkupDynamicAttributeValueSyntax(SyntaxKind.MarkupDynamicAttributeValue, prefix, value);

      return result;
    }

    public static MarkupElementSyntax MarkupElement(MarkupStartTagSyntax startTag, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> body, MarkupEndTagSyntax endTag)
    {

      var result = new MarkupElementSyntax(SyntaxKind.MarkupElement, startTag, body.Node, endTag);

      return result;
    }

    public static MarkupStartTagSyntax MarkupStartTag(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
      if (openAngle == null)
        throw new ArgumentNullException(nameof(openAngle));
      switch (openAngle.Kind)
      {
        case SyntaxKind.OpenAngle:
          break;
        default:
          throw new ArgumentException("openAngle");
      }
      if (bang != null)
      {
      switch (bang.Kind)
      {
        case SyntaxKind.Bang:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("bang");
      }
      }
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      switch (name.Kind)
      {
        case SyntaxKind.Text:
          break;
        default:
          throw new ArgumentException("name");
      }
      if (forwardSlash != null)
      {
      switch (forwardSlash.Kind)
      {
        case SyntaxKind.ForwardSlash:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("forwardSlash");
      }
      }
      if (closeAngle == null)
        throw new ArgumentNullException(nameof(closeAngle));
      switch (closeAngle.Kind)
      {
        case SyntaxKind.CloseAngle:
          break;
        default:
          throw new ArgumentException("closeAngle");
      }

      return new MarkupStartTagSyntax(SyntaxKind.MarkupStartTag, openAngle, bang, name, attributes.Node, forwardSlash, closeAngle, chunkGenerator);
    }

    public static MarkupEndTagSyntax MarkupEndTag(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
      if (openAngle == null)
        throw new ArgumentNullException(nameof(openAngle));
      switch (openAngle.Kind)
      {
        case SyntaxKind.OpenAngle:
          break;
        default:
          throw new ArgumentException("openAngle");
      }
      if (forwardSlash == null)
        throw new ArgumentNullException(nameof(forwardSlash));
      switch (forwardSlash.Kind)
      {
        case SyntaxKind.ForwardSlash:
          break;
        default:
          throw new ArgumentException("forwardSlash");
      }
      if (bang != null)
      {
      switch (bang.Kind)
      {
        case SyntaxKind.Bang:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("bang");
      }
      }
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      switch (name.Kind)
      {
        case SyntaxKind.Text:
          break;
        default:
          throw new ArgumentException("name");
      }
      if (closeAngle == null)
        throw new ArgumentNullException(nameof(closeAngle));
      switch (closeAngle.Kind)
      {
        case SyntaxKind.CloseAngle:
          break;
        default:
          throw new ArgumentException("closeAngle");
      }

      return new MarkupEndTagSyntax(SyntaxKind.MarkupEndTag, openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
    }

    public static MarkupTagHelperElementSyntax MarkupTagHelperElement(MarkupTagHelperStartTagSyntax startTag, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> body, MarkupTagHelperEndTagSyntax endTag)
    {
      if (startTag == null)
        throw new ArgumentNullException(nameof(startTag));

      var result = new MarkupTagHelperElementSyntax(SyntaxKind.MarkupTagHelperElement, startTag, body.Node, endTag);

      return result;
    }

    public static MarkupTagHelperStartTagSyntax MarkupTagHelperStartTag(SyntaxToken openAngle, SyntaxToken bang, SyntaxToken name, Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> attributes, SyntaxToken forwardSlash, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
      if (openAngle == null)
        throw new ArgumentNullException(nameof(openAngle));
      switch (openAngle.Kind)
      {
        case SyntaxKind.OpenAngle:
          break;
        default:
          throw new ArgumentException("openAngle");
      }
      if (bang != null)
      {
      switch (bang.Kind)
      {
        case SyntaxKind.Bang:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("bang");
      }
      }
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      switch (name.Kind)
      {
        case SyntaxKind.Text:
          break;
        default:
          throw new ArgumentException("name");
      }
      if (forwardSlash != null)
      {
      switch (forwardSlash.Kind)
      {
        case SyntaxKind.ForwardSlash:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("forwardSlash");
      }
      }
      if (closeAngle == null)
        throw new ArgumentNullException(nameof(closeAngle));
      switch (closeAngle.Kind)
      {
        case SyntaxKind.CloseAngle:
          break;
        default:
          throw new ArgumentException("closeAngle");
      }

      return new MarkupTagHelperStartTagSyntax(SyntaxKind.MarkupTagHelperStartTag, openAngle, bang, name, attributes.Node, forwardSlash, closeAngle, chunkGenerator);
    }

    public static MarkupTagHelperEndTagSyntax MarkupTagHelperEndTag(SyntaxToken openAngle, SyntaxToken forwardSlash, SyntaxToken bang, SyntaxToken name, MarkupMiscAttributeContentSyntax miscAttributeContent, SyntaxToken closeAngle, ISpanChunkGenerator chunkGenerator)
    {
      if (openAngle == null)
        throw new ArgumentNullException(nameof(openAngle));
      switch (openAngle.Kind)
      {
        case SyntaxKind.OpenAngle:
          break;
        default:
          throw new ArgumentException("openAngle");
      }
      if (forwardSlash == null)
        throw new ArgumentNullException(nameof(forwardSlash));
      switch (forwardSlash.Kind)
      {
        case SyntaxKind.ForwardSlash:
          break;
        default:
          throw new ArgumentException("forwardSlash");
      }
      if (bang != null)
      {
      switch (bang.Kind)
      {
        case SyntaxKind.Bang:
        case SyntaxKind.None:
          break;
        default:
          throw new ArgumentException("bang");
      }
      }
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      switch (name.Kind)
      {
        case SyntaxKind.Text:
          break;
        default:
          throw new ArgumentException("name");
      }
      if (closeAngle == null)
        throw new ArgumentNullException(nameof(closeAngle));
      switch (closeAngle.Kind)
      {
        case SyntaxKind.CloseAngle:
          break;
        default:
          throw new ArgumentException("closeAngle");
      }

      return new MarkupTagHelperEndTagSyntax(SyntaxKind.MarkupTagHelperEndTag, openAngle, forwardSlash, bang, name, miscAttributeContent, closeAngle, chunkGenerator);
    }

    public static MarkupTagHelperAttributeSyntax MarkupTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      if (equalsToken == null)
        throw new ArgumentNullException(nameof(equalsToken));
      switch (equalsToken.Kind)
      {
        case SyntaxKind.Equals:
          break;
        default:
          throw new ArgumentException("equalsToken");
      }
      if (value == null)
        throw new ArgumentNullException(nameof(value));

      return new MarkupTagHelperAttributeSyntax(SyntaxKind.MarkupTagHelperAttribute, namePrefix, name, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public static MarkupMinimizedTagHelperAttributeSyntax MarkupMinimizedTagHelperAttribute(MarkupTextLiteralSyntax namePrefix, MarkupTextLiteralSyntax name)
    {
      if (name == null)
        throw new ArgumentNullException(nameof(name));

      var result = new MarkupMinimizedTagHelperAttributeSyntax(SyntaxKind.MarkupMinimizedTagHelperAttribute, namePrefix, name);

      return result;
    }

    public static MarkupTagHelperAttributeValueSyntax MarkupTagHelperAttributeValue(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {

      var result = new MarkupTagHelperAttributeValueSyntax(SyntaxKind.MarkupTagHelperAttributeValue, children.Node);

      return result;
    }

    public static MarkupTagHelperDirectiveAttributeSyntax MarkupTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName, MarkupTextLiteralSyntax nameSuffix, SyntaxToken equalsToken, MarkupTextLiteralSyntax valuePrefix, MarkupTagHelperAttributeValueSyntax value, MarkupTextLiteralSyntax valueSuffix)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (name == null)
        throw new ArgumentNullException(nameof(name));
      if (equalsToken == null)
        throw new ArgumentNullException(nameof(equalsToken));
      switch (equalsToken.Kind)
      {
        case SyntaxKind.Equals:
          break;
        default:
          throw new ArgumentException("equalsToken");
      }
      if (value == null)
        throw new ArgumentNullException(nameof(value));

      return new MarkupTagHelperDirectiveAttributeSyntax(SyntaxKind.MarkupTagHelperDirectiveAttribute, namePrefix, transition, name, colon, parameterName, nameSuffix, equalsToken, valuePrefix, value, valueSuffix);
    }

    public static MarkupMinimizedTagHelperDirectiveAttributeSyntax MarkupMinimizedTagHelperDirectiveAttribute(MarkupTextLiteralSyntax namePrefix, RazorMetaCodeSyntax transition, MarkupTextLiteralSyntax name, RazorMetaCodeSyntax colon, MarkupTextLiteralSyntax parameterName)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (name == null)
        throw new ArgumentNullException(nameof(name));

      return new MarkupMinimizedTagHelperDirectiveAttributeSyntax(SyntaxKind.MarkupMinimizedTagHelperDirectiveAttribute, namePrefix, transition, name, colon, parameterName);
    }

    public static CSharpCodeBlockSyntax CSharpCodeBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {

      var result = new CSharpCodeBlockSyntax(SyntaxKind.CSharpCodeBlock, children.Node);

      return result;
    }

    public static CSharpTransitionSyntax CSharpTransition(SyntaxToken transition, ISpanChunkGenerator chunkGenerator)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      switch (transition.Kind)
      {
        case SyntaxKind.Transition:
          break;
        default:
          throw new ArgumentException("transition");
      }

      var result = new CSharpTransitionSyntax(SyntaxKind.CSharpTransition, transition, chunkGenerator);

      return result;
    }

    public static CSharpStatementLiteralSyntax CSharpStatementLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {

      var result = new CSharpStatementLiteralSyntax(SyntaxKind.CSharpStatementLiteral, literalTokens.Node, chunkGenerator);

      return result;
    }

    public static CSharpExpressionLiteralSyntax CSharpExpressionLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {

      var result = new CSharpExpressionLiteralSyntax(SyntaxKind.CSharpExpressionLiteral, literalTokens.Node, chunkGenerator);

      return result;
    }

    public static CSharpEphemeralTextLiteralSyntax CSharpEphemeralTextLiteral(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<SyntaxToken> literalTokens, ISpanChunkGenerator chunkGenerator)
    {

      var result = new CSharpEphemeralTextLiteralSyntax(SyntaxKind.CSharpEphemeralTextLiteral, literalTokens.Node, chunkGenerator);

      return result;
    }

    public static CSharpTemplateBlockSyntax CSharpTemplateBlock(Microsoft.AspNetCore.Razor.Language.Syntax.InternalSyntax.SyntaxList<RazorSyntaxNode> children)
    {

      var result = new CSharpTemplateBlockSyntax(SyntaxKind.CSharpTemplateBlock, children.Node);

      return result;
    }

    public static CSharpStatementSyntax CSharpStatement(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (body == null)
        throw new ArgumentNullException(nameof(body));

      var result = new CSharpStatementSyntax(SyntaxKind.CSharpStatement, transition, body);

      return result;
    }

    public static CSharpStatementBodySyntax CSharpStatementBody(RazorMetaCodeSyntax openBrace, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeBrace)
    {
      if (openBrace == null)
        throw new ArgumentNullException(nameof(openBrace));
      if (cSharpCode == null)
        throw new ArgumentNullException(nameof(cSharpCode));
      if (closeBrace == null)
        throw new ArgumentNullException(nameof(closeBrace));

      var result = new CSharpStatementBodySyntax(SyntaxKind.CSharpStatementBody, openBrace, cSharpCode, closeBrace);

      return result;
    }

    public static CSharpExplicitExpressionSyntax CSharpExplicitExpression(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (body == null)
        throw new ArgumentNullException(nameof(body));

      var result = new CSharpExplicitExpressionSyntax(SyntaxKind.CSharpExplicitExpression, transition, body);

      return result;
    }

    public static CSharpExplicitExpressionBodySyntax CSharpExplicitExpressionBody(RazorMetaCodeSyntax openParen, CSharpCodeBlockSyntax cSharpCode, RazorMetaCodeSyntax closeParen)
    {
      if (openParen == null)
        throw new ArgumentNullException(nameof(openParen));
      if (cSharpCode == null)
        throw new ArgumentNullException(nameof(cSharpCode));
      if (closeParen == null)
        throw new ArgumentNullException(nameof(closeParen));

      var result = new CSharpExplicitExpressionBodySyntax(SyntaxKind.CSharpExplicitExpressionBody, openParen, cSharpCode, closeParen);

      return result;
    }

    public static CSharpImplicitExpressionSyntax CSharpImplicitExpression(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (body == null)
        throw new ArgumentNullException(nameof(body));

      var result = new CSharpImplicitExpressionSyntax(SyntaxKind.CSharpImplicitExpression, transition, body);

      return result;
    }

    public static CSharpImplicitExpressionBodySyntax CSharpImplicitExpressionBody(CSharpCodeBlockSyntax cSharpCode)
    {
      if (cSharpCode == null)
        throw new ArgumentNullException(nameof(cSharpCode));

      var result = new CSharpImplicitExpressionBodySyntax(SyntaxKind.CSharpImplicitExpressionBody, cSharpCode);

      return result;
    }

    public static RazorDirectiveSyntax RazorDirective(CSharpTransitionSyntax transition, CSharpSyntaxNode body)
    {
      if (transition == null)
        throw new ArgumentNullException(nameof(transition));
      if (body == null)
        throw new ArgumentNullException(nameof(body));

      var result = new RazorDirectiveSyntax(SyntaxKind.RazorDirective, transition, body);

      return result;
    }

    public static RazorDirectiveBodySyntax RazorDirectiveBody(RazorSyntaxNode keyword, CSharpCodeBlockSyntax cSharpCode)
    {
      if (keyword == null)
        throw new ArgumentNullException(nameof(keyword));

      var result = new RazorDirectiveBodySyntax(SyntaxKind.RazorDirectiveBody, keyword, cSharpCode);

      return result;
    }

    internal static IEnumerable<Type> GetNodeTypes()
    {
        return new Type[] {
           typeof(RazorDocumentSyntax),
           typeof(RazorCommentBlockSyntax),
           typeof(RazorMetaCodeSyntax),
           typeof(GenericBlockSyntax),
           typeof(UnclassifiedTextLiteralSyntax),
           typeof(MarkupBlockSyntax),
           typeof(MarkupTransitionSyntax),
           typeof(MarkupTextLiteralSyntax),
           typeof(MarkupEphemeralTextLiteralSyntax),
           typeof(MarkupCommentBlockSyntax),
           typeof(MarkupMinimizedAttributeBlockSyntax),
           typeof(MarkupAttributeBlockSyntax),
           typeof(MarkupMiscAttributeContentSyntax),
           typeof(MarkupLiteralAttributeValueSyntax),
           typeof(MarkupDynamicAttributeValueSyntax),
           typeof(MarkupElementSyntax),
           typeof(MarkupStartTagSyntax),
           typeof(MarkupEndTagSyntax),
           typeof(MarkupTagHelperElementSyntax),
           typeof(MarkupTagHelperStartTagSyntax),
           typeof(MarkupTagHelperEndTagSyntax),
           typeof(MarkupTagHelperAttributeSyntax),
           typeof(MarkupMinimizedTagHelperAttributeSyntax),
           typeof(MarkupTagHelperAttributeValueSyntax),
           typeof(MarkupTagHelperDirectiveAttributeSyntax),
           typeof(MarkupMinimizedTagHelperDirectiveAttributeSyntax),
           typeof(CSharpCodeBlockSyntax),
           typeof(CSharpTransitionSyntax),
           typeof(CSharpStatementLiteralSyntax),
           typeof(CSharpExpressionLiteralSyntax),
           typeof(CSharpEphemeralTextLiteralSyntax),
           typeof(CSharpTemplateBlockSyntax),
           typeof(CSharpStatementSyntax),
           typeof(CSharpStatementBodySyntax),
           typeof(CSharpExplicitExpressionSyntax),
           typeof(CSharpExplicitExpressionBodySyntax),
           typeof(CSharpImplicitExpressionSyntax),
           typeof(CSharpImplicitExpressionBodySyntax),
           typeof(RazorDirectiveSyntax),
           typeof(RazorDirectiveBodySyntax)
        };
    }
  }
}
