// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, NavigationDirection};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "AdwSwipeable")]
    pub struct Swipeable(Interface<ffi::AdwSwipeable, ffi::AdwSwipeableInterface>) @requires gtk::Widget, gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::adw_swipeable_get_type(),
    }
}

impl Swipeable {
    pub const NONE: Option<&'static Swipeable> = None;
}

pub trait SwipeableExt: IsA<Swipeable> + 'static {
    #[doc(alias = "adw_swipeable_get_cancel_progress")]
    #[doc(alias = "get_cancel_progress")]
    fn cancel_progress(&self) -> f64 {
        unsafe { ffi::adw_swipeable_get_cancel_progress(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "adw_swipeable_get_distance")]
    #[doc(alias = "get_distance")]
    fn distance(&self) -> f64 {
        unsafe { ffi::adw_swipeable_get_distance(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "adw_swipeable_get_progress")]
    #[doc(alias = "get_progress")]
    fn progress(&self) -> f64 {
        unsafe { ffi::adw_swipeable_get_progress(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "adw_swipeable_get_snap_points")]
    #[doc(alias = "get_snap_points")]
    fn snap_points(&self) -> Vec<f64> {
        unsafe {
            let mut n_snap_points = std::mem::MaybeUninit::uninit();
            let ret = FromGlibContainer::from_glib_full_num(
                ffi::adw_swipeable_get_snap_points(
                    self.as_ref().to_glib_none().0,
                    n_snap_points.as_mut_ptr(),
                ),
                n_snap_points.assume_init() as _,
            );
            ret
        }
    }

    #[doc(alias = "adw_swipeable_get_swipe_area")]
    #[doc(alias = "get_swipe_area")]
    fn swipe_area(
        &self,
        navigation_direction: NavigationDirection,
        is_drag: bool,
    ) -> gdk::Rectangle {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            ffi::adw_swipeable_get_swipe_area(
                self.as_ref().to_glib_none().0,
                navigation_direction.into_glib(),
                is_drag.into_glib(),
                rect.to_glib_none_mut().0,
            );
            rect
        }
    }
}

impl<O: IsA<Swipeable>> SwipeableExt for O {}
