// # Copyright (C) 2025 Francois Marier
//
// Email-Reminder is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 3 of the
// License, or (at your option) any later version.
//
// Email-Reminder is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Email-Reminder; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301, USA.
package events

import (
	"encoding/xml"
	"strings"
)

type ReminderType string

const (
	ReminderTypeSameDay    ReminderType = "same day"
	ReminderTypeDaysBefore ReminderType = "days before"
)

func (rt *ReminderType) UnmarshalText(text []byte) error {
	v := strings.TrimSpace(strings.ToLower(string(text)))
	switch v {
	case string(ReminderTypeSameDay):
		*rt = ReminderTypeSameDay
	case string(ReminderTypeDaysBefore):
		*rt = ReminderTypeDaysBefore
	default:
		*rt = ReminderType(v)
	}
	return nil
}

type Reminder struct {
	XMLName xml.Name     `xml:"reminder"`
	Type    ReminderType `xml:"type,attr"`
	Days    int          `xml:",chardata"`
}
