# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import AzureDigitalTwinsAPIConfiguration
from .._utils.serialization import Deserializer, Serializer

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_add_request(
    *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-31"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/models")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if traceparent is not None:
        _headers["traceparent"] = _SERIALIZER.header("traceparent", traceparent, "str")
    if tracestate is not None:
        _headers["tracestate"] = _SERIALIZER.header("tracestate", tracestate, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_request(
    *,
    traceparent: Optional[str] = None,
    tracestate: Optional[str] = None,
    dependencies_for: Optional[List[str]] = None,
    include_model_definition: bool = False,
    max_items_per_page: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-31"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/models")

    # Construct parameters
    if dependencies_for is not None:
        _params["dependenciesFor"] = [
            _SERIALIZER.query("dependencies_for", q, "str") if q is not None else "" for q in dependencies_for
        ]
    if include_model_definition is not None:
        _params["includeModelDefinition"] = _SERIALIZER.query(
            "include_model_definition", include_model_definition, "bool"
        )
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if traceparent is not None:
        _headers["traceparent"] = _SERIALIZER.header("traceparent", traceparent, "str")
    if tracestate is not None:
        _headers["tracestate"] = _SERIALIZER.header("tracestate", tracestate, "str")
    if max_items_per_page is not None:
        _headers["max-items-per-page"] = _SERIALIZER.header("max_items_per_page", max_items_per_page, "int")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_by_id_request(
    id: str,
    *,
    traceparent: Optional[str] = None,
    tracestate: Optional[str] = None,
    include_model_definition: bool = False,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-31"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/models/{id}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if include_model_definition is not None:
        _params["includeModelDefinition"] = _SERIALIZER.query(
            "include_model_definition", include_model_definition, "bool"
        )
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if traceparent is not None:
        _headers["traceparent"] = _SERIALIZER.header("traceparent", traceparent, "str")
    if tracestate is not None:
        _headers["tracestate"] = _SERIALIZER.header("tracestate", tracestate, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_request(
    id: str, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-31"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/models/{id}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if traceparent is not None:
        _headers["traceparent"] = _SERIALIZER.header("traceparent", traceparent, "str")
    if tracestate is not None:
        _headers["tracestate"] = _SERIALIZER.header("tracestate", tracestate, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    id: str, *, traceparent: Optional[str] = None, tracestate: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-10-31"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/models/{id}")
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if traceparent is not None:
        _headers["traceparent"] = _SERIALIZER.header("traceparent", traceparent, "str")
    if tracestate is not None:
        _headers["tracestate"] = _SERIALIZER.header("tracestate", tracestate, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


class DigitalTwinModelsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.digitaltwins.core.AzureDigitalTwinsAPI`'s
        :attr:`digital_twin_models` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AzureDigitalTwinsAPIConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def add(
        self,
        models: List[JSON],
        digital_twin_models_add_options: Optional[_models.DigitalTwinModelsAddOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DigitalTwinsModelData]:
        """Uploads one or more models. When any error occurs, no models are uploaded.
        Status codes:


        * 201 Created
        * 400 Bad Request

          * DTDLParserError - The models provided are not valid DTDL.
          * InvalidArgument - The model id is invalid.
          * LimitExceeded - The maximum number of model ids allowed in 'dependenciesFor' has been
        reached.
          * ModelVersionNotSupported - The version of DTDL used is not supported.

        * 409 Conflict

          * ModelAlreadyExists - The model provided already exists.

        :param models: An array of models to add. Required.
        :type models: list[JSON]
        :param digital_twin_models_add_options: Parameter group. Default value is None.
        :type digital_twin_models_add_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsAddOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DigitalTwinsModelData or the result of cls(response)
        :rtype: list[~azure.digitaltwins.core.models.DigitalTwinsModelData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def add(
        self,
        models: IO[bytes],
        digital_twin_models_add_options: Optional[_models.DigitalTwinModelsAddOptions] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DigitalTwinsModelData]:
        """Uploads one or more models. When any error occurs, no models are uploaded.
        Status codes:


        * 201 Created
        * 400 Bad Request

          * DTDLParserError - The models provided are not valid DTDL.
          * InvalidArgument - The model id is invalid.
          * LimitExceeded - The maximum number of model ids allowed in 'dependenciesFor' has been
        reached.
          * ModelVersionNotSupported - The version of DTDL used is not supported.

        * 409 Conflict

          * ModelAlreadyExists - The model provided already exists.

        :param models: An array of models to add. Required.
        :type models: IO[bytes]
        :param digital_twin_models_add_options: Parameter group. Default value is None.
        :type digital_twin_models_add_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsAddOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DigitalTwinsModelData or the result of cls(response)
        :rtype: list[~azure.digitaltwins.core.models.DigitalTwinsModelData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def add(
        self,
        models: Union[List[JSON], IO[bytes]],
        digital_twin_models_add_options: Optional[_models.DigitalTwinModelsAddOptions] = None,
        **kwargs: Any
    ) -> List[_models.DigitalTwinsModelData]:
        """Uploads one or more models. When any error occurs, no models are uploaded.
        Status codes:


        * 201 Created
        * 400 Bad Request

          * DTDLParserError - The models provided are not valid DTDL.
          * InvalidArgument - The model id is invalid.
          * LimitExceeded - The maximum number of model ids allowed in 'dependenciesFor' has been
        reached.
          * ModelVersionNotSupported - The version of DTDL used is not supported.

        * 409 Conflict

          * ModelAlreadyExists - The model provided already exists.

        :param models: An array of models to add. Is either a [JSON] type or a IO[bytes] type.
         Required.
        :type models: list[JSON] or IO[bytes]
        :param digital_twin_models_add_options: Parameter group. Default value is None.
        :type digital_twin_models_add_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsAddOptions
        :return: list of DigitalTwinsModelData or the result of cls(response)
        :rtype: list[~azure.digitaltwins.core.models.DigitalTwinsModelData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.DigitalTwinsModelData]] = kwargs.pop("cls", None)

        _traceparent = None
        _tracestate = None
        if digital_twin_models_add_options is not None:
            _traceparent = digital_twin_models_add_options.traceparent
            _tracestate = digital_twin_models_add_options.tracestate
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(models, (IOBase, bytes)):
            _content = models
        else:
            _json = self._serialize.body(models, "[object]")

        _request = build_add_request(
            traceparent=_traceparent,
            tracestate=_tracestate,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("[DigitalTwinsModelData]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self,
        dependencies_for: Optional[List[str]] = None,
        include_model_definition: bool = False,
        digital_twin_models_list_options: Optional[_models.DigitalTwinModelsListOptions] = None,
        **kwargs: Any
    ) -> ItemPaged["_models.DigitalTwinsModelData"]:
        """Retrieves model metadata and, optionally, model definitions.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The model id is invalid.
          * LimitExceeded - The maximum number of model ids allowed in 'dependenciesFor' has been
        reached.

        * 404 Not Found

          * ModelNotFound - The model was not found.

        :param dependencies_for: If specified, only return the set of the specified models along with
         their dependencies. If omitted, all models are retrieved. Default value is None.
        :type dependencies_for: list[str]
        :param include_model_definition: When true the model definition will be returned as part of the
         result. Default value is False.
        :type include_model_definition: bool
        :param digital_twin_models_list_options: Parameter group. Default value is None.
        :type digital_twin_models_list_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsListOptions
        :return: An iterator like instance of either DigitalTwinsModelData or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.digitaltwins.core.models.DigitalTwinsModelData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.PagedDigitalTwinsModelDataCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _traceparent = None
                _tracestate = None
                _max_items_per_page = None
                if digital_twin_models_list_options is not None:
                    _max_items_per_page = digital_twin_models_list_options.max_items_per_page
                    _traceparent = digital_twin_models_list_options.traceparent
                    _tracestate = digital_twin_models_list_options.tracestate

                _request = build_list_request(
                    traceparent=_traceparent,
                    tracestate=_tracestate,
                    dependencies_for=dependencies_for,
                    include_model_definition=include_model_definition,
                    max_items_per_page=_max_items_per_page,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PagedDigitalTwinsModelDataCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_by_id(
        self,
        id: str,
        include_model_definition: bool = False,
        digital_twin_models_get_by_id_options: Optional[_models.DigitalTwinModelsGetByIdOptions] = None,
        **kwargs: Any
    ) -> _models.DigitalTwinsModelData:
        """Retrieves model metadata and optionally the model definition.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The model id is invalid.
          * MissingArgument - The model id was not provided.

        * 404 Not Found

          * ModelNotFound - The model was not found.

        :param id: The id for the model. The id is globally unique and case sensitive. Required.
        :type id: str
        :param include_model_definition: When true the model definition will be returned as part of the
         result. Default value is False.
        :type include_model_definition: bool
        :param digital_twin_models_get_by_id_options: Parameter group. Default value is None.
        :type digital_twin_models_get_by_id_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsGetByIdOptions
        :return: DigitalTwinsModelData or the result of cls(response)
        :rtype: ~azure.digitaltwins.core.models.DigitalTwinsModelData
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DigitalTwinsModelData] = kwargs.pop("cls", None)

        _traceparent = None
        _tracestate = None
        if digital_twin_models_get_by_id_options is not None:
            _traceparent = digital_twin_models_get_by_id_options.traceparent
            _tracestate = digital_twin_models_get_by_id_options.tracestate

        _request = build_get_by_id_request(
            id=id,
            traceparent=_traceparent,
            tracestate=_tracestate,
            include_model_definition=include_model_definition,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DigitalTwinsModelData", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def update(
        self,
        id: str,
        update_model: List[JSON],
        digital_twin_models_update_options: Optional[_models.DigitalTwinModelsUpdateOptions] = None,
        *,
        content_type: str = "application/json-patch+json",
        **kwargs: Any
    ) -> None:
        """Updates the metadata for a model.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The model id is invalid.
          * JsonPatchInvalid - The JSON Patch provided is invalid.
          * MissingArgument - The model id was not provided.

        * 404 Not Found

          * ModelNotFound - The model was not found.

        * 409 Conflict

          * ModelReferencesNotDecommissioned - The model refers to models that are not decommissioned.

        :param id: The id for the model. The id is globally unique and case sensitive. Required.
        :type id: str
        :param update_model: An update specification described by JSON Patch. Only the decommissioned
         property can be replaced. Required.
        :type update_model: list[JSON]
        :param digital_twin_models_update_options: Parameter group. Default value is None.
        :type digital_twin_models_update_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsUpdateOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json-patch+json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update(
        self,
        id: str,
        update_model: IO[bytes],
        digital_twin_models_update_options: Optional[_models.DigitalTwinModelsUpdateOptions] = None,
        *,
        content_type: str = "application/json-patch+json",
        **kwargs: Any
    ) -> None:
        """Updates the metadata for a model.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The model id is invalid.
          * JsonPatchInvalid - The JSON Patch provided is invalid.
          * MissingArgument - The model id was not provided.

        * 404 Not Found

          * ModelNotFound - The model was not found.

        * 409 Conflict

          * ModelReferencesNotDecommissioned - The model refers to models that are not decommissioned.

        :param id: The id for the model. The id is globally unique and case sensitive. Required.
        :type id: str
        :param update_model: An update specification described by JSON Patch. Only the decommissioned
         property can be replaced. Required.
        :type update_model: IO[bytes]
        :param digital_twin_models_update_options: Parameter group. Default value is None.
        :type digital_twin_models_update_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsUpdateOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json-patch+json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update(  # pylint: disable=inconsistent-return-statements
        self,
        id: str,
        update_model: Union[List[JSON], IO[bytes]],
        digital_twin_models_update_options: Optional[_models.DigitalTwinModelsUpdateOptions] = None,
        **kwargs: Any
    ) -> None:
        """Updates the metadata for a model.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The model id is invalid.
          * JsonPatchInvalid - The JSON Patch provided is invalid.
          * MissingArgument - The model id was not provided.

        * 404 Not Found

          * ModelNotFound - The model was not found.

        * 409 Conflict

          * ModelReferencesNotDecommissioned - The model refers to models that are not decommissioned.

        :param id: The id for the model. The id is globally unique and case sensitive. Required.
        :type id: str
        :param update_model: An update specification described by JSON Patch. Only the decommissioned
         property can be replaced. Is either a [JSON] type or a IO[bytes] type. Required.
        :type update_model: list[JSON] or IO[bytes]
        :param digital_twin_models_update_options: Parameter group. Default value is None.
        :type digital_twin_models_update_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsUpdateOptions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _traceparent = None
        _tracestate = None
        if digital_twin_models_update_options is not None:
            _traceparent = digital_twin_models_update_options.traceparent
            _tracestate = digital_twin_models_update_options.tracestate
        content_type = content_type or "application/json-patch+json"
        _json = None
        _content = None
        if isinstance(update_model, (IOBase, bytes)):
            _content = update_model
        else:
            _json = self._serialize.body(update_model, "[object]")

        _request = build_update_request(
            id=id,
            traceparent=_traceparent,
            tracestate=_tracestate,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self,
        id: str,
        digital_twin_models_delete_options: Optional[_models.DigitalTwinModelsDeleteOptions] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a model. A model can only be deleted if no other models reference it.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The model id is invalid.
          * MissingArgument - The model id was not provided.

        * 404 Not Found

          * ModelNotFound - The model was not found.

        * 409 Conflict

          * ModelReferencesNotDeleted - The model refers to models that are not deleted.

        :param id: The id for the model. The id is globally unique and case sensitive. Required.
        :type id: str
        :param digital_twin_models_delete_options: Parameter group. Default value is None.
        :type digital_twin_models_delete_options:
         ~azure.digitaltwins.core.models.DigitalTwinModelsDeleteOptions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _traceparent = None
        _tracestate = None
        if digital_twin_models_delete_options is not None:
            _traceparent = digital_twin_models_delete_options.traceparent
            _tracestate = digital_twin_models_delete_options.tracestate

        _request = build_delete_request(
            id=id,
            traceparent=_traceparent,
            tracestate=_tracestate,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
